/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.AccountTokenChangedListener;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountTokenChangedListener;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "requestExecutorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;)V", "executors", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$WithTokenAuth;", "getExecutor", "account", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "getOrTryToCreateExecutor", "missingTokenHandler", "Lkotlin/Function0;", "", "tokenChanged", "", "Companion", "intellij.vcs.github"})
public final class GithubApiRequestExecutorManager
implements AccountTokenChangedListener {
    private final Map<GithubAccount, GithubApiRequestExecutor.WithTokenAuth> executors;
    private final GithubAccountManager accountManager;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubApiRequestExecutor.Factory requestExecutorFactory;
    public static final Companion Companion = new Companion(null);

    @Override
    public void tokenChanged(@NotNull GithubAccount account) {
        block1: {
            String token2;
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
                token2 = this.accountManager.getTokenForAccount(account);
                if (token2 != null) break block0;
                this.executors.remove(account);
                break block1;
            }
            GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.executors.get(account);
            if (withTokenAuth == null) break block1;
            withTokenAuth.setToken$intellij_vcs_github(token2);
        }
    }

    @Nullable
    public final GithubApiRequestExecutor.WithTokenAuth getExecutor(@NotNull GithubAccount account, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getOrTryToCreateExecutor(account, (Function0<String>)((Function0)new Function0<String>(this, account, project){
            final /* synthetic */ GithubApiRequestExecutorManager this$0;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ Project $project;

            @Nullable
            public final String invoke() {
                return GithubAuthenticationManager.requestNewToken$intellij_vcs_github$default(GithubApiRequestExecutorManager.access$getAuthenticationManager$p(this.this$0), this.$account, this.$project, null, 4, null);
            }
            {
                this.this$0 = githubApiRequestExecutorManager;
                this.$account = githubAccount;
                this.$project = project;
                super(0);
            }
        }));
    }

    @Nullable
    public final GithubApiRequestExecutor.WithTokenAuth getExecutor(@NotNull GithubAccount account, @NotNull Component parentComponent) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull((Object)parentComponent, (String)"parentComponent");
        return this.getOrTryToCreateExecutor(account, (Function0<String>)((Function0)new Function0<String>(this, account, parentComponent){
            final /* synthetic */ GithubApiRequestExecutorManager this$0;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ Component $parentComponent;

            @Nullable
            public final String invoke() {
                return GithubApiRequestExecutorManager.access$getAuthenticationManager$p(this.this$0).requestNewToken$intellij_vcs_github(this.$account, null, this.$parentComponent);
            }
            {
                this.this$0 = githubApiRequestExecutorManager;
                this.$account = githubAccount;
                this.$parentComponent = component;
                super(0);
            }
        }));
    }

    @NotNull
    public final GithubApiRequestExecutor.WithTokenAuth getExecutor(@NotNull GithubAccount account) throws GithubMissingTokenException {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        GithubApiRequestExecutor.WithTokenAuth withTokenAuth = this.getOrTryToCreateExecutor(account, (Function0<String>)new Function0(account){
            final /* synthetic */ GithubAccount $account;

            @NotNull
            public final Void invoke() {
                throw (Throwable)new GithubMissingTokenException(this.$account);
            }
            {
                this.$account = githubAccount;
                super(0);
            }
        });
        if (withTokenAuth == null) {
            Intrinsics.throwNpe();
        }
        return withTokenAuth;
    }

    private final GithubApiRequestExecutor.WithTokenAuth getOrTryToCreateExecutor(GithubAccount account, Function0<String> missingTokenHandler) {
        Object object;
        block7: {
            GithubApiRequestExecutor.WithTokenAuth value$iv;
            block4: {
                Object object2;
                Map<GithubAccount, GithubApiRequestExecutor.WithTokenAuth> $receiver$iv;
                block6: {
                    block5: {
                        $receiver$iv = this.executors;
                        value$iv = $receiver$iv.get(account);
                        if (value$iv != null) break block4;
                        boolean bl = false;
                        Object object3 = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
                        if (object3 == null) {
                            object3 = object2 = (String)missingTokenHandler.invoke();
                        }
                        if (object3 == null) break block5;
                        String string = object2;
                        GithubApiRequestExecutor.Factory factory = this.requestExecutorFactory;
                        String p1 = string;
                        boolean bl2 = false;
                        object2 = factory.create(p1);
                        if (object2 != null) break block6;
                    }
                    return null;
                }
                Object answer$iv = object2;
                $receiver$iv.put(account, (GithubApiRequestExecutor.WithTokenAuth)answer$iv);
                object = answer$iv;
                break block7;
            }
            object = value$iv;
        }
        return object;
    }

    public GithubApiRequestExecutorManager(@NotNull GithubAccountManager accountManager, @NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubApiRequestExecutor.Factory requestExecutorFactory) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutorFactory, (String)"requestExecutorFactory");
        this.accountManager = accountManager;
        this.authenticationManager = authenticationManager;
        this.requestExecutorFactory = requestExecutorFactory;
        GithubApiRequestExecutorManager githubApiRequestExecutorManager = this;
        githubApiRequestExecutorManager.executors = map2 = (Map)new LinkedHashMap();
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect().subscribe(GithubAccountManager.Companion.getACCOUNT_TOKEN_CHANGED_TOPIC(), (Object)this);
    }

    public static final /* synthetic */ GithubAuthenticationManager access$getAuthenticationManager$p(GithubApiRequestExecutorManager $this) {
        return $this.authenticationManager;
    }

    @JvmStatic
    @NotNull
    public static final GithubApiRequestExecutorManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubApiRequestExecutorManager getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(GithubApiRequestExecutorManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubApiRequestExecutorManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

