/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import java.nio.file.Path;

public class ArchiveEntry {
    private final Archive archive;
    private final Path path;
    private final String pathPrefix;
    private long rawFileSize = -1L;
    private long downloadFileSize = -1L;

    public ArchiveEntry(Archive archive, Path path, String pathPrefix) {
        assert (archive.getContentRoot().getFileSystem() == path.getFileSystem());
        this.archive = archive;
        this.path = path;
        this.pathPrefix = pathPrefix;
    }

    public Path getPath() {
        return this.path;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    public long getRawFileSize() {
        return this.rawFileSize;
    }

    public void setDownloadFileSize(long downloadFileSize) {
        this.downloadFileSize = downloadFileSize;
    }

    public long getDownloadFileSize() {
        return this.downloadFileSize;
    }

    public Archive getArchive() {
        return this.archive;
    }

    public String getFullPathString() {
        return this.pathPrefix + this.path.toString();
    }

    public String toString() {
        return String.format("%s: pathPrefix=\"%s\", path=\"%s\"", this.getClass().getSimpleName(), this.pathPrefix, this.path);
    }
}

