/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.workbench.AttachedToolWindow;
import com.android.tools.adtui.workbench.DetachedToolWindowManager;
import com.android.tools.adtui.workbench.LayeredPanel;
import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.MinimizedPanel;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.SidePanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBenchLoadingPanel;
import com.android.tools.adtui.workbench.WorkBenchManager;
import com.google.common.base.Splitter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class WorkBench<T>
extends JBLayeredPane
implements Disposable {
    private final String myName;
    private final PropertiesComponent myPropertiesComponent;
    private final WorkBenchManager myWorkBenchManager;
    private final DetachedToolWindowManager myDetachedToolWindowManager;
    private final FileEditorManager myFileEditorManager;
    private final List<ToolWindowDefinition<T>> myToolDefinitions;
    private final SideModel<T> myModel;
    private final ThreeComponentsSplitter mySplitter;
    private final WorkBenchLoadingPanel myLoadingPanel;
    private final JPanel myMainPanel;
    private final MinimizedPanel<T> myLeftMinimizePanel;
    private final MinimizedPanel<T> myRightMinimizePanel;
    private final AttachedToolWindow.ButtonDragListener<T> myButtonDragListener;
    private final PropertyChangeListener myMyPropertyChangeListener;
    private FileEditor myFileEditor;

    public WorkBench(@NotNull Project project, @NotNull String name, FileEditor fileEditor) {
        if (project == null) {
            WorkBench.$$$reportNull$$$0(0);
        }
        if (name == null) {
            WorkBench.$$$reportNull$$$0(1);
        }
        this(project, name, fileEditor, InitParams.createParams(project), DetachedToolWindowManager.getInstance(project));
    }

    public void init(@NotNull JComponent content, @NotNull T context, @NotNull List<ToolWindowDefinition<T>> definitions) {
        if (content == null) {
            WorkBench.$$$reportNull$$$0(2);
        }
        if (context == null) {
            WorkBench.$$$reportNull$$$0(3);
        }
        if (definitions == null) {
            WorkBench.$$$reportNull$$$0(4);
        }
        if (ScreenReader.isActive()) {
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        }
        this.myLoadingPanel.stopLoading();
        this.myMainPanel.setVisible(true);
        content.addComponentListener(this.createWidthUpdater());
        this.mySplitter.setInnerComponent(content);
        this.myToolDefinitions.addAll(definitions);
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
        this.myModel.setContext(context);
        this.addToolsToModel();
        this.myWorkBenchManager.register(this);
        this.myDetachedToolWindowManager.register(this.myFileEditor, this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.myMyPropertyChangeListener);
    }

    public void setLoadingText(@NotNull String loadingText) {
        if (loadingText == null) {
            WorkBench.$$$reportNull$$$0(5);
        }
        this.myLoadingPanel.setLoadingText(loadingText);
    }

    public void showLoading(@NotNull String message) {
        if (message == null) {
            WorkBench.$$$reportNull$$$0(6);
        }
        this.setLoadingText(message);
        this.myLoadingPanel.startLoading();
    }

    public void hideLoading() {
        this.myLoadingPanel.stopLoading();
    }

    public void loadingStopped(@NotNull String message) {
        if (message == null) {
            WorkBench.$$$reportNull$$$0(7);
        }
        this.myLoadingPanel.abortLoading(message, AllIcons.General.Warning);
    }

    public WorkBenchLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    public void setToolContext(T context) {
        this.myModel.setContext(context);
    }

    public void setFileEditor(FileEditor fileEditor) {
        this.myDetachedToolWindowManager.unregister(this.myFileEditor);
        this.myDetachedToolWindowManager.register(fileEditor, this);
        this.myFileEditor = fileEditor;
        if (fileEditor != null && this.isCurrentEditor(fileEditor)) {
            this.myDetachedToolWindowManager.updateToolWindowsForWorkBench(this);
        }
    }

    public void dispose() {
        this.myWorkBenchManager.unregister(this);
        this.myDetachedToolWindowManager.unregister(this.myFileEditor);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this.myMyPropertyChangeListener);
        this.setToolContext(null);
    }

    WorkBench(@NotNull Project project, @NotNull String name, FileEditor fileEditor, @NotNull InitParams<T> params, @NotNull DetachedToolWindowManager detachedToolWindowManager) {
        if (project == null) {
            WorkBench.$$$reportNull$$$0(8);
        }
        if (name == null) {
            WorkBench.$$$reportNull$$$0(9);
        }
        if (params == null) {
            WorkBench.$$$reportNull$$$0(10);
        }
        if (detachedToolWindowManager == null) {
            WorkBench.$$$reportNull$$$0(11);
        }
        this.myMyPropertyChangeListener = this::autoHide;
        this.myName = name;
        this.myFileEditor = fileEditor;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myWorkBenchManager = WorkBenchManager.getInstance();
        this.myDetachedToolWindowManager = detachedToolWindowManager;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)project);
        this.myToolDefinitions = new ArrayList<ToolWindowDefinition<T>>(4);
        this.myModel = ((InitParams)params).myModel;
        this.myModel.addListener(this::modelChanged);
        this.myButtonDragListener = new MyButtonDragListener();
        this.mySplitter = this.initSplitter(((InitParams)params).mySplitter);
        this.myLeftMinimizePanel = ((InitParams)params).myLeftMinimizePanel;
        this.myRightMinimizePanel = ((InitParams)params).myRightMinimizePanel;
        LayeredPanel<T> layeredPanel = new LayeredPanel<T>(this.myName, (JComponent)this.mySplitter, this.myModel);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add(this.myLeftMinimizePanel, "West");
        this.myMainPanel.add((Component)((Object)layeredPanel), "Center");
        this.myMainPanel.add(this.myRightMinimizePanel, "East");
        this.myLoadingPanel = new WorkBenchLoadingPanel(new BorderLayout(), this, 1000);
        this.myLoadingPanel.add(this.myMainPanel);
        Disposer.register((Disposable)this, (Disposable)this.mySplitter);
        Disposer.register((Disposable)this, layeredPanel);
        this.add(this.myLoadingPanel, JLayeredPane.DEFAULT_LAYER);
        this.myMainPanel.setVisible(false);
        this.myLoadingPanel.startLoading();
    }

    private boolean isCurrentEditor(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            WorkBench.$$$reportNull$$$0(12);
        }
        for (FileEditor editor : this.myFileEditorManager.getSelectedEditors()) {
            if (fileEditor != editor) continue;
            return true;
        }
        return false;
    }

    private void autoHide(@NotNull PropertyChangeEvent event) {
        JComponent newComponent;
        AttachedToolWindow<T> autoToolWindow;
        if (event == null) {
            WorkBench.$$$reportNull$$$0(13);
        }
        if ((autoToolWindow = this.myModel.getVisibleAutoHideTool()) == null) {
            return;
        }
        Object newValue = event.getNewValue();
        if (newValue instanceof JComponent && !SwingUtilities.isDescendingFrom(newComponent = (JComponent)newValue, autoToolWindow.getComponent()) && !SwingUtilities.isDescendingFrom(autoToolWindow.getComponent(), newComponent)) {
            autoToolWindow.setPropertyAndUpdate(AttachedToolWindow.PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private ThreeComponentsSplitter initSplitter(@NotNull ThreeComponentsSplitter splitter) {
        if (splitter == null) {
            WorkBench.$$$reportNull$$$0(14);
        }
        splitter.setDividerWidth(0);
        splitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent(new SidePanel<T>(Side.LEFT, this.myModel));
        splitter.setLastComponent(new SidePanel<T>(Side.RIGHT, this.myModel));
        splitter.setShowDividerControls(true);
        ThreeComponentsSplitter threeComponentsSplitter = splitter;
        if (threeComponentsSplitter == null) {
            WorkBench.$$$reportNull$$$0(15);
        }
        return threeComponentsSplitter;
    }

    public void setMinimizePanelsVisible(boolean visible) {
        this.myLeftMinimizePanel.setVisible(visible);
        this.myRightMinimizePanel.setVisible(visible);
    }

    @NotNull
    private String getUnscaledWidthPropertyName(@NotNull Layout layout, @NotNull Side side) {
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(16);
        }
        if (side == null) {
            WorkBench.$$$reportNull$$$0(17);
        }
        String string = "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + "." + side.name() + ".UNSCALED.WIDTH";
        if (string == null) {
            WorkBench.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private String getScaledWidthPropertyName(@NotNull Layout layout, @NotNull Side side) {
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(19);
        }
        if (side == null) {
            WorkBench.$$$reportNull$$$0(20);
        }
        String string = "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + "." + side.name() + ".WIDTH";
        if (string == null) {
            WorkBench.$$$reportNull$$$0(21);
        }
        return string;
    }

    private int getSideWidth(@NotNull Layout layout, @NotNull Side side) {
        int width;
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(22);
        }
        if (side == null) {
            WorkBench.$$$reportNull$$$0(23);
        }
        if ((width = this.myPropertiesComponent.getInt(this.getUnscaledWidthPropertyName(layout, side), -1)) != -1) {
            return JBUI.scale((int)width);
        }
        int scaledWidth = this.myPropertiesComponent.getInt(this.getScaledWidthPropertyName(layout, side), -1);
        if (scaledWidth != -1) {
            return -1;
        }
        this.myPropertiesComponent.unsetValue(this.getScaledWidthPropertyName(layout, side));
        this.setSideWidth(layout, side, scaledWidth);
        return scaledWidth;
    }

    private void setSideWidth(@NotNull Layout layout, @NotNull Side side, int value) {
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(24);
        }
        if (side == null) {
            WorkBench.$$$reportNull$$$0(25);
        }
        this.myPropertiesComponent.setValue(this.getUnscaledWidthPropertyName(layout, side), AdtUiUtils.unscale(value), -1);
    }

    private int getInitialSideWidth(@NotNull Side side) {
        if (side == null) {
            WorkBench.$$$reportNull$$$0(26);
        }
        int minimalWidth = this.getMinimumWidth(side);
        int width = this.getSideWidth(Layout.CURRENT, side);
        if (width == -1) {
            this.setSideWidth(Layout.DEFAULT, side, width);
            this.setSideWidth(Layout.CURRENT, side, width);
        }
        return Math.max(width, minimalWidth);
    }

    private int getMinimumWidth(@NotNull Side side) {
        if (side == null) {
            WorkBench.$$$reportNull$$$0(27);
        }
        Optional<Integer> initialMinimumWidth = this.myToolDefinitions.stream().filter(tool -> tool.getSide() == side).map(ToolWindowDefinition::getInitialMinimumWidth).max(Comparator.comparing(size -> size));
        return initialMinimumWidth.orElse(ToolWindowDefinition.DEFAULT_SIDE_WIDTH);
    }

    @NotNull
    private ComponentListener createWidthUpdater() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                WorkBench.this.adjustSplitterForInsufficentSpace();
                WorkBench.this.updateBothWidths();
            }
        };
        if (componentAdapter == null) {
            WorkBench.$$$reportNull$$$0(28);
        }
        return componentAdapter;
    }

    private void adjustSplitterForInsufficentSpace() {
        int minRightWidth;
        if (this.mySplitter.getWidth() <= 0 || !this.mySplitter.isVisible()) {
            return;
        }
        JComponent content = this.mySplitter.getInnerComponent();
        int actualCenterWidth = this.mySplitter.getWidth() - (this.mySplitter.getFirstSize() + this.mySplitter.getLastSize());
        int minCenterWidth = Math.max(content != null ? content.getMinimumSize().width : 0, ToolWindowDefinition.DEFAULT_SIDE_WIDTH);
        int minLeftWidth = this.myModel.getVisibleTools(Side.LEFT).isEmpty() ? 0 : this.getMinimumWidth(Side.LEFT);
        int n = minRightWidth = this.myModel.getVisibleTools(Side.RIGHT).isEmpty() ? 0 : this.getMinimumWidth(Side.RIGHT);
        if (this.mySplitter.getFirstSize() >= minLeftWidth && this.mySplitter.getLastSize() >= minRightWidth && actualCenterWidth >= minCenterWidth) {
            return;
        }
        if (this.mySplitter.getWidth() >= minLeftWidth + minCenterWidth + minRightWidth) {
            int rightExcess;
            int excess = this.mySplitter.getWidth() - (minLeftWidth + minCenterWidth + minRightWidth);
            int leftExcess = Math.max(0, this.mySplitter.getFirstSize() - minLeftWidth);
            if (leftExcess + (rightExcess = Math.max(0, this.mySplitter.getLastSize() - minRightWidth)) > excess) {
                double reduction = 1.0 * (double)excess / (double)(leftExcess + rightExcess);
                this.mySplitter.setFirstSize(minLeftWidth + (int)((double)leftExcess * reduction));
                this.mySplitter.setLastSize(minRightWidth + (int)((double)rightExcess * reduction));
            }
        } else {
            int sections = 1 + (minLeftWidth > 0 ? 1 : 0) + (minRightWidth > 0 ? 1 : 0);
            int sectionWidth = this.mySplitter.getWidth() / sections;
            if (minLeftWidth > 0) {
                this.mySplitter.setFirstSize(sectionWidth);
            }
            if (minRightWidth > 0) {
                this.mySplitter.setLastSize(sectionWidth);
            }
        }
    }

    private void updateBothWidths() {
        this.updateWidth(Side.LEFT);
        this.updateWidth(Side.RIGHT);
    }

    private void restoreBothWidths() {
        this.mySplitter.setFirstSize(this.getInitialSideWidth(Side.LEFT));
        this.mySplitter.setLastSize(this.getInitialSideWidth(Side.RIGHT));
    }

    private void updateWidth(@NotNull Side side) {
        if (side == null) {
            WorkBench.$$$reportNull$$$0(29);
        }
        int minimalWidth = this.getMinimumWidth(side);
        int width = side.isLeft() ? this.mySplitter.getFirstSize() : this.mySplitter.getLastSize();
        if ((width = Math.max(minimalWidth, width)) != 0 && width != this.getSideWidth(Layout.CURRENT, side)) {
            this.setSideWidth(Layout.CURRENT, side, width);
        }
    }

    @NotNull
    private String getToolOrderPropertyName(@NotNull Layout layout) {
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(30);
        }
        String string = "ATTACHED_TOOL_WINDOW." + layout.getPrefix() + this.myName + ".TOOL_ORDER";
        if (string == null) {
            WorkBench.$$$reportNull$$$0(31);
        }
        return string;
    }

    private void restoreToolOrder(@NotNull List<AttachedToolWindow<T>> tools) {
        String orderAsString;
        if (tools == null) {
            WorkBench.$$$reportNull$$$0(32);
        }
        if ((orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT))) == null) {
            return;
        }
        HashMap<String, Integer> order = new HashMap<String, Integer>(8);
        int number = 1;
        for (String string : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)orderAsString)) {
            order.put(string, number++);
        }
        for (AttachedToolWindow attachedToolWindow : tools) {
            Integer placement = (Integer)order.get(attachedToolWindow.getToolName());
            if (placement == null) {
                placement = number++;
            }
            attachedToolWindow.setToolOrder(placement);
        }
        tools.sort(Comparator.comparingInt(AttachedToolWindow::getToolOrder));
    }

    private void storeToolOrder(@NotNull Layout layout, @NotNull List<AttachedToolWindow<T>> tools) {
        if (layout == null) {
            WorkBench.$$$reportNull$$$0(33);
        }
        if (tools == null) {
            WorkBench.$$$reportNull$$$0(34);
        }
        StringBuilder builder = new StringBuilder();
        for (AttachedToolWindow<T> tool : tools) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(tool.getToolName());
        }
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(layout), builder.toString());
    }

    private void setDefaultOrderIfMissing(@NotNull List<AttachedToolWindow<T>> tools) {
        if (tools == null) {
            WorkBench.$$$reportNull$$$0(35);
        }
        if (!this.myPropertiesComponent.isValueSet(this.getToolOrderPropertyName(Layout.CURRENT))) {
            this.storeToolOrder(Layout.DEFAULT, tools);
            this.storeToolOrder(Layout.CURRENT, tools);
        }
    }

    private void modelChanged(@NotNull SideModel model2, @NotNull SideModel.EventType type) {
        if (model2 == null) {
            WorkBench.$$$reportNull$$$0(36);
        }
        if (type == null) {
            WorkBench.$$$reportNull$$$0(37);
        }
        switch (type) {
            case SWAP: {
                this.mySplitter.setFirstSize(this.getSideWidth(Layout.CURRENT, Side.RIGHT));
                this.mySplitter.setLastSize(this.getSideWidth(Layout.CURRENT, Side.LEFT));
                this.updateBothWidths();
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            case UPDATE_DETACHED_WINDOW: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                this.myDetachedToolWindowManager.updateToolWindowsForWorkBench(this);
                break;
            }
            case LOCAL_UPDATE: {
                break;
            }
            case UPDATE_TOOL_ORDER: {
                this.storeToolOrder(Layout.CURRENT, this.myModel.getAllTools());
                this.myWorkBenchManager.updateOtherWorkBenches(this);
                break;
            }
            default: {
                this.myWorkBenchManager.updateOtherWorkBenches(this);
            }
        }
    }

    private void addToolsToModel() {
        ArrayList<AttachedToolWindow<T>> tools = new ArrayList<AttachedToolWindow<T>>(this.myToolDefinitions.size());
        for (ToolWindowDefinition<T> definition : this.myToolDefinitions) {
            AttachedToolWindow<T> toolWindow = new AttachedToolWindow<T>(definition, this.myButtonDragListener, this.myName, this.myModel);
            Disposer.register((Disposable)this, toolWindow);
            tools.add(toolWindow);
        }
        this.setDefaultOrderIfMissing(tools);
        this.restoreToolOrder(tools);
        this.myModel.setTools(tools);
    }

    public List<AttachedToolWindow<T>> getDetachedToolWindows() {
        return this.myModel.getDetachedTools();
    }

    public void storeDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.CURRENT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.DEFAULT), orderAsString);
        this.setSideWidth(Layout.DEFAULT, Side.LEFT, this.getSideWidth(Layout.CURRENT, Side.LEFT));
        this.setSideWidth(Layout.DEFAULT, Side.RIGHT, this.getSideWidth(Layout.CURRENT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.storeDefaultLayout();
        }
    }

    public void restoreDefaultLayout() {
        String orderAsString = this.myPropertiesComponent.getValue(this.getToolOrderPropertyName(Layout.DEFAULT));
        this.myPropertiesComponent.setValue(this.getToolOrderPropertyName(Layout.CURRENT), orderAsString);
        this.setSideWidth(Layout.CURRENT, Side.LEFT, this.getSideWidth(Layout.DEFAULT, Side.LEFT));
        this.setSideWidth(Layout.CURRENT, Side.RIGHT, this.getSideWidth(Layout.DEFAULT, Side.RIGHT));
        for (AttachedToolWindow<T> tool : this.myModel.getAllTools()) {
            tool.restoreDefaultLayout();
        }
        this.updateModel();
    }

    public void updateModel() {
        this.restoreBothWidths();
        this.restoreToolOrder(this.myModel.getAllTools());
        this.myModel.updateLocally();
    }

    public void doLayout() {
        this.myLoadingPanel.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingText";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detachedToolWindowManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/workbench/WorkBench";
                break;
            }
            case 16: 
            case 19: 
            case 22: 
            case 24: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/workbench/WorkBench";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "initSplitter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnscaledWidthPropertyName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getScaledWidthPropertyName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createWidthUpdater";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOrderPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setLoadingText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showLoading";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadingStopped";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isCurrentEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "autoHide";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initSplitter";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 28: 
            case 31: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUnscaledWidthPropertyName";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getScaledWidthPropertyName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSideWidth";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setSideWidth";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSideWidth";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumWidth";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateWidth";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getToolOrderPropertyName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "restoreToolOrder";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "storeToolOrder";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultOrderIfMissing";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class InitParams<T> {
        private final SideModel<T> myModel;
        private final ThreeComponentsSplitter mySplitter;
        private final MinimizedPanel<T> myLeftMinimizePanel;
        private final MinimizedPanel<T> myRightMinimizePanel;

        InitParams(@NotNull SideModel<T> model2, @NotNull ThreeComponentsSplitter splitter, @NotNull MinimizedPanel<T> leftMinimizePanel, @NotNull MinimizedPanel<T> rightMinimizePanel) {
            if (model2 == null) {
                InitParams.$$$reportNull$$$0(0);
            }
            if (splitter == null) {
                InitParams.$$$reportNull$$$0(1);
            }
            if (leftMinimizePanel == null) {
                InitParams.$$$reportNull$$$0(2);
            }
            if (rightMinimizePanel == null) {
                InitParams.$$$reportNull$$$0(3);
            }
            this.myModel = model2;
            this.mySplitter = splitter;
            this.myLeftMinimizePanel = leftMinimizePanel;
            this.myRightMinimizePanel = rightMinimizePanel;
        }

        private static <T> InitParams<T> createParams(@NotNull Project project) {
            if (project == null) {
                InitParams.$$$reportNull$$$0(4);
            }
            SideModel model2 = new SideModel(project);
            return new InitParams(model2, new ThreeComponentsSplitter(), new MinimizedPanel(Side.LEFT, model2), new MinimizedPanel(Side.RIGHT, model2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftMinimizePanel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightMinimizePanel";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/WorkBench$InitParams";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createParams";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyButtonDragListener
    implements AttachedToolWindow.ButtonDragListener<T> {
        private final int BUTTON_PANEL_WIDTH = JBUI.scale((int)21);
        private boolean myIsDragging;
        private MinimizedPanel<T> myPreviousButtonPanel;

        private MyButtonDragListener() {
        }

        @Override
        public void buttonDragged(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (toolWindow == null) {
                MyButtonDragListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(1);
            }
            if (!this.myIsDragging) {
                this.startDragging(event);
            }
            this.moveDragImage(toolWindow, event);
            this.notifyButtonPanel(toolWindow, event, false);
        }

        @Override
        public void buttonDropped(@NotNull AttachedToolWindow<T> toolWindow, @NotNull AttachedToolWindow.DragEvent event) {
            if (toolWindow == null) {
                MyButtonDragListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(3);
            }
            if (this.myIsDragging) {
                this.notifyButtonPanel(toolWindow, event, true);
                this.stopDragging(toolWindow, event);
            }
        }

        private void startDragging(@NotNull AttachedToolWindow.DragEvent event) {
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(4);
            }
            WorkBench.this.add(event.getDragImage(), JLayeredPane.DRAG_LAYER);
            this.myIsDragging = true;
        }

        private void stopDragging(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            if (tool == null) {
                MyButtonDragListener.$$$reportNull$$$0(5);
            }
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(6);
            }
            AbstractButton button = tool.getMinimizedButton();
            button.setVisible(true);
            WorkBench.this.remove(event.getDragImage());
            WorkBench.this.revalidate();
            WorkBench.this.repaint();
            this.myPreviousButtonPanel = null;
            this.myIsDragging = false;
        }

        private void moveDragImage(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event) {
            if (tool == null) {
                MyButtonDragListener.$$$reportNull$$$0(7);
            }
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(8);
            }
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            Dimension buttonSize = button.getPreferredSize();
            Point dragPosition = event.getDragPoint();
            position.x = this.translate(position.x, dragPosition.x, 0, WorkBench.this.getWidth() - buttonSize.width);
            position.y = this.translate(position.y, dragPosition.y, 0, WorkBench.this.getHeight() - buttonSize.height);
            Component dragImage = event.getDragImage();
            Dimension size = dragImage.getPreferredSize();
            dragImage.setBounds(position.x, position.y, size.width, size.height);
            dragImage.revalidate();
            dragImage.repaint();
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, @NotNull AttachedToolWindow.DragEvent event, boolean doDrop) {
            if (tool == null) {
                MyButtonDragListener.$$$reportNull$$$0(9);
            }
            if (event == null) {
                MyButtonDragListener.$$$reportNull$$$0(10);
            }
            AbstractButton button = tool.getMinimizedButton();
            Point position = SwingUtilities.convertPoint(button, event.getMousePoint(), (Component)((Object)WorkBench.this));
            int yMidOfButton = position.y - event.getDragPoint().y + button.getHeight() / 2;
            if (position.x < this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myLeftMinimizePanel, doDrop);
            } else if (position.x > WorkBench.this.getWidth() - this.BUTTON_PANEL_WIDTH) {
                this.notifyButtonPanel(tool, yMidOfButton, WorkBench.this.myRightMinimizePanel, doDrop);
            } else if (this.myPreviousButtonPanel != null) {
                this.myPreviousButtonPanel.dragExit(tool);
                this.myPreviousButtonPanel = null;
            }
        }

        private void notifyButtonPanel(@NotNull AttachedToolWindow<T> tool, int y, @NotNull MinimizedPanel<T> buttonPanel, boolean doDrop) {
            if (tool == null) {
                MyButtonDragListener.$$$reportNull$$$0(11);
            }
            if (buttonPanel == null) {
                MyButtonDragListener.$$$reportNull$$$0(12);
            }
            if (this.myPreviousButtonPanel != null && this.myPreviousButtonPanel != buttonPanel) {
                this.myPreviousButtonPanel.dragExit(tool);
            }
            this.myPreviousButtonPanel = buttonPanel;
            if (doDrop) {
                buttonPanel.dragDrop(tool, y);
            } else {
                buttonPanel.drag(tool, y);
            }
        }

        private int translate(int pos, int offset, int min, int max) {
            return Math.min(Math.max(pos - offset, min), max);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindow";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tool";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttonPanel";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/workbench/WorkBench$MyButtonDragListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buttonDragged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buttonDropped";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopDragging";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moveDragImage";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyButtonPanel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

