/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.stdui.LookupUI;
import com.android.tools.adtui.stdui.Matcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00015B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00100\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\b\u00101\u001a\u00020'H\u0002J\u0018\u00102\u001a\u00020'2\u0006\u00103\u001a\u0002042\u0006\u0010,\u001a\u00020-H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR$\u0010#\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u0012\"\u0004\b%\u0010\u0014\u00a8\u00066"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI;", "Lcom/android/tools/adtui/stdui/LookupUI;", "()V", "list", "Lcom/intellij/ui/components/JBList;", "", "popup", "Ljavax/swing/JPopupMenu;", "popupSize", "Ljava/awt/Dimension;", "getPopupSize", "()Ljava/awt/Dimension;", "renderer", "Lcom/android/tools/adtui/stdui/DefaultLookupUI$LookupCellRenderer;", "value", "", "selectedIndex", "getSelectedIndex", "()I", "setSelectedIndex", "(I)V", "selectedValue", "getSelectedValue", "()Ljava/lang/String;", "setSelectedValue", "(Ljava/lang/String;)V", "", "semiFocused", "getSemiFocused", "()Z", "setSemiFocused", "(Z)V", "visible", "getVisible", "setVisible", "visibleRowCount", "getVisibleRowCount", "setVisibleRowCount", "createList", "", "listModel", "Ljavax/swing/ListModel;", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "editor", "Ljavax/swing/JComponent;", "editorBounds", "Ljava/awt/Rectangle;", "screenBounds", "updateElementHeight", "updateLocation", "location", "Ljava/awt/Point;", "LookupCellRenderer", "intellij.android.adt.ui"})
public final class DefaultLookupUI
implements LookupUI {
    private final JPopupMenu popup = new JPopupMenu();
    private final LookupCellRenderer renderer = new LookupCellRenderer();
    private final JBList<String> list = new JBList();

    @Override
    public boolean getVisible() {
        return this.popup.isVisible();
    }

    @Override
    public void setVisible(boolean value) {
        this.popup.setVisible(value);
    }

    @Override
    public int getVisibleRowCount() {
        return this.list.getVisibleRowCount();
    }

    @Override
    public void setVisibleRowCount(int value) {
        this.updateElementHeight();
        this.list.setVisibleRowCount(value);
    }

    @Override
    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int value) {
        this.list.setSelectedIndex(value);
        this.list.ensureIndexIsVisible(value);
    }

    @Override
    @Nullable
    public String getSelectedValue() {
        return (String)this.list.getSelectedValue();
    }

    @Override
    public void setSelectedValue(@Nullable String value) {
        this.list.setSelectedValue((Object)value, true);
    }

    @Override
    public boolean getSemiFocused() {
        return this.renderer.getSemiFocused();
    }

    @Override
    public void setSemiFocused(boolean value) {
        this.renderer.setSemiFocused(value);
    }

    @Override
    @NotNull
    public Dimension getPopupSize() {
        Dimension dimension = this.popup.getPreferredSize();
        Intrinsics.checkExpressionValueIsNotNull((Object)dimension, (String)"popup.preferredSize");
        return dimension;
    }

    @Override
    public void createList(@NotNull ListModel<String> listModel, @NotNull Matcher matcher, @NotNull JComponent editor) {
        Intrinsics.checkParameterIsNotNull(listModel, (String)"listModel");
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.list), (int)20, (int)31);
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane, (String)"ScrollPaneFactory.create\u2026RIZONTAL_SCROLLBAR_NEVER)");
        JScrollPane scrollPane = jScrollPane;
        this.popup.add(scrollPane);
        this.renderer.setMatcher(matcher);
        this.list.setModel(listModel);
        this.list.setFocusable(false);
        this.list.setCellRenderer((ListCellRenderer)((Object)this.renderer));
        this.list.setSelectionMode(0);
        this.list.setBackground((Color)this.renderer.getBackgroundColor());
        AccessibleContext accessibleContext = this.list.getAccessibleContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)accessibleContext, (String)"list.accessibleContext");
        accessibleContext.setAccessibleName("Code Completion");
        JBList<String> jBList = this.list;
        if (jBList == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Component");
        }
        AccessibleContextUtil.setParent((Component)((Component)jBList), (Component)editor);
    }

    private final void updateElementHeight() {
        int n;
        ListModel model2;
        ListModel listModel = model2 = this.list.getModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)listModel, (String)"model");
        if (listModel.getSize() > 0) {
            Component component = this.renderer.getListCellRendererComponent((JList)this.list, model2.getElementAt(0), 0, false, false);
            Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"renderer.getListCellRend\u2026ntAt(0), 0, false, false)");
            n = component.getPreferredSize().height;
        } else {
            n = 16;
        }
        this.list.setFixedCellHeight(n);
    }

    @Override
    public void updateLocation(@NotNull Point location, @NotNull JComponent editor) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Window window = SwingUtilities.getWindowAncestor(this.popup);
        if (this.getVisible() && window != null) {
            window.setSize(window.getPreferredSize());
            if (Intrinsics.areEqual((Object)window.getLocation(), (Object)location) ^ true) {
                window.setLocation(location);
            }
        } else {
            this.popup.setSize(this.popup.getPreferredSize());
            this.popup.setLocation(location);
        }
    }

    @Override
    @NotNull
    public Rectangle screenBounds(@NotNull JComponent editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = editor.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            Point point = new Point(0, 0);
            Toolkit toolkit2 = toolkit;
            Intrinsics.checkExpressionValueIsNotNull((Object)toolkit2, (String)"toolkit");
            return new Rectangle(point, toolkit2.getScreenSize());
        }
        GraphicsConfiguration configuration = graphicsConfiguration;
        Rectangle screenBounds = configuration.getBounds();
        Insets screenInsets = toolkit.getScreenInsets(configuration);
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        Rectangle rectangle = screenBounds;
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"screenBounds");
        return rectangle;
    }

    @Override
    @NotNull
    public Rectangle editorBounds(@NotNull JComponent editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Point topLeft = new Point();
        SwingUtilities.convertPointToScreen(topLeft, editor);
        return new Rectangle(topLeft.x, topLeft.y, editor.getWidth(), editor.getHeight());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u001b\u001a\u00020\u001c2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/android/tools/adtui/stdui/DefaultLookupUI$LookupCellRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "", "()V", "backgroundColor", "Lcom/intellij/ui/JBColor;", "getBackgroundColor", "()Lcom/intellij/ui/JBColor;", "filterAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "filterForegroundColor", "matcher", "Lcom/android/tools/adtui/stdui/Matcher;", "getMatcher", "()Lcom/android/tools/adtui/stdui/Matcher;", "setMatcher", "(Lcom/android/tools/adtui/stdui/Matcher;)V", "selectedAttributes", "selectedFocusedBackgroundColor", "selectedForegroundColor", "selectedNonFocusedBackgroundColor", "semiFocused", "", "getSemiFocused", "()Z", "setSemiFocused", "(Z)V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "hasFocus", "intellij.android.adt.ui"})
    public static final class LookupCellRenderer
    extends ColoredListCellRenderer<String> {
        private final JBColor selectedFocusedBackgroundColor = new JBColor(21156, 21156);
        private final JBColor selectedNonFocusedBackgroundColor = new JBColor(7245474, 0x55585A);
        private final JBColor selectedForegroundColor = new JBColor(0xFFFFFF, 0xFFFFFF);
        private final JBColor filterForegroundColor = new JBColor(0xB000B0, 13728470);
        private final SimpleTextAttributes filterAttributes = new SimpleTextAttributes(0, (Color)this.filterForegroundColor);
        private final SimpleTextAttributes selectedAttributes = new SimpleTextAttributes(0, (Color)this.selectedForegroundColor);
        @NotNull
        private final JBColor backgroundColor = new JBColor(15463678, 3224629);
        private boolean semiFocused;
        @Nullable
        private Matcher matcher;

        @NotNull
        public final JBColor getBackgroundColor() {
            return this.backgroundColor;
        }

        public final boolean getSemiFocused() {
            return this.semiFocused;
        }

        public final void setSemiFocused(boolean bl) {
            this.semiFocused = bl;
        }

        @Nullable
        public final Matcher getMatcher() {
            return this.matcher;
        }

        public final void setMatcher(@Nullable Matcher matcher) {
            this.matcher = matcher;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends String> list, @NotNull String value, int index, boolean selected, boolean hasFocus) {
            List<TextRange> ranges;
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.setBackground(selected && this.semiFocused ? (Color)this.selectedFocusedBackgroundColor : (selected ? (Color)this.selectedNonFocusedBackgroundColor : (Color)this.backgroundColor));
            SimpleTextAttributes foregroundAttributes = selected ? this.selectedAttributes : SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Matcher matcher = this.matcher;
            List<Object> list2 = ranges = matcher != null ? matcher.matchingFragments(value) : null;
            if (ranges != null) {
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)((SimpleColoredComponent)this), (String)value, (Iterable)ranges, (SimpleTextAttributes)foregroundAttributes, (SimpleTextAttributes)this.filterAttributes);
            } else {
                this.append(value, foregroundAttributes);
            }
        }
    }
}

