/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.eventrenderer;

import com.android.tools.adtui.eventrenderer.EventRenderer;
import com.android.tools.adtui.model.event.EventAction;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class TouchEventRenderer<E>
implements EventRenderer<E> {
    private static final JBColor HOLD_COLOR = new JBColor(new Color(1726116762, true), new Color(1726118820, true));
    private static final JBColor TOUCH_COLOR = new JBColor(new Color(-857574502, true), new Color(-857572444, true));
    private static final int MIN_LENGTH = 20;
    private static final int LINE_WIDTH = 12;
    private static final int BORDER_MARGIN = 2;

    @Override
    public void draw(@NotNull Component parent, @NotNull Graphics2D g2d, @NotNull AffineTransform transform, double length, boolean isMouseOver, EventAction<E> eventAction) {
        if (parent == null) {
            TouchEventRenderer.$$$reportNull$$$0(0);
        }
        if (g2d == null) {
            TouchEventRenderer.$$$reportNull$$$0(1);
        }
        if (transform == null) {
            TouchEventRenderer.$$$reportNull$$$0(2);
        }
        Color currentColor = g2d.getColor();
        Stroke currentStroke = g2d.getStroke();
        double xPosition = transform.getTranslateX() - 6.0;
        double yPosition = transform.getTranslateY() + 6.0;
        g2d.setColor(parent.getBackground());
        Ellipse2D.Double ellipse = new Ellipse2D.Double(xPosition - 2.0, yPosition - 2.0, 16.0, 16.0);
        g2d.fill(ellipse);
        g2d.setColor((Color)TOUCH_COLOR);
        ellipse = new Ellipse2D.Double(xPosition, yPosition, 12.0, 12.0);
        g2d.fill(ellipse);
        if (length >= 20.0) {
            BasicStroke str = new BasicStroke(12.0f);
            g2d.setStroke(str);
            g2d.setColor((Color)HOLD_COLOR);
            RoundRectangle2D.Double rect = new RoundRectangle2D.Double(xPosition, yPosition, length, 12.0, 12.0, 12.0);
            g2d.fill(rect);
            g2d.setStroke(currentStroke);
        }
        g2d.setColor(currentColor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "g2d";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "transform";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/eventrenderer/TouchEventRenderer";
        objectArray[2] = "draw";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

