/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Stopwatch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StateChart<T>
extends AnimatedComponent {
    private static final int INVALID_INDEX = -1;
    private static final int TEXT_PADDING = 3;
    private StateChartModel<T> myModel;
    @NotNull
    private final StateChartColorProvider<T> myColorProvider;
    private float myHeightGap;
    @NotNull
    private RenderMode myRenderMode;
    @NotNull
    private final StateChartConfig<T> myConfig;
    private boolean myNeedsTransformToViewSpace;
    @NotNull
    private final StateChartTextConverter<T> myTextConverter;
    private final List<Rectangle2D.Float> myRectangles;
    private final List<T> myRectangleValues;
    @Nullable
    private Object myMouseEventSource;
    @Nullable
    private Point myMousePoint;
    @Nullable
    private Point myRowPoint;
    private int myRowIndex;

    public StateChart(@NotNull StateChartModel<T> model2, final @NotNull Map<T, Color> colors) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(0);
        }
        if (colors == null) {
            StateChart.$$$reportNull$$$0(1);
        }
        this(model2, new StateChartColorProvider<T>(){

            @Override
            @NotNull
            public Color getColor(boolean isMouseOver, @NotNull T value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                Color color = (Color)colors.get(value);
                Color color2 = isMouseOver ? ColorUtil.brighter((Color)color, (int)2) : color;
                if (color2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return color2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/adtui/chart/statechart/StateChart$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/adtui/chart/statechart/StateChart$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getColor";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorMapping) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(2);
        }
        if (colorMapping == null) {
            StateChart.$$$reportNull$$$0(3);
        }
        this(model2, new StateChartConfig(new DefaultStateChartReducer()), colorMapping, val -> val.toString());
    }

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorMapping, StateChartTextConverter<T> textConverter) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(4);
        }
        if (colorMapping == null) {
            StateChart.$$$reportNull$$$0(5);
        }
        this(model2, new StateChartConfig(new DefaultStateChartReducer()), colorMapping, textConverter);
    }

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartConfig<T> config, @NotNull StateChartColorProvider<T> colorMapping) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(6);
        }
        if (config == null) {
            StateChart.$$$reportNull$$$0(7);
        }
        if (colorMapping == null) {
            StateChart.$$$reportNull$$$0(8);
        }
        this(model2, config, colorMapping, val -> val.toString());
    }

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartConfig<T> config, @NotNull StateChartColorProvider<T> colorMapping, @NotNull StateChartTextConverter<T> textConverter) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(9);
        }
        if (config == null) {
            StateChart.$$$reportNull$$$0(10);
        }
        if (colorMapping == null) {
            StateChart.$$$reportNull$$$0(11);
        }
        if (textConverter == null) {
            StateChart.$$$reportNull$$$0(12);
        }
        this.myRectangles = new ArrayList<Rectangle2D.Float>();
        this.myRectangleValues = new ArrayList<T>();
        this.myMouseEventSource = null;
        this.myMousePoint = null;
        this.myRowPoint = null;
        this.myRowIndex = -1;
        this.myColorProvider = colorMapping;
        this.myRenderMode = RenderMode.BAR;
        this.myConfig = config;
        this.myNeedsTransformToViewSpace = true;
        this.myTextConverter = textConverter;
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.setModel(model2);
        this.setHeightGap(this.myConfig.getHeightGap());
        this.registerMouseEvents();
    }

    public void setModel(@NotNull StateChartModel<T> model2) {
        if (model2 == null) {
            StateChart.$$$reportNull$$$0(13);
        }
        if (this.myModel != null) {
            this.myModel.removeDependencies(this.myAspectObserver);
        }
        this.myModel = model2;
        this.myModel.addDependency(this.myAspectObserver).onChange(StateChartModel.Aspect.MODEL_CHANGED, this::modelChanged);
        this.modelChanged();
    }

    private void modelChanged() {
        this.myNeedsTransformToViewSpace = true;
        this.opaqueRepaint();
    }

    public void setRenderMode(@NotNull RenderMode mode) {
        if (mode == null) {
            StateChart.$$$reportNull$$$0(14);
        }
        this.myRenderMode = mode;
    }

    public void setHeightGap(float gap) {
        this.myHeightGap = gap;
    }

    private void clearRectangles() {
        this.myRectangles.clear();
        this.myRectangleValues.clear();
    }

    /*
     * WARNING - void declaration
     */
    private void addRectangleDelta(@NotNull T value, double previousX, double currentX, double minX, double d, float f, float f2) {
        void height;
        void rectY;
        void invRange;
        if (value == null) {
            StateChart.$$$reportNull$$$0(15);
        }
        Rectangle2D.Float rect = new Rectangle2D.Float((float)((previousX - minX) * invRange), (float)rectY, (float)((currentX - previousX) * invRange), (float)height);
        this.myRectangles.add(rect);
        this.myRectangleValues.add(value);
    }

    private void transformToViewSpace() {
        if (!this.myNeedsTransformToViewSpace) {
            return;
        }
        this.myNeedsTransformToViewSpace = false;
        List<RangedSeries<T>> series = this.myModel.getSeries();
        int seriesSize = series.size();
        if (seriesSize == 0) {
            return;
        }
        float rectHeight = 1.0f / (float)seriesSize;
        float gap = rectHeight * this.myHeightGap;
        float barHeight = rectHeight - gap;
        this.clearRectangles();
        for (int seriesIndex = 0; seriesIndex < seriesSize; ++seriesIndex) {
            RangedSeries<T> data = series.get(seriesIndex);
            double min = data.getXRange().getMin();
            double max = data.getXRange().getMax();
            double invRange = 1.0 / (max - min);
            float startHeight = 1.0f - rectHeight * (float)(seriesIndex + 1);
            List<SeriesData<T>> seriesDataList = data.getSeries();
            if (seriesDataList.isEmpty()) continue;
            long previousX = seriesDataList.get((int)0).x;
            Object previousValue = seriesDataList.get((int)0).value;
            for (int i = 1; i < seriesDataList.size(); ++i) {
                SeriesData<T> seriesData = seriesDataList.get(i);
                long x = seriesData.x;
                Object value = seriesData.value;
                if (value.equals(previousValue)) continue;
                assert (previousValue != null);
                if ((double)x >= min) {
                    this.addRectangleDelta(previousValue, Math.max(min, (double)previousX), Math.min(max, (double)x), min, invRange, startHeight + gap * 0.5f, barHeight);
                }
                previousValue = value;
                previousX = x;
                if ((double)previousX >= max) break;
            }
            if (!((double)previousX < max) || previousValue == null) continue;
            this.addRectangleDelta(previousValue, Math.max(min, (double)previousX), max, min, invRange, startHeight + gap * 0.5f, barHeight);
        }
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        Stopwatch stopwatch = new Stopwatch().start();
        this.transformToViewSpace();
        long transformTime = stopwatch.getElapsedSinceLastDeltaNs();
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        assert (this.myRectangles.size() == this.myRectangleValues.size());
        ArrayList<Rectangle2D.Float> transformedShapes = new ArrayList<Rectangle2D.Float>(this.myRectangles.size());
        ArrayList<T> transformedValues = new ArrayList<T>(this.myRectangleValues.size());
        float scaleX = this.getWidth();
        float scaleY = this.getHeight();
        Rectangle clipRect = g2d.getClipBounds();
        int startIndexInclusive = 0;
        int endIndexExclusive = this.myRectangles.size();
        if (clipRect != null) {
            if (clipRect.x != 0 && (startIndexInclusive = Collections.binarySearch(this.myRectangles, new Rectangle2D.Float((float)clipRect.x / scaleX, 0.0f, 0.0f, 0.0f), (value, key) -> value.x + value.width < key.x ? -1 : (value.x > key.x ? 1 : 0))) < 0) {
                startIndexInclusive = -(startIndexInclusive + 1);
            }
            if (clipRect.width != this.getWidth()) {
                endIndexExclusive = Collections.binarySearch(this.myRectangles, new Rectangle2D.Float((float)(clipRect.x + clipRect.width) / scaleX, 0.0f, 0.0f, 0.0f), (value, key) -> value.x + value.width < key.x ? -1 : (value.x > key.x ? 1 : 0));
                endIndexExclusive = endIndexExclusive < 0 ? -(endIndexExclusive + 1) : ++endIndexExclusive;
            }
        }
        for (int i = startIndexInclusive; i < endIndexExclusive; ++i) {
            Rectangle2D.Float rectangle = this.myRectangles.get(i);
            transformedShapes.add(new Rectangle2D.Float(rectangle.x * scaleX, rectangle.y * scaleY, rectangle.width * scaleX, rectangle.height * scaleY));
            transformedValues.add(this.myRectangleValues.get(i));
        }
        long scalingTime = stopwatch.getElapsedSinceLastDeltaNs();
        this.myConfig.getReducer().reduce(transformedShapes, transformedValues);
        assert (transformedShapes.size() == transformedValues.size());
        long reducerTime = stopwatch.getElapsedSinceLastDeltaNs();
        int hoverIndex = -1;
        if (this.myRowPoint != null) {
            float mouseXFloat = this.myRowPoint.x;
            hoverIndex = Collections.binarySearch(transformedShapes, new Rectangle2D.Float(mouseXFloat, 0.0f, mouseXFloat + 1.0f, 0.0f), (value, key) -> value.x + value.width < key.x ? -1 : (value.x > key.width ? 1 : 0));
        }
        for (int i = 0; i < transformedShapes.size(); ++i) {
            String valueText;
            String text;
            Object value2 = transformedValues.get(i);
            Rectangle2D.Float rect = (Rectangle2D.Float)transformedShapes.get(i);
            boolean isMouseOver = i == hoverIndex;
            Color color = this.myColorProvider.getColor(isMouseOver, value2);
            g2d.setColor(color);
            g2d.fill(rect);
            if (this.myRenderMode != RenderMode.TEXT || (text = AdtUiUtils.shrinkToFit(valueText = this.myTextConverter.convertToString(value2), this.mDefaultFontMetrics, rect.width - 6.0f)).isEmpty()) continue;
            g2d.setColor(this.myColorProvider.getFontColor(isMouseOver, value2));
            float textOffset = rect.y + (rect.height - (float)this.mDefaultFontMetrics.getHeight()) * 0.5f;
            g2d.drawString(text, rect.x + 3.0f, textOffset += (float)this.mDefaultFontMetrics.getAscent());
        }
        long drawTime = stopwatch.getElapsedSinceLastDeltaNs();
        this.addDebugInfo("XS ms: %.2fms, %.2fms", Float.valueOf((float)transformTime / 1000000.0f), Float.valueOf((float)scalingTime / 1000000.0f));
        this.addDebugInfo("RDT ms: %.2f, %.2f, %.2f", Float.valueOf((float)reducerTime / 1000000.0f), Float.valueOf((float)drawTime / 1000000.0f), Float.valueOf((float)(scalingTime + reducerTime + drawTime) / 1000000.0f));
        this.addDebugInfo("# of drawn rects: %d", transformedShapes.size());
    }

    private void registerMouseEvents() {
        MouseEventHandler handler = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                JList sourceList;
                if (event.getPoint().equals(StateChart.this.myMousePoint)) {
                    return;
                }
                if (StateChart.this.myRowIndex != -1) {
                    Point oldRowOriginInEventSpace = new Point(0, 0);
                    if (event.getSource() instanceof JList) {
                        sourceList = (JList)event.getSource();
                        oldRowOriginInEventSpace = sourceList.getUI().indexToLocation(sourceList, StateChart.this.myRowIndex);
                    }
                    if (oldRowOriginInEventSpace != null) {
                        StateChart.this.renderUnion(oldRowOriginInEventSpace);
                    }
                }
                if (event.getID() == 505) {
                    StateChart.this.myMousePoint = null;
                    StateChart.this.myRowPoint = null;
                    StateChart.this.myMouseEventSource = null;
                    StateChart.this.myRowIndex = -1;
                } else {
                    Point rowOrigin = new Point(0, 0);
                    if (event.getSource() instanceof JList) {
                        sourceList = (JList)event.getSource();
                        StateChart.this.myRowIndex = sourceList.getUI().locationToIndex(sourceList, event.getPoint());
                        if (StateChart.this.myRowIndex >= 0) {
                            rowOrigin = sourceList.getUI().indexToLocation(sourceList, StateChart.this.myRowIndex);
                            assert (rowOrigin != null);
                        }
                        StateChart.this.myMousePoint = event.getPoint();
                        StateChart.this.myRowPoint = new Point(StateChart.this.myMousePoint);
                        StateChart.this.myRowPoint.translate(-rowOrigin.x, -rowOrigin.y);
                    } else {
                        StateChart.this.myMousePoint = event.getPoint();
                        StateChart.this.myRowPoint = StateChart.this.myMousePoint;
                    }
                    StateChart.this.myMouseEventSource = event.getSource();
                    if (StateChart.this.myRowIndex != -1) {
                        StateChart.this.renderUnion(rowOrigin);
                    }
                }
            }
        };
        this.addMouseListener((MouseListener)handler);
        this.addMouseMotionListener((MouseMotionListener)handler);
    }

    private void renderUnion(@NotNull Point containerOffset) {
        Rectangle2D.Float union;
        if (containerOffset == null) {
            StateChart.$$$reportNull$$$0(16);
        }
        if (this.myRowPoint != null && this.myMouseEventSource instanceof Component && (union = this.getMouseRectanglesUnion(this.myRowPoint)) != null) {
            ((Component)this.myMouseEventSource).repaint((int)union.x + containerOffset.x, (int)union.y + containerOffset.y, (int)Math.ceil(union.width), (int)Math.ceil(union.height));
        }
    }

    @Nullable
    private Rectangle2D.Float getMouseRectanglesUnion(@NotNull Point mousePoint) {
        List<RangedSeries<T>> series;
        int seriesSize;
        if (mousePoint == null) {
            StateChart.$$$reportNull$$$0(17);
        }
        if ((seriesSize = (series = this.myModel.getSeries()).size()) == 0) {
            return null;
        }
        double scaleX = this.getWidth();
        double scaleY = this.getHeight();
        double normalizedMouseY = 1.0 - (double)mousePoint.y / scaleY;
        int seriesIndex = Math.min(seriesSize - 1, (int)(normalizedMouseY * (double)seriesSize));
        if (seriesIndex < 0 || seriesIndex >= series.size()) {
            Logger.getInstance(StateChart.class).warn(String.format("Series index in getMouseRectanglesUnion is out of bounds: mouseY = %d, scaleY = %f", mousePoint.y, scaleY));
            return new Rectangle2D.Float(0.0f, 0.0f, (float)scaleX, (float)scaleY);
        }
        RangedSeries<T> data = series.get(seriesIndex);
        double min = data.getXRange().getMin();
        double max = data.getXRange().getMax();
        double range = max - min;
        double mouseXDouble = mousePoint.x;
        double modelMouseXLeft = mouseXDouble / scaleX * range + min;
        List<SeriesData<T>> seriesDataList = data.getSeries();
        if (seriesDataList.isEmpty()) {
            return null;
        }
        int rectangleLeftIndex = Collections.binarySearch(seriesDataList, new SeriesData<Object>((long)modelMouseXLeft, null), (value, key) -> (int)(value.x - key.x));
        boolean isInsertionOnLeftX = false;
        if (rectangleLeftIndex < 0) {
            rectangleLeftIndex = -(rectangleLeftIndex + 1);
            isInsertionOnLeftX = true;
        }
        if (isInsertionOnLeftX) {
            for (rectangleLeftIndex = Math.min(rectangleLeftIndex, seriesDataList.size() - 1); rectangleLeftIndex > 0 && (double)seriesDataList.get((int)rectangleLeftIndex).x > modelMouseXLeft; --rectangleLeftIndex) {
            }
        }
        long modelMouseXRight = (long)Math.ceil((mouseXDouble + 1.0) / scaleX * range + min);
        int rectangleRightIndex = rectangleLeftIndex;
        int i = rectangleLeftIndex + 1;
        while (i < seriesDataList.size() && seriesDataList.get((int)i).x <= modelMouseXRight) {
            rectangleRightIndex = i++;
        }
        if (rectangleRightIndex < seriesDataList.size()) {
            Object lastValue = seriesDataList.get((int)rectangleRightIndex).value;
            ++rectangleRightIndex;
            while (rectangleRightIndex < seriesDataList.size() && seriesDataList.get((int)rectangleRightIndex).value.equals(lastValue)) {
                ++rectangleRightIndex;
            }
        }
        Object firstValue = seriesDataList.get((int)rectangleLeftIndex).value;
        int i2 = rectangleLeftIndex - 1;
        while (i2 >= 0 && seriesDataList.get((int)i2).value == firstValue) {
            rectangleLeftIndex = i2--;
        }
        double modelXLeft = Math.max(min, (double)seriesDataList.get((int)rectangleLeftIndex).x);
        double modelXRight = Math.min(max, rectangleRightIndex >= seriesDataList.size() ? max : (double)seriesDataList.get((int)rectangleRightIndex).x);
        double screenXLeft = (modelXLeft - min) * scaleX / range;
        double screenXRight = (modelXRight - min) * scaleX / range;
        double screenYTop = (double)seriesIndex * scaleY / (double)seriesSize;
        double screenYBottom = (double)(seriesIndex + 1) * scaleY / (double)seriesSize;
        double screenXLeftFloor = Math.floor(screenXLeft);
        double screenYTopCeil = Math.ceil(screenYTop);
        double screenWidth = Math.ceil(screenXRight) - screenXLeftFloor;
        double screenHeight = Math.floor(screenYBottom) - screenYTopCeil;
        return new Rectangle2D.Float((float)screenXLeftFloor, (float)screenYTopCeil, (float)screenWidth, (float)screenHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorMapping";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textConverter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerOffset";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mousePoint";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/chart/statechart/StateChart";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "setRenderMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addRectangleDelta";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "renderUnion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getMouseRectanglesUnion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum RenderMode {
        BAR,
        TEXT;

    }
}

