/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.intellij.util.Producer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipComponent
extends AnimatedComponent {
    private static final int BORDER_SIZE = 10;
    private static final int[] DROPSHADOW_ALPHAS = new int[]{40, 30, 20, 10};
    @NotNull
    private final JComponent myTooltipContent;
    @NotNull
    private final JComponent myOwner;
    @NotNull
    private final JLayeredPane myParent;
    @NotNull
    private final Producer<Boolean> myIsOwnerDisplayable;
    @Nullable
    private final Producer<Boolean> myDefaultVisibilityOverride;
    @NotNull
    private final Dimension myExpandedSize;
    @Nullable
    private Point myLastPoint;
    @Nullable
    private Dimension myLastSize;
    private final ComponentListener myParentListener;

    private TooltipComponent(@NotNull Builder builder) {
        if (builder == null) {
            TooltipComponent.$$$reportNull$$$0(0);
        }
        this.myExpandedSize = new Dimension(0, 0);
        this.myTooltipContent = builder.myTooltipContent;
        this.myOwner = builder.myOwner;
        this.myParent = builder.myParent;
        this.myIsOwnerDisplayable = builder.myIsOwnerDisplayable;
        this.myDefaultVisibilityOverride = builder.myDefaultVisibilityOverride;
        this.myParentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                TooltipComponent.this.resetBounds();
            }
        };
        this.add(this.myTooltipContent);
        this.setVisible(false);
        this.resetBounds();
        this.myOwner.addHierarchyListener(event -> SwingUtilities.invokeLater(() -> {
            if (!((Boolean)this.myIsOwnerDisplayable.produce()).booleanValue()) {
                this.removeFromParent();
            }
        }));
    }

    private void removeFromParent() {
        this.setVisible(false);
        if (this.getParent() != null) {
            this.getParent().removeComponentListener(this.myParentListener);
            this.getParent().remove(this);
        }
    }

    private void resetBounds() {
        if (this.myParent.getWidth() != this.getWidth() || this.myParent.getHeight() != this.getHeight()) {
            this.setBounds(0, 0, this.myParent.getWidth(), this.myParent.getHeight());
        }
    }

    @NotNull
    private static Dimension max(@NotNull Dimension a, @NotNull Dimension b) {
        if (a == null) {
            TooltipComponent.$$$reportNull$$$0(1);
        }
        if (b == null) {
            TooltipComponent.$$$reportNull$$$0(2);
        }
        Dimension dimension = new Dimension(Math.max(a.width, b.width), Math.max(a.height, b.height));
        if (dimension == null) {
            TooltipComponent.$$$reportNull$$$0(3);
        }
        return dimension;
    }

    @Override
    public void doLayout() {
        Dimension size = this.getPreferredSize();
        this.myExpandedSize.setSize(size.width, 0);
        this.myTooltipContent.setSize(size);
        super.doLayout();
    }

    public void registerListenersOn(@NotNull Component component) {
        if (component == null) {
            TooltipComponent.$$$reportNull$$$0(4);
        }
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TooltipComponent.this.myExpandedSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.myParent.addComponentListener(TooltipComponent.this.myParentListener);
                TooltipComponent.this.resetBounds();
                TooltipComponent.this.myParent.add((Component)TooltipComponent.this, JLayeredPane.POPUP_LAYER);
                TooltipComponent.this.myLastPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                TooltipComponent.this.setVisible(TooltipComponent.this.myDefaultVisibilityOverride == null ? true : (Boolean)TooltipComponent.this.myDefaultVisibilityOverride.produce());
                TooltipComponent.this.revalidate();
                TooltipComponent.this.myLastSize = TooltipComponent.this.myTooltipContent.getPreferredSize();
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myLastSize);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TooltipComponent.this.repaintLastPoint(TooltipComponent.this.myLastSize);
                TooltipComponent.this.myExpandedSize.setSize(0, 0);
                TooltipComponent.this.myTooltipContent.setSize(0, 0);
                TooltipComponent.this.removeFromParent();
                TooltipComponent.this.setVisible(false);
                TooltipComponent.this.myLastPoint = null;
                TooltipComponent.this.myLastSize = null;
            }

            private void handleMove(MouseEvent e) {
                Point nextPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TooltipComponent.this);
                if (TooltipComponent.this.myLastPoint != null && TooltipComponent.this.myLastPoint.equals(nextPoint)) {
                    return;
                }
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myTooltipContent.getSize());
                TooltipComponent.this.myLastPoint = nextPoint;
                if (!TooltipComponent.this.isVisible()) {
                    TooltipComponent.this.myExpandedSize.setSize(0, 0);
                }
                if (!TooltipComponent.this.myTooltipContent.getPreferredSize().equals(TooltipComponent.this.myTooltipContent.getBounds().getSize())) {
                    TooltipComponent.this.revalidate();
                }
                TooltipComponent.this.myLastSize = TooltipComponent.this.myTooltipContent.getPreferredSize();
                TooltipComponent.this.repaintIfVisible(TooltipComponent.this.myLastSize);
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
    }

    @Override
    public Dimension getPreferredSize() {
        return TooltipComponent.max(TooltipComponent.max(this.myTooltipContent.getPreferredSize(), this.myTooltipContent.getMinimumSize()), this.myExpandedSize);
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.isVisible()) {
            return;
        }
        assert (this.myLastPoint != null);
        Dimension preferredSize = this.getPreferredSize();
        Point paintLocation = this.getPaintLocation(this.myLastPoint, preferredSize);
        this.myTooltipContent.setLocation(paintLocation.x, paintLocation.y);
        g.setColor(Color.WHITE);
        g.fillRect(paintLocation.x, paintLocation.y, preferredSize.width, preferredSize.height);
        g.setStroke(new BasicStroke(1.0f));
        RoundRectangle2D.Float rect = new RoundRectangle2D.Float();
        for (int i = 1; i <= DROPSHADOW_ALPHAS.length; ++i) {
            g.setColor(new Color(0, 0, 0, DROPSHADOW_ALPHAS[i - 1]));
            rect.setRoundRect(paintLocation.x - i, paintLocation.y - i, preferredSize.width + i * 2, preferredSize.height + i * 2, i * 2, i * 2);
            g.draw(rect);
        }
    }

    @NotNull
    private Point getPaintLocation(@NotNull Point lastPoint, @NotNull Dimension preferredSize) {
        if (lastPoint == null) {
            TooltipComponent.$$$reportNull$$$0(5);
        }
        if (preferredSize == null) {
            TooltipComponent.$$$reportNull$$$0(6);
        }
        Dimension parentSize = this.getParent().getSize();
        int x = Math.max(Math.min(lastPoint.x + 5, parentSize.width - preferredSize.width - 5), 10);
        int y = Math.max(Math.min(lastPoint.y + 5, parentSize.height - preferredSize.height - 5), 10);
        Point point = new Point(x, y);
        if (point == null) {
            TooltipComponent.$$$reportNull$$$0(7);
        }
        return point;
    }

    public void repaintIfVisible(@NotNull Dimension contentDimension) {
        if (contentDimension == null) {
            TooltipComponent.$$$reportNull$$$0(8);
        }
        if (this.isVisible() && contentDimension.width > 0 && contentDimension.height > 0) {
            this.repaintLastPoint(contentDimension);
        }
    }

    private void repaintLastPoint(@Nullable Dimension repaintDimension) {
        if (this.myLastPoint == null) {
            return;
        }
        Dimension preferredSize = repaintDimension == null ? this.getPreferredSize() : repaintDimension;
        Point paintLocation = this.getPaintLocation(this.myLastPoint, preferredSize);
        this.opaqueRepaint(paintLocation.x - DROPSHADOW_ALPHAS.length, paintLocation.y - DROPSHADOW_ALPHAS.length, preferredSize.width + 2 * DROPSHADOW_ALPHAS.length + 1, preferredSize.height + 2 * DROPSHADOW_ALPHAS.length + 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/TooltipComponent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPoint";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredSize";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDimension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/TooltipComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "max";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaintLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "max";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerListenersOn";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPaintLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "repaintIfVisible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        @NotNull
        private final JComponent myTooltipContent;
        @NotNull
        private final JComponent myOwner;
        @NotNull
        private final JLayeredPane myParent;
        @NotNull
        private Producer<Boolean> myIsOwnerDisplayable;
        @Nullable
        private Producer<Boolean> myDefaultVisibilityOverride;

        public Builder(@NotNull JComponent tooltipContent, @NotNull JComponent owner, @NotNull JLayeredPane parent) {
            if (tooltipContent == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (owner == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myTooltipContent = tooltipContent;
            this.myOwner = owner;
            this.myParent = parent;
            this.myIsOwnerDisplayable = this.myOwner::isDisplayable;
        }

        @NotNull
        public Builder setIsOwnerDisplayable(@NotNull Producer<Boolean> isOwnerDisplayable) {
            if (isOwnerDisplayable == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myIsOwnerDisplayable = isOwnerDisplayable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setDefaultVisibilityOverride(@NotNull Producer<Boolean> defaultVisibilityOverride) {
            if (defaultVisibilityOverride == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myDefaultVisibilityOverride = defaultVisibilityOverride;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public TooltipComponent build() {
            TooltipComponent tooltipComponent = new TooltipComponent(this);
            if (tooltipComponent == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return tooltipComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltipContent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isOwnerDisplayable";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/TooltipComponent$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultVisibilityOverride";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/TooltipComponent$Builder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIsOwnerDisplayable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDefaultVisibilityOverride";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setIsOwnerDisplayable";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultVisibilityOverride";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

