/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.TooltipComponent;
import com.android.tools.adtui.model.Range;
import com.intellij.ui.JBColor;
import com.intellij.util.Producer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RangeTooltipComponent
extends AnimatedComponent {
    public static final Color HIGHLIGHT_COLOR = new JBColor(4882943, 7910143);
    private static final float HIGHLIGHT_WIDTH = 2.0f;
    private static final float INVALID_HIGHLIGHT_X = -3.4028235E38f;
    private float myOldHighlightX;
    @NotNull
    private final Range myHighlightRange;
    @NotNull
    private final Range myViewRange;
    @NotNull
    private final Range myDataRange;
    @NotNull
    private final TooltipComponent myTooltipComponent;
    @NotNull
    private final Supplier<Boolean> myShowSeekComponent;
    @Nullable
    private Point myLastPoint;

    public RangeTooltipComponent(@NotNull Range highlight, @NotNull Range view, @NotNull Range data, @NotNull JComponent component, @NotNull JLayeredPane parent, @NotNull Supplier<Boolean> showSeekComponent) {
        if (highlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(0);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(1);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(2);
        }
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            RangeTooltipComponent.$$$reportNull$$$0(4);
        }
        if (showSeekComponent == null) {
            RangeTooltipComponent.$$$reportNull$$$0(5);
        }
        this.myOldHighlightX = -3.4028235E38f;
        this.myHighlightRange = highlight;
        this.myViewRange = view;
        this.myDataRange = data;
        this.myShowSeekComponent = showSeekComponent;
        this.myTooltipComponent = new TooltipComponent.Builder(component, this, parent).setDefaultVisibilityOverride((Producer<Boolean>)((Producer)() -> this.isHighlightRangeVisible())).build();
        this.myViewRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::refreshRanges);
        this.myHighlightRange.addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::highlightRangeChanged);
    }

    public RangeTooltipComponent(@NotNull Range hightlight, @NotNull Range view, @NotNull Range data, @NotNull JComponent component) {
        if (hightlight == null) {
            RangeTooltipComponent.$$$reportNull$$$0(6);
        }
        if (view == null) {
            RangeTooltipComponent.$$$reportNull$$$0(7);
        }
        if (data == null) {
            RangeTooltipComponent.$$$reportNull$$$0(8);
        }
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(9);
        }
        this(hightlight, view, data, component, new JLayeredPane(), () -> true);
    }

    public void registerListenersOn(@NotNull JComponent component) {
        if (component == null) {
            RangeTooltipComponent.$$$reportNull$$$0(10);
        }
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handleMove(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeTooltipComponent.this.myLastPoint = null;
                RangeTooltipComponent.this.myHighlightRange.clear();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handleMove(e);
            }

            private void handleMove(MouseEvent e) {
                Point nextPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), RangeTooltipComponent.this);
                if (RangeTooltipComponent.this.myLastPoint != null && RangeTooltipComponent.this.myLastPoint.equals(nextPoint)) {
                    return;
                }
                RangeTooltipComponent.this.myLastPoint = nextPoint;
                RangeTooltipComponent.this.refreshRanges();
            }
        };
        component.addMouseMotionListener(adapter);
        component.addMouseListener(adapter);
        this.myTooltipComponent.registerListenersOn(component);
    }

    private void refreshRanges() {
        if (this.isShowing()) {
            if (this.myLastPoint != null) {
                double current = this.xToRange(this.myLastPoint.x);
                this.myHighlightRange.set(current, current);
            } else {
                this.myHighlightRange.clear();
            }
        }
    }

    private void highlightRangeChanged() {
        if (this.myHighlightRange.isEmpty() && this.myOldHighlightX == -3.4028235E38f) {
            return;
        }
        if (this.myOldHighlightX != -3.4028235E38f) {
            int minX = (int)Math.floor((double)this.myOldHighlightX - 1.0);
            int width = (int)Math.ceil((double)this.myOldHighlightX + 1.0) - minX;
            this.opaqueRepaint(minX, 0, width, this.getHeight());
            this.myOldHighlightX = -3.4028235E38f;
        }
        if (this.isHighlightRangeVisible() && this.myShowSeekComponent.get().booleanValue()) {
            float x = this.rangeToX(this.myHighlightRange.getMin());
            int minX = (int)Math.floor((double)x - 1.0);
            int width = (int)Math.ceil((double)x + 1.0) - minX;
            this.opaqueRepaint(minX, 0, width, this.getHeight());
        }
        this.myTooltipComponent.setVisible(this.isHighlightRangeVisible());
    }

    double xToRange(int x) {
        return (double)x / (double)this.getWidth() * this.myViewRange.getLength() + this.myViewRange.getMin();
    }

    float rangeToX(double value) {
        return (float)((double)this.getWidth() * (value - this.myViewRange.getMin()) / (this.myViewRange.getMax() - this.myViewRange.getMin()));
    }

    private boolean isHighlightRangeVisible() {
        return this.myLastPoint != null && !this.myHighlightRange.isEmpty() && this.myHighlightRange.getMin() >= this.myDataRange.getMin();
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        if (!this.isHighlightRangeVisible()) {
            return;
        }
        if (this.myShowSeekComponent.get().booleanValue()) {
            float x;
            this.myOldHighlightX = x = this.rangeToX(this.myHighlightRange.getMin());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(HIGHLIGHT_COLOR);
            g.setStroke(new BasicStroke(2.0f));
            Path2D.Float path = new Path2D.Float();
            path.moveTo(x, 0.0f);
            path.lineTo(x, this.getHeight());
            g.draw(path);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showSeekComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hightlight";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/RangeTooltipComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListenersOn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

