/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.AutoSuggestEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.util.JavaLanguage;
import java.util.List;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

public class ToggleGroupEditor
extends AutoSuggestEditor {
    List<String> suggestedTgs;

    public ToggleGroupEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedTgs) {
        super(propMeta, selectedClasses, suggestedTgs);
        this.initialize(suggestedTgs);
    }

    private void initialize(List<String> suggestedTgs) {
        this.suggestedTgs = suggestedTgs;
        EventHandler onActionListener = event -> {
            if (this.isHandlingError()) {
                return;
            }
            String value = this.textField.getText();
            if (value != null && !value.isEmpty() && !JavaLanguage.isIdentifier(value)) {
                this.handleInvalidValue(value);
                return;
            }
            this.userUpdateValueProperty(value == null || value.isEmpty() ? null : value);
            this.textField.selectAll();
        };
        this.setTextEditorBehavior(this, (Control)this.textField, (EventHandler<ActionEvent>)onActionListener);
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses, List<String> suggestedTgs) {
        super.reset(propMeta, selectedClasses, suggestedTgs);
    }
}

