/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.remote.RemoteConfigurationType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskDebugRunner;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForkedDebuggerThread
extends Thread {
    @NotNull
    private final ProcessHandler myMainProcessHandler;
    @NotNull
    private final ServerSocket mySocket;
    @NotNull
    private final Project myProject;
    @Nullable
    private final ExecutionConsole myMainExecutionConsole;

    ForkedDebuggerThread(@NotNull ProcessHandler mainProcessHandler, @NotNull RunContentDescriptor mainRunContentDescriptor, @NotNull ServerSocket socket, @NotNull Project project) {
        if (mainProcessHandler == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(0);
        }
        if (mainRunContentDescriptor == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(1);
        }
        if (socket == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(2);
        }
        if (project == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(3);
        }
        super("external task forked debugger runner");
        this.setDaemon(true);
        this.mySocket = socket;
        this.myProject = project;
        this.myMainProcessHandler = mainProcessHandler;
        this.myMainExecutionConsole = mainRunContentDescriptor.getExecutionConsole();
        this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.closeSocket();
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.closeSocket();
            }

            void closeSocket() {
                try {
                    if (!ForkedDebuggerThread.this.mySocket.isClosed()) {
                        ForkedDebuggerThread.this.mySocket.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    public void run() {
        while (!(this.myMainProcessHandler.isProcessTerminated() || this.myMainProcessHandler.isProcessTerminating() || this.mySocket.isClosed())) {
            try {
                this.handleForkedProcessSignal(this.mySocket.accept());
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                ExternalSystemTaskDebugRunner.LOG.warn((Throwable)e);
            }
        }
        try {
            if (!this.mySocket.isClosed()) {
                this.mySocket.close();
            }
        }
        catch (IOException e) {
            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
        }
    }

    private void handleForkedProcessSignal(final Socket accept) throws IOException {
        final DataInputStream stream = new DataInputStream(accept.getInputStream());
        this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                StreamUtil.closeStream((Closeable)stream);
                StreamUtil.closeStream((Closeable)accept);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$2", "processTerminated"));
            }
        });
        int signal = stream.readInt();
        final String processName = stream.readUTF();
        if (signal > 0) {
            String debugPort = String.valueOf(signal);
            ForkedDebuggerThread.attachVM(this.myProject, processName, debugPort, new ProgramRunner.Callback(){

                public void processStarted(RunContentDescriptor descriptor2) {
                    descriptor2.setSelectContentWhenAdded(false);
                    final ProcessHandler forkedProcessHandler = descriptor2.getProcessHandler();
                    if (forkedProcessHandler != null) {
                        ForkedDebuggerThread.this.myMainProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                                if (event == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                ForkedDebuggerThread.this.myMainProcessHandler.removeProcessListener((ProcessListener)this);
                                ForkedDebuggerThread.this.terminateForkedProcess(forkedProcessHandler);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$3$1", "processWillTerminate"));
                            }
                        });
                        forkedProcessHandler.addProcessListener((ProcessListener)new MyForkedProcessListener(descriptor2, processName));
                        try {
                            accept.getOutputStream().write(0);
                            stream.close();
                        }
                        catch (IOException e) {
                            ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
                        }
                    }
                }
            });
        } else if (signal == 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ProcessHandler handler;
                RunContentDescriptor descriptor2;
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
                ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
                Content content = contentManager.findContent(processName);
                if (content != null && (descriptor2 = (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) != null && (handler = descriptor2.getProcessHandler()) != null) {
                    handler.destroyProcess();
                }
                try {
                    accept.getOutputStream().write(0);
                    stream.close();
                }
                catch (IOException e) {
                    ExternalSystemTaskDebugRunner.LOG.debug((Throwable)e);
                }
            });
        }
    }

    private static void attachVM(@NotNull Project project, String runConfigName, @NotNull String debugPort, ProgramRunner.Callback callback) {
        if (project == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(4);
        }
        if (debugPort == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(5);
        }
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(runConfigName, RemoteConfigurationType.class);
        runSettings.setActivateToolWindowBeforeRun(false);
        RemoteConfiguration configuration = (RemoteConfiguration)runSettings.getConfiguration();
        configuration.HOST = "localhost";
        configuration.PORT = debugPort;
        configuration.USE_SOCKET_TRANSPORT = true;
        configuration.SERVER_MODE = true;
        try {
            ExecutionEnvironment environment = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)runSettings).contentToReuse(null).dataContext(null).activeTarget().build();
            ProgramRunnerUtil.executeConfigurationAsync((ExecutionEnvironment)environment, (boolean)true, (boolean)true, (ProgramRunner.Callback)callback);
        }
        catch (ExecutionException e) {
            ExternalSystemTaskDebugRunner.LOG.error((Throwable)e);
        }
    }

    private void terminateForkedProcess(@NotNull ProcessHandler processHandler) {
        DebugProcess debugProcess;
        if (processHandler == null) {
            ForkedDebuggerThread.$$$reportNull$$$0(6);
        }
        if ((debugProcess = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(processHandler)) != null) {
            debugProcess.getManagerThread().invokeCommand(new DebuggerCommand(){

                public void action() {
                    VirtualMachineProxy virtualMachineProxy = debugProcess.getVirtualMachineProxy();
                    if (virtualMachineProxy instanceof VirtualMachineProxyImpl && ((VirtualMachineProxyImpl)virtualMachineProxy).canBeModified()) {
                        ((VirtualMachineProxyImpl)virtualMachineProxy).exit(0);
                    } else {
                        debugProcess.stop(true);
                    }
                }

                public void commandCancelled() {
                    debugProcess.stop(true);
                }
            });
        } else {
            processHandler.destroyProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainProcessHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainRunContentDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugPort";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "attachVM";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "terminateForkedProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyForkedProcessListener
    extends ProcessAdapter {
        @NotNull
        private final RunContentDescriptor myDescriptor;
        @NotNull
        private final String myProcessName;
        @Nullable
        private RangeHighlighter myHyperlink;

        MyForkedProcessListener(@NotNull RunContentDescriptor descriptor2, String processName) {
            if (descriptor2 == null) {
                MyForkedProcessListener.$$$reportNull$$$0(0);
            }
            if (processName == null) {
                MyForkedProcessListener.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor2;
            this.myProcessName = processName;
        }

        public void startNotified(@NotNull ProcessEvent event) {
            if (event == null) {
                MyForkedProcessListener.$$$reportNull$$$0(2);
            }
            this.postLink();
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            if (event == null) {
                MyForkedProcessListener.$$$reportNull$$$0(3);
            }
            if (!willBeDestroyed) {
                ForkedDebuggerThread.this.terminateForkedProcess(event.getProcessHandler());
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MyForkedProcessListener.$$$reportNull$$$0(4);
            }
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject);
            ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
            Content content = this.myDescriptor.getAttachedContent();
            if (content != null) {
                ApplicationManager.getApplication().invokeLater(() -> contentManager.removeContent(content, true));
            }
            this.removeLink();
        }

        private void postLink() {
            ConsoleViewImpl mainConsoleView = this.getMainConsoleView();
            if (mainConsoleView != null) {
                ProcessHandler handler = this.myDescriptor.getProcessHandler();
                String addressDisplayName = "";
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ForkedDebuggerThread.this.myProject).getDebugProcess(handler);
                if (debugProcess instanceof DebugProcessImpl) {
                    addressDisplayName = "(" + DebuggerBundle.getAddressDisplayName((RemoteConnection)((DebugProcessImpl)debugProcess).getConnection()) + ")";
                }
                String linkText = ExternalSystemBundle.message((String)"debugger.open.session.tab", (Object[])new Object[0]);
                String debuggerAttachedStatusMessage = ExternalSystemBundle.message((String)"debugger.status.connected", (Object[])new Object[]{this.myProcessName, addressDisplayName}) + ". " + linkText + '\n';
                mainConsoleView.print(debuggerAttachedStatusMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
                mainConsoleView.performWhenNoDeferredOutput(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int messageOffset = mainConsoleView.getText().indexOf(debuggerAttachedStatusMessage);
                    int linkStartOffset = messageOffset + debuggerAttachedStatusMessage.indexOf(linkText);
                    this.myHyperlink = hyperlinkSupport.createHyperlink(linkStartOffset, linkStartOffset + linkText.length(), null, project -> {
                        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)ForkedDebuggerThread.this.myProject);
                        ContentManager contentManager = toolWindowManager.getToolWindow(ToolWindowId.DEBUG).getContentManager();
                        Content content = this.myDescriptor.getAttachedContent();
                        if (content != null) {
                            contentManager.setSelectedContent(content, true, true);
                        }
                    });
                });
            }
        }

        private void removeLink() {
            ConsoleViewImpl mainConsoleView;
            if (this.myHyperlink != null && (mainConsoleView = this.getMainConsoleView()) != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    EditorHyperlinkSupport hyperlinkSupport = mainConsoleView.getHyperlinks();
                    int startOffset = this.myHyperlink.getStartOffset();
                    int endOffset = this.myHyperlink.getEndOffset();
                    TextAttributes inactiveTextAttributes = this.myHyperlink.getTextAttributes() != null ? this.myHyperlink.getTextAttributes().clone() : TextAttributes.ERASE_MARKER.clone();
                    inactiveTextAttributes.setForegroundColor(UIUtil.getInactiveTextColor());
                    inactiveTextAttributes.setEffectColor(UIUtil.getInactiveTextColor());
                    inactiveTextAttributes.setFontType(2);
                    hyperlinkSupport.removeHyperlink(this.myHyperlink);
                    hyperlinkSupport.addHighlighter(startOffset, endOffset, inactiveTextAttributes, 5800);
                });
            }
        }

        @Nullable
        private ConsoleViewImpl getMainConsoleView() {
            Object consoleView;
            if (ForkedDebuggerThread.this.myMainExecutionConsole == null) {
                return null;
            }
            if (ForkedDebuggerThread.this.myMainExecutionConsole instanceof ConsoleViewImpl) {
                return (ConsoleViewImpl)ForkedDebuggerThread.this.myMainExecutionConsole;
            }
            if (ForkedDebuggerThread.this.myMainExecutionConsole instanceof DataProvider && (consoleView = ((DataProvider)ForkedDebuggerThread.this.myMainExecutionConsole).getData(LangDataKeys.CONSOLE_VIEW.getName())) instanceof ConsoleViewImpl) {
                return (ConsoleViewImpl)consoleView;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/ForkedDebuggerThread$MyForkedProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startNotified";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processWillTerminate";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

