/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemToggleAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class IgnoreExternalProjectAction
extends ExternalSystemToggleAction {
    private static final Logger LOG = Logger.getInstance(IgnoreExternalProjectAction.class);

    public IgnoreExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.ignore.external.projects.text", (Object[])new Object[]{"external", "project"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.ignore.external.projects.description", (Object[])new Object[]{"external", "project"}));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(0);
        }
        ProjectSystemId projectSystemId = this.getSystemId(e);
        List<ExternalSystemNode<ExternalConfigPathAware>> projectNodes = IgnoreExternalProjectAction.getProjectNodes(e);
        if (projectNodes.isEmpty()) {
            return;
        }
        final Project project = this.getProject(e);
        ExternalSystemActionsCollector.trigger(project, projectSystemId, (AnAction)this, e, new String[0]);
        projectNodes.forEach(projectNode -> projectNode.setIgnored(state));
        final Set uniqueExternalProjects = projectNodes.stream().map(projectNode -> {
            DataNode projectDataNode;
            String externalProjectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
            ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo(project, projectSystemId, externalProjectPath);
            DataNode dataNode = projectDataNode = externalProjectInfo == null ? null : externalProjectInfo.getExternalProjectStructure();
            if (projectDataNode == null && LOG.isDebugEnabled()) {
                LOG.debug(String.format("external project data not found, path: %s, data: %s", externalProjectPath, externalProjectInfo));
            }
            return projectDataNode;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, e.getPresentation().getText(), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                uniqueExternalProjects.forEach(externalProjectInfo -> ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProjectInfo, project, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction$1", "run"));
            }
        });
    }

    @Override
    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(1);
        }
        boolean selected = super.isSelected(e);
        ProjectSystemId systemId = this.getSystemId(e);
        String systemIdName = systemId != null ? systemId.getReadableName() : "external";
        String pluralizedProjects = StringUtil.pluralize((String)"project", (int)IgnoreExternalProjectAction.getProjectNodes(e).size());
        if (selected) {
            this.setText(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.text", (Object[])new Object[]{systemIdName, pluralizedProjects}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.unignore.external.projects.description", (Object[])new Object[]{systemIdName, pluralizedProjects}));
        } else {
            this.setText(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.text", (Object[])new Object[]{systemIdName, pluralizedProjects}));
            this.setDescription(e, ExternalSystemBundle.message((String)"action.ignore.external.projects.description", (Object[])new Object[]{systemIdName, pluralizedProjects}));
        }
        return selected;
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(2);
        }
        if (!super.isEnabled(e)) {
            return false;
        }
        return !IgnoreExternalProjectAction.getProjectNodes(e).isEmpty();
    }

    @Override
    protected boolean doIsSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(3);
        }
        return ContainerUtil.exists(IgnoreExternalProjectAction.getProjectNodes(e), projectNode -> projectNode.isIgnored());
    }

    @NotNull
    private static List<ExternalSystemNode<ExternalConfigPathAware>> getProjectNodes(@NotNull AnActionEvent e) {
        List selectedNodes;
        if (e == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(4);
        }
        if ((selectedNodes = (List)ExternalSystemDataKeys.SELECTED_NODES.getData(e.getDataContext())) == null || selectedNodes.isEmpty()) {
            List<ExternalSystemNode<ExternalConfigPathAware>> list = Collections.emptyList();
            if (list == null) {
                IgnoreExternalProjectAction.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<ExternalSystemNode<ExternalConfigPathAware>> list = selectedNodes.stream().map(node -> node instanceof ModuleNode || node instanceof ProjectNode ? node : null).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            IgnoreExternalProjectAction.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/action/IgnoreExternalProjectAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doIsSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNodes";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

