/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.schema.YamlEmptyObjectAdapter;
import org.jetbrains.yaml.schema.YamlObjectAdapter;
import org.jetbrains.yaml.schema.YamlPropertyAdapter;

public class YamlJsonPsiWalker
implements JsonLikePsiWalker {
    public static final YamlJsonPsiWalker INSTANCE = new YamlJsonPsiWalker();

    private YamlJsonPsiWalker() {
    }

    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof YAMLDocument || parent instanceof YAMLMapping) {
            return ThreeState.YES;
        }
        if (parent instanceof YAMLKeyValue && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            ASTNode prev = element.getNode().getTreePrev();
            return prev.getElementType() == YAMLTokenTypes.INDENT ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof YAMLSequenceItem && YamlJsonPsiWalker.isFirstChild(element, parent)) {
            return ThreeState.UNSURE;
        }
        return ThreeState.NO;
    }

    private static boolean isFirstChild(PsiElement element, PsiElement parent) {
        PsiElement[] children = parent.getChildren();
        return children.length != 0 && children[0] == element;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() != null;
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(1);
        }
        return element instanceof YAMLFile || element instanceof YAMLDocument;
    }

    public boolean acceptsEmptyRoot() {
        return true;
    }

    public PsiElement findElementToCheck(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(2);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof YAMLValue) && !(current instanceof YAMLKeyValue)) continue;
            return current;
        }
        return null;
    }

    public boolean requiresNameQuotes() {
        return false;
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(3);
        }
        return element instanceof YAMLValue ? YamlPropertyAdapter.createValueAdapterByType((YAMLValue)element) : (element instanceof YAMLDocument ? new YamlEmptyObjectAdapter(element) : null);
    }

    public boolean allowsSingleQuotes() {
        return true;
    }

    public boolean hasMissingCommaAfter(@NotNull PsiElement element) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        YAMLMapping mapping;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(5);
        }
        if ((mapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLMapping.class, (boolean)true, (Class[])new Class[]{YAMLKeyValue.class})) != null) {
            return new YamlPropertyAdapter(element.getParent());
        }
        YAMLKeyValue property = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class, (boolean)false);
        if (property == null) {
            return null;
        }
        YAMLValue value = property.getValue();
        if (value == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)element, (boolean)true)) {
            return null;
        }
        return new YamlPropertyAdapter((PsiElement)property);
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        if (originalPosition == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(6);
        }
        YAMLMapping object = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, YAMLMapping.class);
        YAMLMapping otherObject = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)computedPosition, YAMLMapping.class);
        if (object == null || otherObject != null && PsiTreeUtil.isAncestor((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)object), (PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)otherObject), (boolean)true)) {
            object = otherObject;
        }
        if (object == null) {
            return Collections.emptySet();
        }
        return new YamlObjectAdapter(object).getPropertyList().stream().map(p -> p.getName()).collect(Collectors.toSet());
    }

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(7);
        }
        JsonPointerPosition pos = new JsonPointerPosition();
        PsiElement current = element;
        while (!YamlJsonPsiWalker.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof YAMLSequence) {
                YAMLSequence array = (YAMLSequence)current;
                List<YAMLSequenceItem> expressions = array.getItems();
                int idx = -1;
                for (int i = 0; i < expressions.size(); ++i) {
                    YAMLSequenceItem value = expressions.get(i);
                    if (!position.equals(value)) continue;
                    idx = i;
                    break;
                }
                if (idx == -1) continue;
                pos.addPrecedingStep(idx);
                continue;
            }
            if (current instanceof YAMLSequenceItem) continue;
            if (current instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)current).getName());
                if (!((current = current.getParent()) instanceof YAMLMapping)) {
                    return null;
                }
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (current instanceof YAMLMapping && position instanceof YAMLKeyValue) {
                propertyName = StringUtil.notNullize((String)((YAMLKeyValue)position).getName());
                if (propertyName.contains("IntellijIdeaRulezzz")) continue;
                pos.addPrecedingStep(propertyName);
                continue;
            }
            if (YamlJsonPsiWalker.breakCondition(current)) break;
            if (current instanceof YAMLMapping) {
                List<YAMLPsiElement> elements = ((YAMLMapping)current).getYAMLElements();
                if (elements.size() == 0) {
                    return null;
                }
                if (position instanceof YAMLPsiElement && elements.contains(position)) continue;
            }
            return null;
        }
        return pos;
    }

    private static boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof YAMLDocument || current instanceof YAMLBlockMappingImpl && current.getParent() instanceof YAMLDocument;
    }

    public boolean requiresValueQuotes() {
        return false;
    }

    public String getDefaultObjectValue() {
        return "";
    }

    public String getDefaultArrayValue() {
        return "- ";
    }

    public boolean hasWhitespaceDelimitedCodeBlocks() {
        return true;
    }

    public String getNodeTextForValidation(PsiElement element) {
        String text = element.getText();
        if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"!!") && !StringUtil.startsWithChar((CharSequence)text, (char)'&')) {
            return text;
        }
        int spaceIndex = text.indexOf(32);
        return spaceIndex > 0 ? text.substring(spaceIndex + 1) : text;
    }

    public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        YAMLAnchor[] anchors;
        if (element == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(8);
        }
        if ((anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)element, YAMLAnchor.class)) == null || anchors.length == 0) {
            return element.getTextRange();
        }
        YAMLAnchor lastAnchor = anchors[anchors.length - 1];
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)lastAnchor);
        return next == null ? element.getTextRange() : next.getTextRange();
    }

    public JsonLikeSyntaxAdapter getSyntaxAdapter(final Project project) {
        return new JsonLikeSyntaxAdapter(){
            private final YAMLElementGenerator myGenerator;
            {
                this.myGenerator = YAMLElementGenerator.getInstance(project);
            }

            @Nullable
            public PsiElement getPropertyValue(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                YAMLValue value = ((YAMLKeyValue)property).getValue();
                if (value == null) {
                    return null;
                }
                return this.adjustValue((PsiElement)value);
            }

            @NotNull
            public PsiElement adjustValue(@NotNull PsiElement value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(value instanceof YAMLValue)) {
                    PsiElement psiElement = value;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                YAMLAnchor[] anchors = (YAMLAnchor[])PsiTreeUtil.getChildrenOfType((PsiElement)value, YAMLAnchor.class);
                if (anchors == null || anchors.length == 0) {
                    PsiElement psiElement = value;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiElement;
                }
                PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)anchors[anchors.length - 1]);
                PsiElement psiElement = next == null ? value : next;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiElement;
            }

            @Nullable
            public String getPropertyName(PsiElement property) {
                assert (property instanceof YAMLKeyValue);
                return ((YAMLKeyValue)property).getName();
            }

            private YAMLKeyValue findPrecedingKeyValueWithNoValue(PsiElement element) {
                if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT) {
                    PsiElement prev = element.getPrevSibling();
                    PsiElement psiElement = prev = prev == null ? null : prev.getPrevSibling();
                    if (prev instanceof YAMLKeyValue && ((YAMLKeyValue)prev).getValue() == null) {
                        return (YAMLKeyValue)prev;
                    }
                }
                return null;
            }

            @NotNull
            public PsiElement createProperty(@NotNull String name, @NotNull String value, PsiElement element) {
                if (name == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(5);
                }
                YAMLKeyValue keyValue = this.myGenerator.createYamlKeyValue(name, StringUtil.unquoteString((String)value));
                YAMLKeyValue yAMLKeyValue = element instanceof YAMLDocument || this.findPrecedingKeyValueWithNoValue(element) != null ? this.myGenerator.createDummyYamlWithText(keyValue.getText()).getDocuments().get(0).getFirstChild() : keyValue;
                if (yAMLKeyValue == null) {
                    1.$$$reportNull$$$0(6);
                }
                return yAMLKeyValue;
            }

            public boolean ensureComma(PsiElement self, PsiElement newElement) {
                if (newElement instanceof YAMLKeyValue && self instanceof YAMLKeyValue) {
                    self.getParent().addAfter(this.myGenerator.createEol(), self);
                }
                return false;
            }

            public void removeIfComma(PsiElement forward) {
                if (forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == YAMLTokenTypes.EOL) {
                    PsiElement nextSibling;
                    while ((nextSibling = forward.getNextSibling()) instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == YAMLTokenTypes.INDENT) {
                        nextSibling.delete();
                    }
                    forward.delete();
                }
            }

            public boolean fixWhitespaceBefore(PsiElement initialElement, PsiElement element) {
                return initialElement instanceof YAMLValue && initialElement != element;
            }

            @NotNull
            public String getDefaultValueFromType(@Nullable JsonSchemaType type) {
                if (type == null) {
                    if ("" == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return "";
                }
                if (type == JsonSchemaType._object) {
                    if (" " == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return " ";
                }
                if (type == JsonSchemaType._array) {
                    if (" - " == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    return " - ";
                }
                String string = type.getDefaultValue();
                if (string == null) {
                    1.$$$reportNull$$$0(10);
                }
                return string;
            }

            public PsiElement adjustNewProperty(PsiElement element) {
                if (element instanceof YAMLMapping) {
                    return element.getFirstChild();
                }
                return element;
            }

            public PsiElement adjustPropertyAnchor(LeafPsiElement element) {
                YAMLKeyValue keyValue = this.findPrecedingKeyValueWithNoValue((PsiElement)element);
                assert (keyValue != null) : "Should come here only for YAMLKeyValue with no value and a following indent";
                keyValue.addBefore(this.myGenerator.createEol(), null);
                keyValue.addBefore(this.myGenerator.createIndent(element.getTextLength()), null);
                PsiElement prev = element.getPrevSibling();
                if (prev != null) {
                    prev.delete();
                }
                element.delete();
                return keyValue;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "adjustValue";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProperty";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultValueFromType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "adjustValue";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "createProperty";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public PsiElement getParentContainer(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class), (Class[])new Class[]{YAMLMapping.class, YAMLSequence.class});
    }

    @Nullable
    public PsiElement getRoot(@NotNull PsiFile file) {
        if (file == null) {
            YamlJsonPsiWalker.$$$reportNull$$$0(9);
        }
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        List<YAMLDocument> documents = ((YAMLFile)file).getDocuments();
        if (documents.size() != 1) {
            return null;
        }
        YAMLDocument document = documents.get(0);
        YAMLValue topLevelValue = document.getTopLevelValue();
        return topLevelValue == null ? document : topLevelValue;
    }

    @Nullable
    public PsiElement getPropertyNameElement(PsiElement property) {
        return property instanceof YAMLKeyValue ? ((YAMLKeyValue)property).getKey() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonPsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyWithValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopJsonElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementToCheck";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMissingCommaAfter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentPropertyAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

