/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SingleAlarm;
import com.intellij.util.messages.MessageBusConnection;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AutoSyncManager;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManager;
import org.jetbrains.settingsRepository.IcsManager$commitAlarm$1$$special$;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.IcsUrlBuilderKt;
import org.jetbrains.settingsRepository.ReadOnlySourceManager;
import org.jetbrains.settingsRepository.RepositoryManager;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.SyncManager;
import org.jetbrains.settingsRepository.SyncType;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.GitRepositoryManager;
import org.jetbrains.settingsRepository.git.GitRepositoryService;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002EFB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\b\u00105\u001a\u000202H\u0002J/\u00106\u001a\u0002022\u001c\u00107\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020209\u0012\u0006\u0012\u0004\u0018\u00010\u000108H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u000202H\u0002J\u0006\u0010<\u001a\u000202J7\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010A2\u0010\b\u0002\u0010B\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010CH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0015\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0013R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006G"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager;", "", "dir", "Ljava/nio/file/Path;", "schemeManagerFactory", "Lkotlin/Lazy;", "Lcom/intellij/configurationStore/schemeManager/SchemeManagerFactoryBase;", "(Ljava/nio/file/Path;Lkotlin/Lazy;)V", "autoCommitEnabled", "", "autoSyncManager", "Lorg/jetbrains/settingsRepository/AutoSyncManager;", "getAutoSyncManager$intellij_settingsRepository", "()Lorg/jetbrains/settingsRepository/AutoSyncManager;", "commitAlarm", "Lcom/intellij/util/SingleAlarm;", "credentialsStore", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "getCredentialsStore", "()Lkotlin/Lazy;", "isActive", "()Z", "isRepositoryActive", "setRepositoryActive", "(Z)V", "readOnlySourcesManager", "Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "getReadOnlySourcesManager", "()Lorg/jetbrains/settingsRepository/ReadOnlySourceManager;", "repositoryManager", "Lorg/jetbrains/settingsRepository/RepositoryManager;", "getRepositoryManager", "()Lorg/jetbrains/settingsRepository/RepositoryManager;", "repositoryService", "Lorg/jetbrains/settingsRepository/RepositoryService;", "getRepositoryService", "()Lorg/jetbrains/settingsRepository/RepositoryService;", "getSchemeManagerFactory", "settings", "Lorg/jetbrains/settingsRepository/IcsSettings;", "getSettings", "()Lorg/jetbrains/settingsRepository/IcsSettings;", "settingsFile", "getSettingsFile", "()Ljava/nio/file/Path;", "syncManager", "Lorg/jetbrains/settingsRepository/SyncManager;", "getSyncManager$intellij_settingsRepository", "()Lorg/jetbrains/settingsRepository/SyncManager;", "beforeApplicationLoaded", "", "application", "Lcom/intellij/openapi/application/Application;", "cancelAndDisableAutoCommit", "runInAutoCommitDisabledMode", "task", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scheduleCommit", "setApplicationLevelStreamProvider", "sync", "syncType", "Lorg/jetbrains/settingsRepository/SyncType;", "project", "Lcom/intellij/openapi/project/Project;", "localRepositoryInitializer", "Lkotlin/Function0;", "(Lorg/jetbrains/settingsRepository/SyncType;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ApplicationLevelProvider", "IcsStreamProvider", "intellij.settingsRepository"})
public final class IcsManager {
    @NotNull
    private final Lazy<IcsCredentialsStore> credentialsStore;
    @NotNull
    private final Path settingsFile;
    @NotNull
    private final IcsSettings settings;
    @NotNull
    private final RepositoryManager repositoryManager;
    @NotNull
    private final ReadOnlySourceManager readOnlySourcesManager;
    @NotNull
    private final RepositoryService repositoryService;
    private final SingleAlarm commitAlarm;
    private volatile boolean autoCommitEnabled;
    private volatile boolean isRepositoryActive;
    @NotNull
    private final AutoSyncManager autoSyncManager;
    @NotNull
    private final SyncManager syncManager;
    @NotNull
    private final Lazy<SchemeManagerFactoryBase> schemeManagerFactory;

    @NotNull
    public final Lazy<IcsCredentialsStore> getCredentialsStore() {
        return this.credentialsStore;
    }

    @NotNull
    public final Path getSettingsFile() {
        return this.settingsFile;
    }

    @NotNull
    public final IcsSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final RepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    @NotNull
    public final ReadOnlySourceManager getReadOnlySourcesManager() {
        return this.readOnlySourcesManager;
    }

    @NotNull
    public final RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public final boolean isRepositoryActive() {
        return this.isRepositoryActive;
    }

    public final void setRepositoryActive(boolean bl) {
        this.isRepositoryActive = bl;
    }

    public final boolean isActive() {
        Collection collection;
        return this.isRepositoryActive || !(collection = (Collection)this.readOnlySourcesManager.getRepositories()).isEmpty();
    }

    @NotNull
    public final AutoSyncManager getAutoSyncManager$intellij_settingsRepository() {
        return this.autoSyncManager;
    }

    @NotNull
    public final SyncManager getSyncManager$intellij_settingsRepository() {
        return this.syncManager;
    }

    private final void scheduleCommit() {
        if (this.autoCommitEnabled) {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                Intrinsics.throwNpe();
            }
            if (!application.isUnitTestMode()) {
                this.commitAlarm.cancelAndRequest();
            }
        }
    }

    @Nullable
    public final Object sync(@NotNull SyncType syncType, @Nullable Project project, @Nullable Function0<Unit> localRepositoryInitializer, @NotNull Continuation<? super Boolean> continuation) {
        return SyncManager.sync$default(this.syncManager, syncType, project, localRepositoryInitializer, false, continuation, 8, null);
    }

    @Nullable
    public static /* synthetic */ Object sync$default(IcsManager icsManager2, SyncType syncType, Project project, Function0 function0, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        if ((n & 4) != 0) {
            function0 = null;
        }
        return icsManager2.sync(syncType, project, (Function0<Unit>)function0, (Continuation<? super Boolean>)continuation);
    }

    private final void cancelAndDisableAutoCommit() {
        if (this.autoCommitEnabled) {
            this.autoCommitEnabled = false;
            this.commitAlarm.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object runInAutoCommitDisabledMode(@NotNull Function1<? super Continuation<? super Unit>, ? extends Object> task, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof runInAutoCommitDisabledMode.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ IcsManager this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runInAutoCommitDisabledMode(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = icsManager2;
                    super(continuation);
                }
            };
        }
        var4_4 = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var4_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                this.cancelAndDisableAutoCommit();
                $continuation.L$0 = this;
                $continuation.L$1 = task;
                $continuation.label = 1;
                v1 = task.invoke((Object)$continuation);
                ** if (v1 != var6_5) goto lbl23
lbl22:
                // 1 sources

                return var6_5;
lbl23:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                task = (Function1)$continuation.L$1;
                this = (IcsManager)$continuation.L$0;
                try {
                    v2 = var4_4;
                    if (v2 instanceof Result.Failure) {
                        throw ((Result.Failure)v2).exception;
                    }
                    v1 = var4_4;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    this.autoCommitEnabled = true;
                    this.isRepositoryActive = this.repositoryManager.isRepositoryExists();
                }
lbl39:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void setApplicationLevelStreamProvider() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        StateStorageManager storageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        storageManager.removeStreamProvider(ApplicationLevelProvider.class);
        storageManager.addStreamProvider((StreamProvider)new ApplicationLevelProvider(), true);
    }

    public final void beforeApplicationLoaded(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.isRepositoryActive = this.repositoryManager.isRepositoryExists();
        StateStorageManager.DefaultImpls.addStreamProvider$default((StateStorageManager)ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager(), (StreamProvider)new ApplicationLevelProvider(), (boolean)false, (int)2, null);
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"application.messageBus.connect()");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(this){
            final /* synthetic */ IcsManager this$0;

            public void appWillBeClosed(boolean isRestart) {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    private CoroutineScope p$;
                    int label;
                    final /* synthetic */ beforeApplicationLoaded.1 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                CoroutineScope coroutineScope = this.p$;
                                this.label = 1;
                                Object object3 = AutoSyncManager.autoSync$default(this.this$0.this$0.getAutoSyncManager$intellij_settingsRepository(), true, false, (Continuation)this, 2, null);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object4 = result;
                                if (object4 instanceof Result.Failure) {
                                    throw ((Result.Failure)object4).exception;
                                }
                                Object object3 = result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = $outer;
            }
        });
        messageBusConnection2.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(this){
            final /* synthetic */ IcsManager this$0;

            public void beforeProjectLoaded(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (project.isDefault()) {
                    return;
                }
                this.this$0.getAutoSyncManager$intellij_settingsRepository().registerListeners(project);
            }

            public void afterProjectClosed(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    private CoroutineScope p$;
                    int label;
                    final /* synthetic */ beforeApplicationLoaded.2 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                CoroutineScope coroutineScope = this.p$;
                                this.label = 1;
                                Object object3 = AutoSyncManager.autoSync$default(this.this$0.this$0.getAutoSyncManager$intellij_settingsRepository(), false, false, (Continuation)this, 3, null);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object4 = result;
                                if (object4 instanceof Result.Failure) {
                                    throw ((Result.Failure)object4).exception;
                                }
                                Object object3 = result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final Lazy<SchemeManagerFactoryBase> getSchemeManagerFactory() {
        return this.schemeManagerFactory;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public IcsManager(@NotNull Path dir, @NotNull Lazy<? extends SchemeManagerFactoryBase> schemeManagerFactory) {
        IcsSettings icsSettings;
        IcsManager icsManager2;
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull(schemeManagerFactory, (String)"schemeManagerFactory");
        this.schemeManagerFactory = schemeManagerFactory;
        this.credentialsStore = LazyKt.lazy((Function0)credentialsStore.1.INSTANCE);
        Path path = dir.resolve("config.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"dir.resolve(\"config.json\")");
        this.settingsFile = path;
        Path path2 = dir.resolve("repository");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dir.resolve(\"repository\")");
        this.repositoryManager = new GitRepositoryManager(this.credentialsStore, path2);
        this.readOnlySourcesManager = new ReadOnlySourceManager(this, dir);
        IcsManager icsManager3 = this;
        try {
            icsManager2 = icsManager3;
            icsSettings = IcsSettingsKt.loadSettings(this.settingsFile);
        }
        catch (Exception exception) {
            void e;
            icsManager2 = icsManager3;
            IcsManagerKt.getLOG().error((Throwable)e);
            icsSettings = new IcsSettings();
        }
        icsManager2.settings = icsSettings;
        this.repositoryService = new GitRepositoryService();
        this.commitAlarm = new SingleAlarm(new Runnable(this){
            final /* synthetic */ IcsManager this$0;

            public final void run() {
                String title$iv = IcsBundleKt.icsMessage("task.commit.title", new Object[0]);
                Project project$iv = null;
                boolean cancellable$iv = true;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, title$iv, cancellable$iv, project$iv, title$iv, cancellable$iv, this){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ commitAlarm.1 this$0;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.this$0 = var7_7;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        ProgressIndicator indicator2 = indicator;
                        boolean bl = false;
                        Logger $receiver$iv = IcsManagerKt.getLOG();
                        boolean $i$f$runAndLogException = false;
                        try {
                            boolean bl2 = false;
                            ((Boolean)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(null, indicator2, this){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ ProgressIndicator $indicator$inlined;
                                final /* synthetic */ commitAlarm$1$$special$$inlined$runBackgroundableTask$1 this$0;
                                {
                                    this.$indicator$inlined = progressIndicator;
                                    this.this$0 = var3_3;
                                    super(2, continuation);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            Object object2 = result;
                                            if (object2 instanceof Result.Failure) {
                                                throw ((Result.Failure)object2).exception;
                                            }
                                            CoroutineScope coroutineScope = this.p$;
                                            this.label = 1;
                                            Object object3 = RepositoryManager.DefaultImpls.commit$default(this.this$0.this$0.this$0.getRepositoryManager(), this.$indicator$inlined, null, false, (Continuation)this, 2, null);
                                            Object object4 = object3;
                                            if (object3 != object) return object4;
                                            return object;
                                        }
                                        case 1: {
                                            Object object5 = result;
                                            if (object5 instanceof Result.Failure) {
                                                throw ((Result.Failure)object5).exception;
                                            }
                                            Object object4 = result;
                                            return object4;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                                    function2.p$ = (CoroutineScope)value;
                                    Function2<CoroutineScope, Continuation<? super Boolean>, Object> function22 = function2;
                                    return function22;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null)).booleanValue();
                        }
                        catch (ProcessCanceledException e$iv) {
                            throw (Throwable)e$iv;
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv.error(e$iv);
                        }
                    }
                });
            }
            {
                this.this$0 = icsManager2;
            }
        }, this.settings.getCommitDelay(), null, null, null, 28, null);
        this.autoCommitEnabled = true;
        this.autoSyncManager = new AutoSyncManager(this);
        this.syncManager = new SyncManager(this, this.autoSyncManager);
    }

    @JvmOverloads
    public /* synthetic */ IcsManager(Path path, Lazy lazy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lazy = LazyKt.lazy((Function0)1.INSTANCE);
        }
        this(path, (Lazy<? extends SchemeManagerFactoryBase>)lazy);
    }

    @JvmOverloads
    public IcsManager(@NotNull Path dir) {
        this(dir, null, 2, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager$ApplicationLevelProvider;", "Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lorg/jetbrains/settingsRepository/IcsManager;", "(Lorg/jetbrains/settingsRepository/IcsManager;)V", "delete", "", "fileSpec", "", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "intellij.settingsRepository"})
    public final class ApplicationLevelProvider
    extends IcsStreamProvider {
        @Override
        public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (!IcsManager.this.isRepositoryActive()) {
                return false;
            }
            if (IcsManager.this.getSyncManager$intellij_settingsRepository().getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Delete is prohibited now");
            }
            if (IcsManager.this.getRepositoryManager().delete(IcsUrlBuilderKt.toRepositoryPath$default(fileSpec, roamingType, null, 4, null))) {
                IcsManager.this.scheduleCommit();
            }
            return true;
        }

        public ApplicationLevelProvider() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0014J\u0088\u0001\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2!\u0010\u0017\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00060\u00182K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00060\u001cH\u0016J.\u0010 \u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0014\u0010!\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\"0\u0018H\u0016J(\u0010#\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/settingsRepository/IcsManager$IcsStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "projectId", "", "(Lorg/jetbrains/settingsRepository/IcsManager;Ljava/lang/String;)V", "enabled", "", "getEnabled", "()Z", "isExclusive", "delete", "fileSpec", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "doSave", "content", "", "size", "", "isApplicable", "isAutoCommit", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "input", "readOnly", "read", "consumer", "", "write", "intellij.settingsRepository"})
    public class IcsStreamProvider
    implements StreamProvider {
        private final String projectId;

        public boolean getEnabled() {
            return IcsManager.this.isActive();
        }

        public boolean isExclusive() {
            return IcsManager.this.isRepositoryActive();
        }

        public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.isRepositoryActive();
        }

        public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
            Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
            String fullPath = IcsUrlBuilderKt.toRepositoryPath(path, roamingType, null);
            for (Repository repository2 : IcsManager.this.getReadOnlySourcesManager().getRepositories()) {
                GitExKt.processChildren(repository2, fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                    final /* synthetic */ Function3 $processor;

                    public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                        return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)true);
                    }
                    {
                        this.$processor = function3;
                        super(2);
                    }
                }));
            }
            if (!IcsManager.this.isRepositoryActive()) {
                return false;
            }
            IcsManager.this.getRepositoryManager().processChildren(fullPath, filter, (Function2<? super String, ? super InputStream, Boolean>)((Function2)new Function2<String, InputStream, Boolean>(processor){
                final /* synthetic */ Function3 $processor;

                public final boolean invoke(@NotNull String name, @NotNull InputStream input) {
                    Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                    Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                    return (Boolean)this.$processor.invoke((Object)name, (Object)input, (Object)false);
                }
                {
                    this.$processor = function3;
                    super(2);
                }
            }));
            return true;
        }

        public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            if (IcsManager.this.getSyncManager$intellij_settingsRepository().getWriteAndDeleteProhibited()) {
                throw (Throwable)new IllegalStateException("Save is prohibited now");
            }
            if (this.doSave(fileSpec, content, size, roamingType) && this.isAutoCommit(fileSpec, roamingType)) {
                IcsManager.this.scheduleCommit();
            }
        }

        public final boolean doSave(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return IcsManager.this.getRepositoryManager().write(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType, this.projectId), content, size);
        }

        protected boolean isAutoCommit(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return true;
        }

        public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
            if (!IcsManager.this.isRepositoryActive()) {
                return false;
            }
            IcsManager.this.getRepositoryManager().read(IcsUrlBuilderKt.toRepositoryPath(fileSpec, roamingType, this.projectId), consumer);
            return true;
        }

        public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            return false;
        }

        public IcsStreamProvider(String projectId) {
            this.projectId = projectId;
        }

        public void write(@NotNull String path, @NotNull BufferExposingByteArrayOutputStream content, @NotNull RoamingType roamingType) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            StreamProvider.DefaultImpls.write((StreamProvider)this, (String)path, (BufferExposingByteArrayOutputStream)content, (RoamingType)roamingType);
        }

        public boolean isDisableExportAction() {
            return StreamProvider.DefaultImpls.isDisableExportAction((StreamProvider)this);
        }
    }
}

