/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.CleanupDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class HardwareIdDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(HardwareIdDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"HardwareIds", (String)"Hardware Id Usage", (String)"Using these device identifiers is not recommended other than for high value fraud prevention and advanced telephony use-cases. For advertising use-cases, use `AdvertisingIdClient$Info#getId` and for analytics, use `InstanceId#getId`.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).addMoreInfo("https://developer.android.com/training/articles/user-data-ids.html").setAndroidSpecific(true);
    private static final String BLUETOOTH_ADAPTER_GET_ADDRESS = "getAddress";
    private static final String WIFI_INFO_GET_MAC_ADDRESS = "getMacAddress";
    private static final String TELEPHONY_MANAGER_GET_DEVICE_ID = "getDeviceId";
    private static final String TELEPHONY_MANAGER_GET_LINE_1_NUMBER = "getLine1Number";
    private static final String TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER = "getSimSerialNumber";
    private static final String TELEPHONY_MANAGER_GET_SUBSCRIBER_ID = "getSubscriberId";
    private static final String SETTINGS_SECURE_GET_STRING = "getString";
    private static final String PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION = "com.google.android.gms.common.GooglePlayServicesNotAvailableException";
    private static final String MESSAGE_DEVICE_IDENTIFIERS = "Using `%1$s` to get device identifiers is not recommended.";
    private static final String RO_SERIALNO = "ro.serialno";
    private static final String CLASS_FOR_NAME = "forName";
    private static final String CLASSLOADER_LOAD_CLASS = "loadClass";

    public List<String> getApplicableMethodNames() {
        return Arrays.asList(BLUETOOTH_ADAPTER_GET_ADDRESS, WIFI_INFO_GET_MAC_ADDRESS, TELEPHONY_MANAGER_GET_DEVICE_ID, TELEPHONY_MANAGER_GET_LINE_1_NUMBER, TELEPHONY_MANAGER_GET_SIM_SERIAL_NUMBER, TELEPHONY_MANAGER_GET_SUBSCRIBER_ID, SETTINGS_SECURE_GET_STRING, CLASS_FOR_NAME, CLASSLOADER_LOAD_CLASS);
    }

    public void visitMethodCall(JavaContext context, UCallExpression node, PsiMethod method) {
        String methodName;
        JavaEvaluator evaluator = context.getEvaluator();
        String className = null;
        switch (methodName = method.getName()) {
            case "getAddress": {
                className = "android.bluetooth.BluetoothAdapter";
                break;
            }
            case "getMacAddress": {
                className = "android.net.wifi.WifiInfo";
                break;
            }
            case "getDeviceId": 
            case "getLine1Number": 
            case "getSimSerialNumber": 
            case "getSubscriberId": {
                className = "android.telephony.TelephonyManager";
                break;
            }
            case "getString": {
                className = "android.provider.Settings.Secure";
                break;
            }
            case "forName": {
                className = "java.lang.Class";
                break;
            }
            case "loadClass": {
                className = "java.lang.ClassLoader";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (!evaluator.isMemberInClass((PsiMember)method, className)) {
            return;
        }
        if (methodName.equals(SETTINGS_SECURE_GET_STRING)) {
            if (evaluator.getParameterCount(method) != 2 || node.getValueArgumentCount() != 2) {
                return;
            }
            String value = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)node.getValueArguments().get(1)), (boolean)false);
            if (!"android_id".equals(value)) {
                return;
            }
        } else if (methodName.equals(CLASS_FOR_NAME) || methodName.equals(CLASSLOADER_LOAD_CLASS)) {
            HardwareIdDetector.findReflectionUsage(node, context);
            return;
        }
        if (HardwareIdDetector.inCatchPlayServicesNotAvailableException((UExpression)node)) {
            return;
        }
        String message2 = String.format(MESSAGE_DEVICE_IDENTIFIERS, methodName);
        context.report(ISSUE, (UElement)node, context.getLocation((UElement)node), message2);
    }

    public List<String> getApplicableReferenceNames() {
        return Collections.singletonList("SERIAL");
    }

    public void visitReference(JavaContext context, UReferenceExpression reference, PsiElement resolved) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (resolved instanceof PsiField && evaluator.isMemberInSubClassOf((PsiMember)((PsiField)resolved), "android.os.Build", false)) {
            String message2 = String.format(MESSAGE_DEVICE_IDENTIFIERS, "SERIAL");
            context.report(ISSUE, (UElement)reference, context.getNameLocation((UElement)reference), message2);
        }
    }

    private static boolean inCatchPlayServicesNotAvailableException(UExpression expression) {
        UCatchClause surroundingCatchSection = (UCatchClause)UastUtils.getParentOfType((UElement)expression, UCatchClause.class, (boolean)true);
        if (surroundingCatchSection != null) {
            for (PsiType t : surroundingCatchSection.getTypes()) {
                if (!t.equalsToText(PLAY_SERVICES_NOT_AVAILABLE_EXCEPTION)) continue;
                return true;
            }
        }
        return false;
    }

    private static void findReflectionUsage(UCallExpression expression, JavaContext context) {
        List methodArgs = expression.getValueArguments();
        if (methodArgs.isEmpty()) {
            return;
        }
        String value = ConstantEvaluator.evaluateString((JavaContext)context, (UElement)((UElement)methodArgs.get(0)), (boolean)false);
        if (!"android.os.SystemProperties".equals(value)) {
            return;
        }
        UMethod surroundingMethod = (UMethod)UastUtils.getParentOfType((UElement)expression, UMethod.class, (boolean)true);
        if (surroundingMethod == null) {
            return;
        }
        InvokeCallVisitor visitor = new InvokeCallVisitor(context, expression);
        surroundingMethod.accept((UastVisitor)visitor);
        PsiParameter argExpression = visitor.getPsiParameter();
        if (argExpression == null) {
            return;
        }
        UClass surroundingClass = UastUtils.getContainingUClass((UElement)surroundingMethod);
        if (surroundingClass != null) {
            int paramIndex = surroundingMethod.getParameterList().getParameterIndex(argExpression);
            if (paramIndex < 0) {
                return;
            }
            FindMethodCallVisitor methodCallVisitor = new FindMethodCallVisitor(context, surroundingMethod.getPsi(), paramIndex);
            surroundingClass.accept((UastVisitor)methodCallVisitor);
        }
    }

    private static final class FindMethodCallVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;
        private final PsiMethod mPsiMethod;
        private final int mParamIndex;

        FindMethodCallVisitor(JavaContext context, PsiMethod method, int paramIndex) {
            this.mContext = context;
            this.mPsiMethod = method;
            this.mParamIndex = paramIndex;
        }

        public boolean visitCallExpression(UCallExpression expression) {
            UExpression paramExpr;
            String value;
            List expressions;
            if (this.mPsiMethod.equals(expression.resolve()) && (expressions = expression.getValueArguments()).size() > this.mParamIndex && HardwareIdDetector.RO_SERIALNO.equals(value = ConstantEvaluator.evaluateString((JavaContext)this.mContext, (UElement)(paramExpr = (UExpression)expressions.get(this.mParamIndex)), (boolean)false)) && !HardwareIdDetector.inCatchPlayServicesNotAvailableException((UExpression)expression)) {
                String message2 = String.format(HardwareIdDetector.MESSAGE_DEVICE_IDENTIFIERS, HardwareIdDetector.RO_SERIALNO);
                this.mContext.report(ISSUE, (UElement)paramExpr, this.mContext.getLocation((UElement)paramExpr), message2);
            }
            return super.visitCallExpression(expression);
        }
    }

    private static final class InvokeCallVisitor
    extends AbstractUastVisitor {
        private final UCallExpression mLoadMethod;
        private final JavaContext mContext;
        private String mLoadVariable;
        private String mMethodVariable;
        private boolean mProcessingDone;
        private PsiParameter mPsiParameter;

        public InvokeCallVisitor(JavaContext context, UCallExpression expression) {
            this.mContext = context;
            this.mLoadMethod = expression;
        }

        public boolean visitElement(UElement node) {
            return this.mProcessingDone || super.visitElement(node);
        }

        public boolean visitCallExpression(UCallExpression expression) {
            if (expression.equals(this.mLoadMethod)) {
                PsiVariable variable = CleanupDetector.getVariableElement(expression, true, false);
                this.mLoadVariable = variable == null ? null : variable.getName();
            } else if (this.mLoadVariable != null && InvokeCallVisitor.isDesiredMethodCall(expression, this.mLoadVariable, "java.lang.Class", "getMethod", 0)) {
                UExpression arg = InvokeCallVisitor.methodParameterAt(expression, 0);
                String value = ConstantEvaluator.evaluateString((JavaContext)this.mContext, (UElement)arg, (boolean)false);
                if ("get".equals(value)) {
                    PsiVariable variable = CleanupDetector.getVariableElement(expression);
                    this.mMethodVariable = variable == null ? null : variable.getName();
                }
            } else if (this.mMethodVariable != null && InvokeCallVisitor.isDesiredMethodCall(expression, this.mMethodVariable, "java.lang.reflect.Method", "invoke", 1)) {
                PsiElement resolved;
                UExpression arg = InvokeCallVisitor.methodParameterAt(expression, 1);
                String value = ConstantEvaluator.evaluateString((JavaContext)this.mContext, (UElement)arg, (boolean)false);
                if (HardwareIdDetector.RO_SERIALNO.equals(value)) {
                    this.mContext.report(ISSUE, (UElement)arg, this.mContext.getLocation((UElement)arg), String.format(HardwareIdDetector.MESSAGE_DEVICE_IDENTIFIERS, HardwareIdDetector.RO_SERIALNO));
                } else if (arg instanceof UReferenceExpression && (resolved = ((UReferenceExpression)arg).resolve()) instanceof PsiParameter) {
                    this.mPsiParameter = (PsiParameter)resolved;
                }
                this.mProcessingDone = true;
            }
            return super.visitCallExpression(expression);
        }

        PsiParameter getPsiParameter() {
            return this.mPsiParameter;
        }

        private static UExpression methodParameterAt(UCallExpression expression, int index) {
            List expressions = expression.getValueArguments();
            assert (expressions.size() > index);
            return (UExpression)expressions.get(index);
        }

        private static boolean isDesiredMethodCall(UCallExpression expression, String variableQualifier, String containingClass, String desiredMethodName, int paramIndex) {
            if (!desiredMethodName.equals(Lint.getMethodName((UCallExpression)expression))) {
                return false;
            }
            UExpression qualifierExpression = expression.getReceiver();
            if (qualifierExpression == null || !variableQualifier.equals(qualifierExpression.asSourceString())) {
                return false;
            }
            PsiMethod method = expression.resolve();
            return method != null && method.getContainingClass() != null && containingClass.equals(method.getContainingClass().getQualifiedName()) && expression.getValueArgumentCount() > paramIndex;
        }
    }
}

