/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.model.fragments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import trebuchet.model.SchedSlice;
import trebuchet.model.SchedulingState;
import trebuchet.model.base.SliceGroup;
import trebuchet.model.fragments.SchedulingSliceFragment;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001d\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\bJ\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0010H\u0086\bJ\u0006\u0010\u0013\u001a\u00020\u0014R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0017"}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder;", "", "()V", "openSlices", "", "Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "getOpenSlices", "()Ljava/util/List;", "slices", "getSlices", "autoCloseOpenSlices", "", "maxTimestamp", "", "beginSlice", "action", "Lkotlin/Function1;", "endSlice", "Ltrebuchet/model/base/SliceGroup;", "hasOpenSlices", "", "Companion", "MutableSliceGroup", "intellij.android.profilers.atrace"})
public final class SliceGroupBuilder {
    @NotNull
    private final List<MutableSliceGroup> slices;
    @NotNull
    private final List<MutableSliceGroup> openSlices;
    @NotNull
    private static final List<MutableSliceGroup> EmptyChildren;
    @NotNull
    private static final List<SchedulingSliceFragment> EmptySchedules;
    public static final Companion Companion;

    @NotNull
    public final List<MutableSliceGroup> getSlices() {
        return this.slices;
    }

    @NotNull
    public final List<MutableSliceGroup> getOpenSlices() {
        return this.openSlices;
    }

    public final boolean hasOpenSlices() {
        Collection collection = this.openSlices;
        return !collection.isEmpty();
    }

    public final void beginSlice(@NotNull Function1<? super MutableSliceGroup, Unit> action) {
        int $i$f$beginSlice = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        MutableSliceGroup builder = new MutableSliceGroup(0.0, 0.0, false, 0.0, null, null, null, 127, null);
        action.invoke((Object)builder);
        this.getOpenSlices().add(builder);
    }

    @Nullable
    public final SliceGroup endSlice(@NotNull Function1<? super MutableSliceGroup, Unit> action) {
        int $i$f$endSlice = 0;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if (!this.hasOpenSlices()) {
            return null;
        }
        MutableSliceGroup builder = this.getOpenSlices().remove(CollectionsKt.getLastIndex(this.getOpenSlices()));
        action.invoke((Object)builder);
        builder.validate();
        Collection collection = this.getOpenSlices();
        if (!collection.isEmpty()) {
            ((MutableSliceGroup)CollectionsKt.last(this.getOpenSlices())).add(builder);
        } else {
            this.getSlices().add(builder);
        }
        return builder;
    }

    public final void autoCloseOpenSlices(double maxTimestamp) {
        while (this.hasOpenSlices()) {
            MutableSliceGroup builder$iv;
            SliceGroupBuilder this_$iv = this;
            boolean $i$f$endSlice = false;
            if (!this_$iv.hasOpenSlices()) continue;
            MutableSliceGroup it = builder$iv = this_$iv.getOpenSlices().remove(CollectionsKt.getLastIndex(this_$iv.getOpenSlices()));
            boolean bl = false;
            it.setEndTime(maxTimestamp);
            it.setDidNotFinish(true);
            builder$iv.validate();
            Collection collection = this_$iv.getOpenSlices();
            if (!collection.isEmpty()) {
                ((MutableSliceGroup)CollectionsKt.last(this_$iv.getOpenSlices())).add(builder$iv);
            } else {
                this_$iv.getSlices().add(builder$iv);
            }
        }
    }

    public SliceGroupBuilder() {
        List list;
        SliceGroupBuilder sliceGroupBuilder = this;
        sliceGroupBuilder.slices = list = (List)new ArrayList();
        sliceGroupBuilder = this;
        sliceGroupBuilder.openSlices = list = (List)new ArrayList();
    }

    static {
        Companion = new Companion(null);
        EmptyChildren = new ArrayList();
        EmptySchedules = new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B]\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0000J\u0014\u0010+\u001a\u00020)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\r0\u0010J\u0006\u0010-\u001a\u00020)R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010\u0016\u00a8\u0006."}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "Ltrebuchet/model/base/SliceGroup;", "startTime", "", "endTime", "didNotFinish", "", "cpuTime", "_name", "", "_children", "", "_scheduledSlices", "Ltrebuchet/model/fragments/SchedulingSliceFragment;", "(DDZDLjava/lang/String;Ljava/util/List;Ljava/util/List;)V", "children", "", "getChildren", "()Ljava/util/List;", "getCpuTime", "()D", "setCpuTime", "(D)V", "getDidNotFinish", "()Z", "setDidNotFinish", "(Z)V", "getEndTime", "setEndTime", "value", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "scheduledSlices", "Ltrebuchet/model/SchedSlice;", "getScheduledSlices", "getStartTime", "setStartTime", "add", "", "child", "populateScheduledSlices", "slices", "validate", "intellij.android.profilers.atrace"})
    public static final class MutableSliceGroup
    implements SliceGroup {
        private double startTime;
        private double endTime;
        private boolean didNotFinish;
        private double cpuTime;
        private String _name;
        private List<MutableSliceGroup> _children;
        private List<SchedulingSliceFragment> _scheduledSlices;

        @Override
        @NotNull
        public String getName() {
            String string = this._name;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        public void setName(@NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this._name = value;
        }

        @Override
        @NotNull
        public List<SchedSlice> getScheduledSlices() {
            List<SchedSlice> list = this._scheduledSlices;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            return list;
        }

        @Override
        @NotNull
        public List<SliceGroup> getChildren() {
            List<SliceGroup> list = this._children;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            return list;
        }

        public final void validate() {
            double d = this.getStartTime();
            double d2 = d;
            if (!(!Double.isInfinite(d2) && !Double.isNaN(d2 = d)) || this.getStartTime() < 0.0) {
                throw (Throwable)new IllegalStateException("Invalid startTime " + this.getStartTime());
            }
            d = this.getEndTime();
            d2 = d;
            if (!(!Double.isInfinite(d2) && !Double.isNaN(d2 = d)) || this.getEndTime() < 0.0) {
                throw (Throwable)new IllegalStateException("Invalid endTime " + this.getEndTime());
            }
            if (this.getEndTime() < this.getStartTime()) {
                throw (Throwable)new IllegalStateException("endTime " + this.getEndTime() + " cannot be before startTime " + this.getStartTime());
            }
            if (this._name == null) {
                throw (Throwable)new IllegalStateException("name cannot be null");
            }
            if (this._children == null) {
                this._children = Companion.getEmptyChildren();
            }
            if (this._scheduledSlices == null) {
                this._scheduledSlices = Companion.getEmptySchedules();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void populateScheduledSlices(@NotNull List<SchedulingSliceFragment> slices) {
            void i;
            Intrinsics.checkParameterIsNotNull(slices, (String)"slices");
            int n = slices.size() - 1;
            boolean bl = false;
            while (n >= 0 && !(slices.get((int)i).getEndTime() < this.getStartTime())) {
                if (slices.get((int)i).getState() == SchedulingState.RUNNING && slices.get((int)i).getStartTime() < this.getEndTime()) {
                    MutableSliceGroup mutableSliceGroup = this;
                    double d = slices.get((int)i).getEndTime();
                    double d2 = this.getEndTime();
                    double d3 = mutableSliceGroup.getCpuTime();
                    MutableSliceGroup mutableSliceGroup2 = mutableSliceGroup;
                    double d4 = Math.min(d, d2);
                    d = slices.get((int)i).getStartTime();
                    d2 = this.getStartTime();
                    double d5 = Math.max(d, d2);
                    mutableSliceGroup2.setCpuTime(d3 + (d4 - d5));
                    if (this._scheduledSlices == null) {
                        List list;
                        mutableSliceGroup2 = this;
                        mutableSliceGroup2._scheduledSlices = list = (List)new ArrayList();
                    }
                    List<SchedulingSliceFragment> list = this._scheduledSlices;
                    if (list == null) {
                        Intrinsics.throwNpe();
                    }
                    list.add(slices.get((int)i));
                }
                --i;
            }
        }

        public final void add(@NotNull MutableSliceGroup child) {
            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
            if (this._children == null) {
                List list;
                MutableSliceGroup mutableSliceGroup = this;
                mutableSliceGroup._children = list = (List)new ArrayList();
            }
            List<MutableSliceGroup> list = this._children;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(child);
        }

        @Override
        public double getStartTime() {
            return this.startTime;
        }

        public void setStartTime(double d) {
            this.startTime = d;
        }

        @Override
        public double getEndTime() {
            return this.endTime;
        }

        public void setEndTime(double d) {
            this.endTime = d;
        }

        @Override
        public boolean getDidNotFinish() {
            return this.didNotFinish;
        }

        public void setDidNotFinish(boolean bl) {
            this.didNotFinish = bl;
        }

        @Override
        public double getCpuTime() {
            return this.cpuTime;
        }

        public void setCpuTime(double d) {
            this.cpuTime = d;
        }

        public MutableSliceGroup(double startTime, double endTime, boolean didNotFinish, double cpuTime, @Nullable String _name, @Nullable List<MutableSliceGroup> _children, @Nullable List<SchedulingSliceFragment> _scheduledSlices) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.didNotFinish = didNotFinish;
            this.cpuTime = cpuTime;
            this._name = _name;
            this._children = _children;
            this._scheduledSlices = _scheduledSlices;
        }

        public /* synthetic */ MutableSliceGroup(double d, double d2, boolean bl, double d3, String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = DoubleCompanionObject.INSTANCE.getNaN();
            }
            if ((n & 2) != 0) {
                d2 = DoubleCompanionObject.INSTANCE.getNaN();
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                d3 = 0.0;
            }
            if ((n & 0x10) != 0) {
                string = null;
            }
            if ((n & 0x20) != 0) {
                list = null;
            }
            if ((n & 0x40) != 0) {
                list2 = null;
            }
            this(d, d2, bl, d3, string, list, list2);
        }

        public MutableSliceGroup() {
            this(0.0, 0.0, false, 0.0, null, null, null, 127, null);
        }

        @Override
        public double getDuration() {
            return SliceGroup.DefaultImpls.getDuration(this);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ltrebuchet/model/fragments/SliceGroupBuilder$Companion;", "", "()V", "EmptyChildren", "", "Ltrebuchet/model/fragments/SliceGroupBuilder$MutableSliceGroup;", "getEmptyChildren", "()Ljava/util/List;", "EmptySchedules", "Ltrebuchet/model/fragments/SchedulingSliceFragment;", "getEmptySchedules", "intellij.android.profilers.atrace"})
    public static final class Companion {
        @NotNull
        public final List<MutableSliceGroup> getEmptyChildren() {
            return EmptyChildren;
        }

        @NotNull
        public final List<SchedulingSliceFragment> getEmptySchedules() {
            return EmptySchedules;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

