/*
 * Decompiled with CFR 0.152.
 */
package trebuchet.importers.ftrace;

import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import trebuchet.importers.ftrace.FtraceImporterState;
import trebuchet.importers.ftrace.FunctionHandlerRegistry;
import trebuchet.importers.ftrace.ImportData;
import trebuchet.importers.ftrace.SchedParser;
import trebuchet.model.SchedulingState;
import trebuchet.model.fragments.CpuModelFragment;
import trebuchet.model.fragments.ThreadModelFragment;
import trebuchet.util.BufferReader;
import trebuchet.util.MatchResult;
import trebuchet.util.PreviewReader;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltrebuchet/importers/ftrace/SchedParser;", "Ltrebuchet/importers/ftrace/FunctionHandlerRegistry;", "()V", "schedSwitchMatcher", "Ljava/util/regex/Matcher;", "schedWakeupMatcher", "sched_blocked_reason", "", "data", "Ltrebuchet/importers/ftrace/ImportData;", "sched_cpu_hotplug", "sched_switch", "sched_wakeup", "readSchedulingState", "Ltrebuchet/model/SchedulingState;", "Ltrebuchet/util/PreviewReader;", "intellij.android.profilers.atrace"})
public final class SchedParser
extends FunctionHandlerRegistry {
    private static final Matcher schedSwitchMatcher;
    private static final Matcher schedWakeupMatcher;
    public static final SchedParser INSTANCE;

    private final void sched_switch(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $receiver = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
        $receiver.match(schedSwitchMatcher, (Function1<? super MatchResult, Unit>)((Function1)new Function1<MatchResult, Unit>(data){
            final /* synthetic */ ImportData $data$inlined;
            {
                this.$data$inlined = importData;
                super(1);
            }

            public final void invoke(@NotNull MatchResult $receiver) {
                ThreadModelFragment nextThread;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                int prevPid = $receiver.int(2);
                int prevPrio = $receiver.int(3);
                SchedulingState prevState2 = (SchedulingState)((Object)$receiver.read(4, sched_switch.1.prevState.1.INSTANCE));
                int nextPid = $receiver.int(6);
                int nextPrio = $receiver.int(7);
                ThreadModelFragment prevThread = FtraceImporterState.threadFor$default(this.$data$inlined.getImporter(), prevPid, 0, null, 6, null);
                if (prevThread.getName() == null) {
                    ThreadModelFragment.hint$default(prevThread, 0, $receiver.string(1), 0, null, 13, null);
                }
                if ((nextThread = FtraceImporterState.threadFor$default(this.$data$inlined.getImporter(), nextPid, 0, null, 6, null)).getName() == null) {
                    ThreadModelFragment.hint$default(nextThread, 0, $receiver.string(5), 0, null, 13, null);
                }
                CpuModelFragment cpu = this.$data$inlined.getImporter().cpuFor(this.$data$inlined.getLine().getCpu());
                prevThread.getSchedulingStateBuilder().switchState(prevState2, this.$data$inlined.getLine().getTimestamp());
                nextThread.getSchedulingStateBuilder().switchState(SchedulingState.RUNNING, this.$data$inlined.getLine().getTimestamp());
                cpu.getSchedulingProcessBuilder().switchProcess(nextThread.getProcess(), nextThread, this.$data$inlined.getLine().getTimestamp());
            }
        }));
    }

    private final void sched_wakeup(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $receiver = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
        $receiver.match(schedWakeupMatcher, (Function1<? super MatchResult, Unit>)((Function1)new Function1<MatchResult, Unit>(data){
            final /* synthetic */ ImportData $data$inlined;
            {
                this.$data$inlined = importData;
                super(1);
            }

            public final void invoke(@NotNull MatchResult $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                int pid = $receiver.int(2);
                ThreadModelFragment thread2 = FtraceImporterState.threadFor$default(this.$data$inlined.getImporter(), pid, 0, null, 6, null);
                if (thread2.getName() == null) {
                    ThreadModelFragment.hint$default(thread2, 0, $receiver.string(1), 0, null, 13, null);
                }
                thread2.getSchedulingStateBuilder().switchState(SchedulingState.WAKING, this.$data$inlined.getLine().getTimestamp());
            }
        }));
    }

    private final void sched_blocked_reason(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $receiver = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
    }

    private final void sched_cpu_hotplug(ImportData data) {
        ImportData this_$iv = data;
        boolean $i$f$readDetails = false;
        BufferReader $receiver = this_$iv.getLine().getFunctionDetailsReader();
        boolean bl = false;
    }

    private final SchedulingState readSchedulingState(@NotNull PreviewReader $receiver) {
        SchedulingState schedulingState;
        PreviewReader this_$iv = $receiver;
        boolean $i$f$readByte = false;
        byte[] byArray = this_$iv.getBuffer();
        PreviewReader previewReader = this_$iv;
        int n = previewReader.getIndex();
        previewReader.setIndex(n + 1);
        byte by = byArray[n];
        switch (by) {
            case 83: {
                schedulingState = SchedulingState.SLEEPING;
                break;
            }
            case 82: {
                schedulingState = SchedulingState.RUNNABLE;
                break;
            }
            case 68: {
                this_$iv = $receiver;
                boolean $i$f$peek = false;
                if (this_$iv.getBuffer()[this_$iv.getIndex()] == (byte)124) {
                    SchedulingState schedulingState2;
                    this_$iv = $receiver;
                    boolean $i$f$skip = false;
                    PreviewReader previewReader2 = this_$iv;
                    n = previewReader2.getIndex();
                    previewReader2.setIndex(n + 1);
                    this_$iv = $receiver;
                    $i$f$readByte = false;
                    byte[] byArray2 = this_$iv.getBuffer();
                    PreviewReader previewReader3 = this_$iv;
                    n = previewReader3.getIndex();
                    previewReader3.setIndex(n + 1);
                    switch (byArray2[n]) {
                        case 75: {
                            schedulingState2 = SchedulingState.UNINTR_SLEEP_WAKE_KILL;
                            break;
                        }
                        case 87: {
                            schedulingState2 = SchedulingState.UNINTR_SLEEP_WAKING;
                            break;
                        }
                        default: {
                            schedulingState2 = SchedulingState.UNINTR_SLEEP;
                        }
                    }
                    return schedulingState2;
                }
                schedulingState = SchedulingState.UNINTR_SLEEP;
                break;
            }
            case 84: {
                schedulingState = SchedulingState.STOPPED;
                break;
            }
            case 116: {
                schedulingState = SchedulingState.DEBUG;
                break;
            }
            case 90: {
                schedulingState = SchedulingState.ZOMBIE;
                break;
            }
            case 88: {
                schedulingState = SchedulingState.EXIT_DEAD;
                break;
            }
            case 120: {
                schedulingState = SchedulingState.TASK_DEAD;
                break;
            }
            case 75: {
                schedulingState = SchedulingState.WAKE_KILL;
                break;
            }
            case 87: {
                schedulingState = SchedulingState.WAKING;
                break;
            }
            default: {
                schedulingState = SchedulingState.UNKNOWN;
            }
        }
        return schedulingState;
    }

    private SchedParser() {
        super(null, 1, null);
    }

    static {
        SchedParser schedParser;
        INSTANCE = schedParser = new SchedParser();
        schedParser.handleWith("sched_switch", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>(schedParser){

            public final void invoke(@NotNull ImportData p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((SchedParser)this.receiver).sched_switch(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchedParser.class);
            }

            public final String getName() {
                return "sched_switch";
            }

            public final String getSignature() {
                return "sched_switch(Ltrebuchet/importers/ftrace/ImportData;)V";
            }
        }));
        schedParser.handleWith("sched_waking", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>(schedParser){

            public final void invoke(@NotNull ImportData p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((SchedParser)this.receiver).sched_wakeup(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchedParser.class);
            }

            public final String getName() {
                return "sched_wakeup";
            }

            public final String getSignature() {
                return "sched_wakeup(Ltrebuchet/importers/ftrace/ImportData;)V";
            }
        }));
        schedParser.handleWith("sched_wakeup", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>(schedParser){

            public final void invoke(@NotNull ImportData p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((SchedParser)this.receiver).sched_wakeup(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchedParser.class);
            }

            public final String getName() {
                return "sched_wakeup";
            }

            public final String getSignature() {
                return "sched_wakeup(Ltrebuchet/importers/ftrace/ImportData;)V";
            }
        }));
        schedParser.handleWith("sched_blocked_reason", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>(schedParser){

            public final void invoke(@NotNull ImportData p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((SchedParser)this.receiver).sched_blocked_reason(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchedParser.class);
            }

            public final String getName() {
                return "sched_blocked_reason";
            }

            public final String getSignature() {
                return "sched_blocked_reason(Ltrebuchet/importers/ftrace/ImportData;)V";
            }
        }));
        schedParser.handleWith("sched_cpu_hotplug", (Function1<? super ImportData, Unit>)((Function1)new Function1<ImportData, Unit>(schedParser){

            public final void invoke(@NotNull ImportData p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                ((SchedParser)this.receiver).sched_cpu_hotplug(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SchedParser.class);
            }

            public final String getName() {
                return "sched_cpu_hotplug";
            }

            public final String getSignature() {
                return "sched_cpu_hotplug(Ltrebuchet/importers/ftrace/ImportData;)V";
            }
        }));
        schedSwitchMatcher = schedParser.matcher("prev_comm=(.*) prev_pid=(\\d+) prev_prio=(\\d+) prev_state=([^\\s]+) ==> next_comm=(.*) next_pid=(\\d+) next_prio=(\\d+)");
        schedWakeupMatcher = schedParser.matcher("comm=(.+) pid=(\\d+) prio=(\\d+)(?: success=\\d+)? target_cpu=(\\d+)");
    }

    public static final /* synthetic */ SchedulingState access$readSchedulingState(SchedParser $this, PreviewReader $receiver) {
        return $this.readSchedulingState($receiver);
    }
}

