/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.network;

import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.NetworkTrafficFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.network.NetworkMonitorTooltip;
import com.android.tools.profilers.network.NetworkProfilerStage;
import com.android.tools.profilers.network.NetworkTrafficDataSeries;
import com.android.tools.profilers.network.NetworkUsage;
import org.jetbrains.annotations.NotNull;

public class NetworkMonitor
extends ProfilerMonitor {
    private static final BaseAxisFormatter BANDWIDTH_AXIS_FORMATTER_L1 = new NetworkTrafficFormatter(1, 2, 5);
    private final NetworkUsage myNetworkUsage;
    private final NetworkLegends myLegends;
    private final ClampedAxisComponentModel myTrafficAxis;
    private final NetworkLegends myTooltipLegends;

    public NetworkMonitor(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            NetworkMonitor.$$$reportNull$$$0(0);
        }
        super(profilers);
        this.myNetworkUsage = new NetworkUsage(profilers);
        this.myTrafficAxis = new ClampedAxisComponentModel.Builder(this.myNetworkUsage.getTrafficRange(), BANDWIDTH_AXIS_FORMATTER_L1).build();
        this.myLegends = new NetworkLegends(this.myNetworkUsage, this.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new NetworkLegends(this.myNetworkUsage, this.getTimeline().getTooltipRange(), true);
    }

    @Override
    @NotNull
    public String getName() {
        if ("NETWORK" == null) {
            NetworkMonitor.$$$reportNull$$$0(1);
        }
        return "NETWORK";
    }

    @Override
    public ProfilerTooltip buildTooltip() {
        return new NetworkMonitorTooltip(this);
    }

    @Override
    public void exit() {
        this.myProfilers.getUpdater().unregister((Updatable)this.myNetworkUsage);
        this.myProfilers.getUpdater().unregister((Updatable)this.myTrafficAxis);
    }

    @Override
    public void enter() {
        this.myProfilers.getUpdater().register((Updatable)this.myNetworkUsage);
        this.myProfilers.getUpdater().register((Updatable)this.myTrafficAxis);
    }

    @Override
    public void expand() {
        this.myProfilers.setStage(new NetworkProfilerStage(this.myProfilers));
    }

    public AxisComponentModel getTrafficAxis() {
        return this.myTrafficAxis;
    }

    public NetworkUsage getNetworkUsage() {
        return this.myNetworkUsage;
    }

    public NetworkLegends getLegends() {
        return this.myLegends;
    }

    public NetworkLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/network/NetworkMonitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/network/NetworkMonitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NetworkLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myRxLegend;
        @NotNull
        private final SeriesLegend myTxLegend;

        public NetworkLegends(@NotNull NetworkUsage usage, @NotNull Range range, boolean hightlight) {
            if (usage == null) {
                NetworkLegends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                NetworkLegends.$$$reportNull$$$0(1);
            }
            super(range);
            this.myTxLegend = new SeriesLegend(usage.getTxSeries(), BANDWIDTH_AXIS_FORMATTER_L1, range, NetworkTrafficDataSeries.Type.BYTES_SENT.getLabel(hightlight), Interpolatable.SegmentInterpolator);
            this.myRxLegend = new SeriesLegend(usage.getRxSeries(), BANDWIDTH_AXIS_FORMATTER_L1, range, NetworkTrafficDataSeries.Type.BYTES_RECEIVED.getLabel(hightlight), Interpolatable.SegmentInterpolator);
            this.add((Legend)this.myTxLegend);
            this.add((Legend)this.myRxLegend);
        }

        @NotNull
        public SeriesLegend getRxLegend() {
            SeriesLegend seriesLegend = this.myRxLegend;
            if (seriesLegend == null) {
                NetworkLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getTxLegend() {
            SeriesLegend seriesLegend = this.myTxLegend;
            if (seriesLegend == null) {
                NetworkLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/network/NetworkMonitor$NetworkLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/network/NetworkMonitor$NetworkLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRxLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTxLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

