/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SelectionListener;
import com.android.tools.adtui.model.SelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.filter.Filter;
import com.android.tools.adtui.model.filter.FilterHandler;
import com.android.tools.adtui.model.filter.FilterResult;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.model.legend.EventLegend;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profilers.ProfilerMode;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.analytics.FeatureTracker;
import com.android.tools.profilers.analytics.FilterMetadata;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.memory.AllocationInfosDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDataSeries;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import com.android.tools.profilers.memory.CaptureDurationData;
import com.android.tools.profilers.memory.CaptureObjectLoader;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.GcStatsDataSeries;
import com.android.tools.profilers.memory.HeapDumpSampleDataSeries;
import com.android.tools.profilers.memory.MemoryProfiler;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerConfiguration;
import com.android.tools.profilers.memory.MemoryProfilerSelection;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.ClassSet;
import com.android.tools.profilers.memory.adapters.FieldObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.CodeNavigator;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.hash.HashMap;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfilerStage
extends Stage
implements CodeNavigator.Listener {
    private static final String HAS_USED_MEMORY_CAPTURE = "memory.used.capture";
    public static final String LIVE_ALLOCATION_SAMPLING_PREF = "memory.live.allocation.mode";
    public static final LiveAllocationSamplingMode DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE = LiveAllocationSamplingMode.SAMPLED;
    static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = new MemoryAxisFormatter(1, 5, 5);
    static final BaseAxisFormatter OBJECT_COUNT_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 5, 5, "");
    private static final long INVALID_START_TIME = -1L;
    private final DetailedMemoryUsage myDetailedMemoryUsage;
    private final ClampedAxisComponentModel myMemoryAxis;
    private final ClampedAxisComponentModel myObjectsAxis;
    private final MemoryStageLegends myLegends;
    private final MemoryStageLegends myTooltipLegends;
    private final EaseOutModel myInstructionsEaseOutModel;
    private final boolean myIsMemoryCaptureOnly;
    @NotNull
    private final Common.Session mySessionData;
    private DurationDataModel<GcDurationData> myGcStatsModel;
    @NotNull
    private AspectModel<MemoryProfilerAspect> myAspect;
    @NotNull
    private FilterHandler myFilterHandler;
    @Nullable
    private Filter myLastFilter;
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myHeapDumpDurations;
    private final DurationDataModel<CaptureDurationData<CaptureObject>> myAllocationDurations;
    private final CaptureObjectLoader myLoader;
    private final MemoryProfilerSelection mySelection;
    private final MemoryProfilerConfiguration myConfiguration;
    private final EventMonitor myEventMonitor;
    private final SelectionModel mySelectionModel;
    private final StackTraceModel myAllocationStackTraceModel;
    private final StackTraceModel myDeallocationStackTraceModel;
    private boolean myTrackingAllocations;
    private boolean myUpdateCaptureOnSelection;
    private final CaptureElapsedTimeUpdatable myCaptureElapsedTimeUpdatable;
    private long myPendingCaptureStartTime;
    private long myPendingLegacyAllocationStartTimeNs;
    @NotNull
    private final AllocationSamplingRateDataSeries myAllocationSamplingRateDataSeries;
    @NotNull
    private final DurationDataModel<AllocationSamplingRateDurationData> myAllocationSamplingRateDurations;
    @NotNull
    private final AllocationSamplingRateUpdatable myAllocationSamplingRateUpdatable;
    @NotNull
    private LiveAllocationSamplingMode myLiveAllocationSamplingMode;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryProfilerStage.class);
    }

    public MemoryProfilerStage(@NotNull StudioProfilers profilers) {
        if (profilers == null) {
            MemoryProfilerStage.$$$reportNull$$$0(0);
        }
        this(profilers, new CaptureObjectLoader());
    }

    @VisibleForTesting
    public MemoryProfilerStage(final @NotNull StudioProfilers profilers, @NotNull CaptureObjectLoader loader) {
        if (profilers == null) {
            MemoryProfilerStage.$$$reportNull$$$0(1);
        }
        if (loader == null) {
            MemoryProfilerStage.$$$reportNull$$$0(2);
        }
        super(profilers);
        this.myAspect = new AspectModel();
        this.myUpdateCaptureOnSelection = true;
        this.myCaptureElapsedTimeUpdatable = new CaptureElapsedTimeUpdatable();
        this.myPendingCaptureStartTime = -1L;
        this.myPendingLegacyAllocationStartTimeNs = -1L;
        this.myIsMemoryCaptureOnly = profilers.getSessionsManager().getSelectedSessionMetaData().getType() == Common.SessionMetaData.SessionType.MEMORY_CAPTURE;
        this.mySessionData = profilers.getSession();
        this.myClient = profilers.getClient().getMemoryClient();
        HeapDumpSampleDataSeries heapDumpSeries = new HeapDumpSampleDataSeries(profilers.getClient().getMemoryClient(), this.mySessionData, this.getStudioProfilers().getIdeServices().getFeatureTracker(), this);
        AllocationInfosDataSeries allocationSeries = new AllocationInfosDataSeries(profilers.getClient().getMemoryClient(), this.mySessionData, this.getStudioProfilers().getIdeServices().getFeatureTracker(), this);
        this.myLoader = loader;
        Range viewRange = profilers.getTimeline().getViewRange();
        this.myHeapDumpDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)heapDumpSeries));
        this.myAllocationDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)allocationSeries));
        this.mySelection = new MemoryProfilerSelection(this);
        this.myConfiguration = new MemoryProfilerConfiguration(this);
        this.myGcStatsModel = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)new GcStatsDataSeries(this.myClient, this.mySessionData)));
        this.myAllocationSamplingRateDataSeries = new AllocationSamplingRateDataSeries(this.myClient, this.mySessionData);
        this.myAllocationSamplingRateDurations = new DurationDataModel(new RangedSeries(viewRange, (DataSeries)this.myAllocationSamplingRateDataSeries));
        this.myDetailedMemoryUsage = new DetailedMemoryUsage(profilers, this);
        this.myHeapDumpDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.myDetailedMemoryUsage.getObjectsSeries().getName()));
        this.myGcStatsModel.setAttachedSeries(this.myDetailedMemoryUsage.getObjectsSeries(), Interpolatable.SegmentInterpolator);
        this.myGcStatsModel.setAttachPredicate(data -> !this.useLiveAllocationTracking() || MemoryProfiler.hasOnlyFullAllocationTrackingWithinRegion(this.myClient, this.mySessionData, data.x, data.x));
        this.myAllocationSamplingRateDurations.setAttachedSeries(this.myDetailedMemoryUsage.getObjectsSeries(), Interpolatable.SegmentInterpolator);
        this.myAllocationSamplingRateDurations.setAttachPredicate(data -> ((AllocationSamplingRateDurationData)data.value).getPreviousRateEvent() != null && ((AllocationSamplingRateDurationData)data.value).getPreviousRateEvent().getSamplingRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue() || ((AllocationSamplingRateDurationData)data.value).getCurrentRateEvent().getSamplingRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue());
        this.myAllocationSamplingRateDurations.setRenderSeriesPredicate((data, series) -> !series.getName().equals(this.myDetailedMemoryUsage.getObjectsSeries().getName()) || !this.useLiveAllocationTracking() || ((AllocationSamplingRateDurationData)data.value).getCurrentRateEvent().getSamplingRate().getSamplingNumInterval() == LiveAllocationSamplingMode.FULL.getValue());
        this.myAllocationSamplingRateUpdatable = new AllocationSamplingRateUpdatable();
        this.myMemoryAxis = new ClampedAxisComponentModel.Builder(this.myDetailedMemoryUsage.getMemoryRange(), MEMORY_AXIS_FORMATTER).build();
        this.myObjectsAxis = new ClampedAxisComponentModel.Builder(this.myDetailedMemoryUsage.getObjectsRange(), OBJECT_COUNT_AXIS_FORMATTER).build();
        this.myLegends = new MemoryStageLegends(this, profilers.getTimeline().getDataRange(), false);
        this.myTooltipLegends = new MemoryStageLegends(this, profilers.getTimeline().getTooltipRange(), true);
        this.myInstructionsEaseOutModel = new EaseOutModel(profilers.getUpdater(), PROFILING_INSTRUCTIONS_EASE_OUT_NS);
        this.myEventMonitor = new EventMonitor(profilers);
        this.mySelectionModel = new SelectionModel(profilers.getTimeline().getSelectionRange());
        this.mySelectionModel.addConstraint(this.myAllocationDurations);
        this.mySelectionModel.addConstraint(this.myHeapDumpDurations);
        this.mySelectionModel.addListener(new SelectionListener(){

            public void selectionCreated() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
                profilers.getIdeServices().getFeatureTracker().trackSelectRange();
                profilers.getIdeServices().getTemporaryProfilerPreferences().setBoolean(MemoryProfilerStage.HAS_USED_MEMORY_CAPTURE, true);
                MemoryProfilerStage.this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
            }

            public void selectionCleared() {
                MemoryProfilerStage.this.selectCaptureFromSelectionRange();
            }
        });
        this.myFilterHandler = new FilterHandler(){

            @NotNull
            protected FilterResult applyFilter(@NotNull Filter filter) {
                if (filter == null) {
                    2.$$$reportNull$$$0(0);
                }
                MemoryProfilerStage.this.selectCaptureFilter(filter);
                HeapSet heapSet = MemoryProfilerStage.this.getSelectedHeapSet();
                FilterResult filterResult = heapSet == null ? new FilterResult(0, false) : new FilterResult(heapSet.getFilterMatchCount(), true);
                if (filterResult == null) {
                    2.$$$reportNull$$$0(1);
                }
                return filterResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filter";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStage$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStage$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "applyFilter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFilter";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.myAllocationStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
        this.myDeallocationStackTraceModel = new StackTraceModel(profilers.getIdeServices().getCodeNavigator());
        this.myLiveAllocationSamplingMode = LiveAllocationSamplingMode.getModeFromFrequency(profilers.getIdeServices().getPersistentProfilerPreferences().getInt(LIVE_ALLOCATION_SAMPLING_PREF, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue()));
        this.myAllocationSamplingRateUpdatable.update(0L);
    }

    public boolean hasUserUsedMemoryCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_MEMORY_CAPTURE, false);
    }

    public DetailedMemoryUsage getDetailedMemoryUsage() {
        return this.myDetailedMemoryUsage;
    }

    @Override
    public void enter() {
        this.myLoader.start();
        this.myEventMonitor.enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.myDetailedMemoryUsage);
        this.getStudioProfilers().getUpdater().register(this.myHeapDumpDurations);
        this.getStudioProfilers().getUpdater().register(this.myAllocationDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myMemoryAxis);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myObjectsAxis);
        this.getStudioProfilers().getUpdater().register(this.myGcStatsModel);
        this.getStudioProfilers().getUpdater().register(this.myAllocationSamplingRateDurations);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getUpdater().register((Updatable)this.myAllocationSamplingRateUpdatable);
        this.getStudioProfilers().getIdeServices().getCodeNavigator().addListener(this);
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getClass());
        MemoryProfiler.MemoryData data = this.myClient.getData(MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySessionData).setStartTime(Long.MIN_VALUE).setEndTime(Long.MAX_VALUE).build());
        List allocationsInfos = data.getAllocationsInfoList();
        MemoryProfiler.AllocationsInfo lastInfo = allocationsInfos.isEmpty() ? null : (MemoryProfiler.AllocationsInfo)allocationsInfos.get(allocationsInfos.size() - 1);
        boolean bl = this.myTrackingAllocations = lastInfo != null && lastInfo.getLegacy() && lastInfo.getEndTime() == Long.MAX_VALUE;
        if (this.myTrackingAllocations) {
            this.myPendingCaptureStartTime = lastInfo.getStartTime();
            this.myPendingLegacyAllocationStartTimeNs = lastInfo.getStartTime();
        } else {
            this.myPendingCaptureStartTime = -1L;
            this.myPendingLegacyAllocationStartTimeNs = -1L;
        }
    }

    @Override
    public void exit() {
        this.enableSelectLatestCapture(false, null);
        this.myEventMonitor.exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myDetailedMemoryUsage);
        this.getStudioProfilers().getUpdater().unregister(this.myHeapDumpDurations);
        this.getStudioProfilers().getUpdater().unregister(this.myAllocationDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myMemoryAxis);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myObjectsAxis);
        this.getStudioProfilers().getUpdater().unregister(this.myGcStatsModel);
        this.getStudioProfilers().getUpdater().unregister(this.myAllocationSamplingRateDurations);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myCaptureElapsedTimeUpdatable);
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myAllocationSamplingRateUpdatable);
        this.selectCaptureDuration(null, null);
        this.myLoader.stop();
        this.getStudioProfilers().getIdeServices().getCodeNavigator().removeListener(this);
        this.mySelectionModel.clearListeners();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(3);
        }
        return selectionModel;
    }

    @NotNull
    public StackTraceModel getAllocationStackTraceModel() {
        StackTraceModel stackTraceModel = this.myAllocationStackTraceModel;
        if (stackTraceModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(4);
        }
        return stackTraceModel;
    }

    @NotNull
    public StackTraceModel getDeallocationStackTraceModel() {
        StackTraceModel stackTraceModel = this.myDeallocationStackTraceModel;
        if (stackTraceModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(5);
        }
        return stackTraceModel;
    }

    private void selectCaptureFromSelectionRange() {
        if (!this.myUpdateCaptureOnSelection) {
            return;
        }
        this.myUpdateCaptureOnSelection = false;
        Range selectionRange = this.getStudioProfilers().getTimeline().getSelectionRange();
        this.selectCaptureDuration(this.getIntersectingCaptureDuration(selectionRange), SwingUtilities::invokeLater);
        this.myUpdateCaptureOnSelection = true;
    }

    public void enableSelectLatestCapture(boolean enable, @Nullable Executor loadJoiner) {
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        if (enable) {
            timeline.getDataRange().addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, () -> this.queryAndSelectCaptureObject(loadJoiner == null ? MoreExecutors.directExecutor() : loadJoiner));
        } else {
            timeline.getDataRange().removeDependencies((AspectObserver)this);
        }
    }

    public boolean isMemoryCaptureOnly() {
        return this.myIsMemoryCaptureOnly;
    }

    private void queryAndSelectCaptureObject(@NotNull Executor loadJoiner) {
        if (loadJoiner == null) {
            MemoryProfilerStage.$$$reportNull$$$0(6);
        }
        Range dataRange = this.getStudioProfilers().getTimeline().getDataRange();
        if (this.myPendingCaptureStartTime != -1L) {
            ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getDataSeries().getDataForXRange(dataRange));
            series.addAll(this.getHeapDumpSampleDurations().getSeries().getDataSeries().getDataForXRange(dataRange));
            long pendingCaptureStartTimeUs = TimeUnit.NANOSECONDS.toMicros(this.myPendingCaptureStartTime);
            SeriesData captureToSelect = null;
            for (int i = series.size() - 1; i >= 0; --i) {
                if (((SeriesData)series.get((int)i)).x != pendingCaptureStartTimeUs) continue;
                captureToSelect = (SeriesData)series.get(i);
                break;
            }
            if (captureToSelect != null && (((CaptureDurationData)((Object)captureToSelect.value)).getDurationUs() != Long.MAX_VALUE || ((CaptureDurationData)((Object)captureToSelect.value)).getSelectableWhenMaxDuration())) {
                this.selectCaptureDuration((CaptureDurationData)((Object)captureToSelect.value), loadJoiner);
            }
        }
    }

    public void setPendingCaptureStartTime(long pendingCaptureStartTime) {
        assert (this.myIsMemoryCaptureOnly);
        this.myPendingCaptureStartTime = pendingCaptureStartTime;
    }

    @NotNull
    public AspectModel<MemoryProfilerAspect> getAspect() {
        AspectModel<MemoryProfilerAspect> aspectModel = this.myAspect;
        if (aspectModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(7);
        }
        return aspectModel;
    }

    public void requestHeapDump() {
        MemoryProfiler.TriggerHeapDumpResponse response = this.myClient.triggerHeapDump(MemoryProfiler.TriggerHeapDumpRequest.newBuilder().setSession(this.mySessionData).build());
        switch (response.getStatus()) {
            case SUCCESS: {
                this.myPendingCaptureStartTime = response.getInfo().getStartTime();
                break;
            }
            case IN_PROGRESS: {
                MemoryProfilerStage.getLogger().debug(String.format("A heap dump for %d is already in progress.", this.mySessionData.getPid()));
                break;
            }
        }
        this.getStudioProfilers().getTimeline().setStreaming(true);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_MEMORY_CAPTURE, true);
        this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
    }

    public void forceGarbageCollection() {
        this.myClient.forceGarbageCollection(MemoryProfiler.ForceGarbageCollectionRequest.newBuilder().setSession(this.mySessionData).build());
    }

    public DurationDataModel<CaptureDurationData<CaptureObject>> getHeapDumpSampleDurations() {
        return this.myHeapDumpDurations;
    }

    public void trackAllocations(boolean enabled) {
        Profiler.TimeResponse timeResponse = this.getStudioProfilers().getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(this.getStudioProfilers().getDevice().getDeviceId()).build());
        long timeNs = timeResponse.getTimestampNs();
        try {
            MemoryProfiler.TrackAllocationsResponse response = this.myClient.trackAllocations(MemoryProfiler.TrackAllocationsRequest.newBuilder().setRequestTime(timeNs).setSession(this.mySessionData).setEnabled(enabled).build());
            MemoryProfiler.AllocationsInfo info = response.getInfo();
            switch (response.getStatus()) {
                case SUCCESS: {
                    this.myTrackingAllocations = enabled;
                    this.myPendingCaptureStartTime = info.getStartTime();
                    this.myPendingLegacyAllocationStartTimeNs = enabled ? info.getStartTime() : -1L;
                    break;
                }
                case IN_PROGRESS: {
                    this.myTrackingAllocations = true;
                    break;
                }
                case NOT_ENABLED: {
                    this.myTrackingAllocations = false;
                    break;
                }
            }
            this.myAspect.changed((Enum)MemoryProfilerAspect.TRACKING_ENABLED);
        }
        catch (StatusRuntimeException e) {
            MemoryProfilerStage.getLogger().debug((Throwable)e);
        }
        if (this.myTrackingAllocations) {
            this.getStudioProfilers().getTimeline().setStreaming(true);
            this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_MEMORY_CAPTURE, true);
            this.myInstructionsEaseOutModel.setCurrentPercentage(1.0f);
        }
    }

    public boolean isTrackingAllocations() {
        return this.myTrackingAllocations;
    }

    public long getAllocationTrackingElapsedTimeNs() {
        if (this.myTrackingAllocations) {
            Profiler.TimeResponse timeResponse = this.getStudioProfilers().getClient().getProfilerClient().getCurrentTime(Profiler.TimeRequest.newBuilder().setDeviceId(this.getStudioProfilers().getDevice().getDeviceId()).build());
            return timeResponse.getTimestampNs() - this.myPendingLegacyAllocationStartTimeNs;
        }
        return -1L;
    }

    @Nullable
    public CaptureDurationData<? extends CaptureObject> getIntersectingCaptureDuration(@NotNull Range range) {
        if (range == null) {
            MemoryProfilerStage.$$$reportNull$$$0(8);
        }
        CaptureDurationData durationData = null;
        double overlap = 0.0;
        ArrayList series = new ArrayList(this.getAllocationInfosDurations().getSeries().getDataSeries().getDataForXRange(range));
        series.addAll(this.getHeapDumpSampleDurations().getSeries().getDataSeries().getDataForXRange(range));
        for (SeriesData data : series) {
            long dataMax;
            Range c;
            Range intersection;
            long duration = ((CaptureDurationData)((Object)data.value)).getDurationUs();
            if (duration == Long.MAX_VALUE && !((CaptureDurationData)((Object)data.value)).getSelectableWhenMaxDuration() || (intersection = (c = new Range((double)data.x, (double)(dataMax = duration == Long.MAX_VALUE ? duration : data.x + duration))).getIntersection(range)).isEmpty() || !(intersection.getLength() >= overlap)) continue;
            durationData = (CaptureDurationData)((Object)data.value);
            overlap = intersection.getLength();
        }
        return durationData;
    }

    public boolean useLiveAllocationTracking() {
        return MemoryProfiler.isUsingLiveAllocation(this.getStudioProfilers(), this.mySessionData);
    }

    @NotNull
    public DurationDataModel<CaptureDurationData<CaptureObject>> getAllocationInfosDurations() {
        DurationDataModel<CaptureDurationData<CaptureObject>> durationDataModel = this.myAllocationDurations;
        if (durationDataModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(9);
        }
        return durationDataModel;
    }

    public void selectFieldObjectPath(@NotNull List<FieldObject> fieldObjectPath) {
        if (fieldObjectPath == null) {
            MemoryProfilerStage.$$$reportNull$$$0(10);
        }
        this.mySelection.selectFieldObjectPath(fieldObjectPath);
    }

    @NotNull
    public List<FieldObject> getSelectedFieldObjectPath() {
        List<FieldObject> list = this.mySelection.getFieldObjectPath();
        if (list == null) {
            MemoryProfilerStage.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void selectInstanceObject(@Nullable InstanceObject instanceObject) {
        this.mySelection.selectInstanceObject(instanceObject);
    }

    @Nullable
    public InstanceObject getSelectedInstanceObject() {
        return this.mySelection.getInstanceObject();
    }

    public void selectClassSet(@Nullable ClassSet classSet) {
        this.mySelection.selectClassSet(classSet);
    }

    @Nullable
    public ClassSet getSelectedClassSet() {
        return this.mySelection.getClassSet();
    }

    public void refreshSelectedHeap() {
        this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_HEAP_CONTENTS);
        this.myFilterHandler.refreshFilterContent();
    }

    public void selectHeapSet(@Nullable HeapSet heapSet) {
        this.mySelection.selectHeapSet(heapSet);
        this.myFilterHandler.refreshFilterContent();
        if (heapSet != null) {
            this.getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectMemoryHeap(heapSet.getName());
        }
    }

    @Nullable
    public HeapSet getSelectedHeapSet() {
        return this.mySelection.getHeapSet();
    }

    private void selectCaptureFilter(@NotNull Filter filter) {
        if (filter == null) {
            MemoryProfilerStage.$$$reportNull$$$0(12);
        }
        if (Objects.equals(this.myLastFilter, filter)) {
            this.myLastFilter = filter;
            this.trackFilterUsage(filter);
        }
        if (this.getSelectedHeapSet() != null) {
            this.getSelectedHeapSet().selectFilter(filter);
        }
        if (this.getSelectedClassSet() != null && this.getSelectedClassSet().getIsFiltered()) {
            this.selectClassSet(ClassSet.EMPTY_SET);
        }
        this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_FILTER);
    }

    private void trackFilterUsage(@NotNull Filter filter) {
        if (filter == null) {
            MemoryProfilerStage.$$$reportNull$$$0(13);
        }
        FilterMetadata filterMetadata = new FilterMetadata();
        FeatureTracker featureTracker = this.getStudioProfilers().getIdeServices().getFeatureTracker();
        switch (this.getConfiguration().getClassGrouping()) {
            case ARRANGE_BY_CLASS: {
                filterMetadata.setView(FilterMetadata.View.MEMORY_CLASS);
                break;
            }
            case ARRANGE_BY_PACKAGE: {
                filterMetadata.setView(FilterMetadata.View.MEMORY_PACKAGE);
                break;
            }
            case ARRANGE_BY_CALLSTACK: {
                filterMetadata.setView(FilterMetadata.View.MEMORY_CALLSTACK);
            }
        }
        filterMetadata.setFeaturesUsed(filter.isMatchCase(), filter.isRegex());
        if (this.getSelectedHeapSet() != null) {
            filterMetadata.setMatchedElementCount(this.getSelectedHeapSet().getFilteredObjectSetCount());
            filterMetadata.setTotalElementCount(this.getSelectedHeapSet().getTotalObjectSetCount());
        }
        filterMetadata.setFilterTextLength(filter.isEmpty() ? 0 : filter.getFilterString().length());
        featureTracker.trackFilterMetadata(filterMetadata);
    }

    @NotNull
    public FilterHandler getFilterHandler() {
        FilterHandler filterHandler = this.myFilterHandler;
        if (filterHandler == null) {
            MemoryProfilerStage.$$$reportNull$$$0(14);
        }
        return filterHandler;
    }

    @VisibleForTesting
    void selectCaptureDuration(@Nullable CaptureDurationData<? extends CaptureObject> durationData, @Nullable Executor joiner) {
        this.myPendingCaptureStartTime = -1L;
        if (!this.mySelection.selectCaptureEntry(durationData == null ? null : durationData.getCaptureEntry())) {
            return;
        }
        this.myUpdateCaptureOnSelection = false;
        ProfilerTimeline timeline = this.getStudioProfilers().getTimeline();
        CaptureObject captureObject = this.mySelection.getCaptureObject();
        if (captureObject == null) {
            this.mySelection.selectCaptureEntry(null);
            timeline.getSelectionRange().clear();
            this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE);
            this.setProfilerMode(ProfilerMode.NORMAL);
            return;
        }
        if (durationData != null && durationData.getDurationUs() != Long.MAX_VALUE) {
            timeline.getSelectionRange().clear();
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getStartTimeNs());
            long endTimeUs = TimeUnit.NANOSECONDS.toMicros(captureObject.getEndTimeNs());
            timeline.getSelectionRange().set((double)startTimeUs, (double)endTimeUs);
        }
        this.myUpdateCaptureOnSelection = true;
        ListenableFuture<CaptureObject> future = this.myLoader.loadCapture(captureObject, timeline.getSelectionRange(), joiner);
        future.addListener(() -> {
            try {
                CaptureObject loadedCaptureObject = (CaptureObject)future.get();
                if (this.mySelection.finishSelectingCaptureObject(loadedCaptureObject)) {
                    Collection<HeapSet> heaps = loadedCaptureObject.getHeapSets();
                    if (heaps.isEmpty()) {
                        return;
                    }
                    for (HeapSet heap : heaps) {
                        if (!heap.getName().equals("app")) continue;
                        this.selectHeapSet(heap);
                        return;
                    }
                    for (HeapSet heap : heaps) {
                        if (!heap.getName().equals("default")) continue;
                        this.selectHeapSet(heap);
                        return;
                    }
                    HeapSet heap = new ArrayList<HeapSet>(heaps).get(0);
                    this.selectHeapSet(heap);
                } else {
                    this.selectCaptureDuration(null, null);
                }
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                this.selectCaptureDuration(null, null);
            }
            catch (ExecutionException exception) {
                this.selectCaptureDuration(null, null);
                MemoryProfilerStage.getLogger().error((Throwable)exception);
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }, joiner == null ? MoreExecutors.directExecutor() : joiner);
        this.setProfilerMode(ProfilerMode.EXPANDED);
    }

    @NotNull
    public AllocationSamplingRateDataSeries getAllocationSamplingRateDataSeries() {
        AllocationSamplingRateDataSeries allocationSamplingRateDataSeries = this.myAllocationSamplingRateDataSeries;
        if (allocationSamplingRateDataSeries == null) {
            MemoryProfilerStage.$$$reportNull$$$0(15);
        }
        return allocationSamplingRateDataSeries;
    }

    @NotNull
    DurationDataModel<AllocationSamplingRateDurationData> getAllocationSamplingRateDurations() {
        DurationDataModel<AllocationSamplingRateDurationData> durationDataModel = this.myAllocationSamplingRateDurations;
        if (durationDataModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(16);
        }
        return durationDataModel;
    }

    @NotNull
    public List<LiveAllocationSamplingMode> getSupportedLiveAllocationSamplingMode() {
        List<LiveAllocationSamplingMode> list = Arrays.asList(LiveAllocationSamplingMode.values());
        if (list == null) {
            MemoryProfilerStage.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    public LiveAllocationSamplingMode getLiveAllocationSamplingMode() {
        LiveAllocationSamplingMode liveAllocationSamplingMode = this.myLiveAllocationSamplingMode;
        if (liveAllocationSamplingMode == null) {
            MemoryProfilerStage.$$$reportNull$$$0(18);
        }
        return liveAllocationSamplingMode;
    }

    public void requestLiveAllocationSamplingModeUpdate(@NotNull LiveAllocationSamplingMode mode) {
        if (mode == null) {
            MemoryProfilerStage.$$$reportNull$$$0(19);
        }
        this.getStudioProfilers().getIdeServices().getPersistentProfilerPreferences().setInt(LIVE_ALLOCATION_SAMPLING_PREF, mode.getValue(), DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE.getValue());
        try {
            this.myClient.setAllocationSamplingRate(MemoryProfiler.SetAllocationSamplingRateRequest.newBuilder().setSession(this.mySessionData).setSamplingRate(MemoryProfiler.AllocationSamplingRate.newBuilder().setSamplingNumInterval(mode.getValue()).build()).build());
        }
        catch (StatusRuntimeException e) {
            MemoryProfilerStage.getLogger().debug((Throwable)e);
        }
    }

    private void setLiveAllocationSamplingModelInternal(@NotNull LiveAllocationSamplingMode mode) {
        if (mode == null) {
            MemoryProfilerStage.$$$reportNull$$$0(20);
        }
        if (mode == this.myLiveAllocationSamplingMode) {
            return;
        }
        this.myLiveAllocationSamplingMode = mode;
        this.myAspect.changed((Enum)MemoryProfilerAspect.LIVE_ALLOCATION_SAMPLING_MODE);
    }

    @Nullable
    public CaptureObject getSelectedCapture() {
        return this.mySelection.getCaptureObject();
    }

    @NotNull
    public MemoryProfilerConfiguration getConfiguration() {
        MemoryProfilerConfiguration memoryProfilerConfiguration = this.myConfiguration;
        if (memoryProfilerConfiguration == null) {
            MemoryProfilerStage.$$$reportNull$$$0(21);
        }
        return memoryProfilerConfiguration;
    }

    public AxisComponentModel getMemoryAxis() {
        return this.myMemoryAxis;
    }

    public AxisComponentModel getObjectsAxis() {
        return this.myObjectsAxis;
    }

    public MemoryStageLegends getLegends() {
        return this.myLegends;
    }

    public MemoryStageLegends getTooltipLegends() {
        return this.myTooltipLegends;
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        EaseOutModel easeOutModel = this.myInstructionsEaseOutModel;
        if (easeOutModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(22);
        }
        return easeOutModel;
    }

    public EventMonitor getEventMonitor() {
        return this.myEventMonitor;
    }

    @NotNull
    public DurationDataModel<GcDurationData> getGcStatsModel() {
        DurationDataModel<GcDurationData> durationDataModel = this.myGcStatsModel;
        if (durationDataModel == null) {
            MemoryProfilerStage.$$$reportNull$$$0(23);
        }
        return durationDataModel;
    }

    public String getName() {
        return "MEMORY";
    }

    @Override
    public void onNavigated(@NotNull CodeLocation location) {
        if (location == null) {
            MemoryProfilerStage.$$$reportNull$$$0(24);
        }
        this.setProfilerMode(ProfilerMode.NORMAL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadJoiner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldObjectPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationStackTraceModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeallocationStackTraceModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAspect";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationInfosDurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFieldObjectPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateDataSeries";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllocationSamplingRateDurations";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLiveAllocationSamplingMode";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveAllocationSamplingMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructionsEaseOutModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGcStatsModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "queryAndSelectCaptureObject";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectingCaptureDuration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectFieldObjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectCaptureFilter";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trackFilterUsage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "requestLiveAllocationSamplingModeUpdate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setLiveAllocationSamplingModelInternal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onNavigated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LiveAllocationSamplingMode {
        NONE(0, "None"),
        SAMPLED(10, "Sampled"),
        FULL(1, "Full");

        static final Map<Integer, LiveAllocationSamplingMode> SAMPLING_RATE_MAP;
        static final Map<String, LiveAllocationSamplingMode> NAME_MAP;
        private String myDisplayName;
        private int mySamplingFrequency;

        private LiveAllocationSamplingMode(int frequency, String displayName) {
            this.myDisplayName = displayName;
            this.mySamplingFrequency = frequency;
        }

        public String getDisplayName() {
            return this.myDisplayName;
        }

        public int getValue() {
            return this.mySamplingFrequency;
        }

        @NotNull
        static LiveAllocationSamplingMode getModeFromFrequency(int frequency) {
            LiveAllocationSamplingMode liveAllocationSamplingMode = SAMPLING_RATE_MAP.getOrDefault(frequency, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE);
            if (liveAllocationSamplingMode == null) {
                LiveAllocationSamplingMode.$$$reportNull$$$0(0);
            }
            return liveAllocationSamplingMode;
        }

        @NotNull
        static LiveAllocationSamplingMode getModeFromDisplayName(String displayName) {
            LiveAllocationSamplingMode liveAllocationSamplingMode = NAME_MAP.getOrDefault(displayName, DEFAULT_LIVE_ALLOCATION_SAMPLING_MODE);
            if (liveAllocationSamplingMode == null) {
                LiveAllocationSamplingMode.$$$reportNull$$$0(1);
            }
            return liveAllocationSamplingMode;
        }

        static {
            HashMap samplingRateMap = new HashMap();
            HashMap nameMap = new HashMap();
            for (LiveAllocationSamplingMode mode : LiveAllocationSamplingMode.values()) {
                samplingRateMap.put(mode.getValue(), mode);
                nameMap.put(mode.getDisplayName(), mode);
            }
            SAMPLING_RATE_MAP = ImmutableMap.copyOf((Map)samplingRateMap);
            NAME_MAP = ImmutableMap.copyOf((Map)nameMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/profilers/memory/MemoryProfilerStage$LiveAllocationSamplingMode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModeFromFrequency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModeFromDisplayName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class AllocationSamplingRateUpdatable
    implements Updatable {
        private AllocationSamplingRateUpdatable() {
        }

        public void update(long elapsedNs) {
            if (!MemoryProfilerStage.this.useLiveAllocationTracking()) {
                return;
            }
            double dataRangeMaxUs = MemoryProfilerStage.this.getStudioProfilers().getTimeline().getDataRange().getMax();
            List<SeriesData<AllocationSamplingRateDurationData>> data = MemoryProfilerStage.this.myAllocationSamplingRateDataSeries.getDataForXRange(new Range(dataRangeMaxUs, dataRangeMaxUs));
            if (data.isEmpty()) {
                return;
            }
            MemoryProfiler.AllocationSamplingRateEvent samplingInfo = ((AllocationSamplingRateDurationData)data.get((int)(data.size() - 1)).value).getCurrentRateEvent();
            LiveAllocationSamplingMode mode = LiveAllocationSamplingMode.getModeFromFrequency(samplingInfo.getSamplingRate().getSamplingNumInterval());
            MemoryProfilerStage.this.setLiveAllocationSamplingModelInternal(mode);
        }
    }

    private class CaptureElapsedTimeUpdatable
    implements Updatable {
        private CaptureElapsedTimeUpdatable() {
        }

        public void update(long elapsedNs) {
            if (MemoryProfilerStage.this.myTrackingAllocations) {
                MemoryProfilerStage.this.myAspect.changed((Enum)MemoryProfilerAspect.CURRENT_CAPTURE_ELAPSED_TIME);
            }
        }
    }

    public static class MemoryStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myJavaLegend;
        @NotNull
        private final SeriesLegend myNativeLegend;
        @NotNull
        private final SeriesLegend myGraphicsLegend;
        @NotNull
        private final SeriesLegend myStackLegend;
        @NotNull
        private final SeriesLegend myCodeLegend;
        @NotNull
        private final SeriesLegend myOtherLegend;
        @NotNull
        private final SeriesLegend myTotalLegend;
        @NotNull
        private final SeriesLegend myObjectsLegend;
        @NotNull
        private final EventLegend<GcDurationData> myGcDurationLegend;
        @NotNull
        private final EventLegend<AllocationSamplingRateDurationData> mySamplingRateDurationLegend;

        public MemoryStageLegends(@NotNull MemoryProfilerStage memoryStage, @NotNull Range range, boolean isTooltip) {
            if (memoryStage == null) {
                MemoryStageLegends.$$$reportNull$$$0(0);
            }
            if (range == null) {
                MemoryStageLegends.$$$reportNull$$$0(1);
            }
            super(range);
            DetailedMemoryUsage usage = memoryStage.getDetailedMemoryUsage();
            this.myJavaLegend = new SeriesLegend(usage.getJavaSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myNativeLegend = new SeriesLegend(usage.getNativeSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myGraphicsLegend = new SeriesLegend(usage.getGraphicsSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myStackLegend = new SeriesLegend(usage.getStackSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myCodeLegend = new SeriesLegend(usage.getCodeSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myOtherLegend = new SeriesLegend(usage.getOtherSeries(), MEMORY_AXIS_FORMATTER, range);
            this.myTotalLegend = new SeriesLegend(usage.getTotalMemorySeries(), MEMORY_AXIS_FORMATTER, range);
            this.myObjectsLegend = new SeriesLegend(usage.getObjectsSeries(), OBJECT_COUNT_AXIS_FORMATTER, range, usage.getObjectsSeries().getName(), Interpolatable.RoundedSegmentInterpolator, r -> {
                if (!memoryStage.useLiveAllocationTracking()) {
                    return true;
                }
                List data = usage.getAllocationSamplingRateDurations().getSeries().getDataSeries().getDataForXRange(r);
                if (data.isEmpty()) {
                    return false;
                }
                MemoryProfiler.AllocationSamplingRateEvent samplingInfo = ((AllocationSamplingRateDurationData)((SeriesData)data.get((int)(data.size() - 1))).value).getCurrentRateEvent();
                return LiveAllocationSamplingMode.getModeFromFrequency(samplingInfo.getSamplingRate().getSamplingNumInterval()) == LiveAllocationSamplingMode.FULL;
            });
            this.myGcDurationLegend = new EventLegend("GC Duration", duration -> TimeAxisFormatter.DEFAULT.getFormattedString((double)TimeUnit.MILLISECONDS.toMicros(1L), (double)duration.getDurationUs(), true));
            this.mySamplingRateDurationLegend = new EventLegend("Tracking", duration -> LiveAllocationSamplingMode.getModeFromFrequency(duration.getCurrentRateEvent().getSamplingRate().getSamplingNumInterval()).getDisplayName());
            List<Legend> legends = isTooltip ? Arrays.asList(this.myOtherLegend, this.myCodeLegend, this.myStackLegend, this.myGraphicsLegend, this.myNativeLegend, this.myJavaLegend, this.myObjectsLegend, this.mySamplingRateDurationLegend, this.myGcDurationLegend, this.myTotalLegend) : Arrays.asList(this.myTotalLegend, this.myJavaLegend, this.myNativeLegend, this.myGraphicsLegend, this.myStackLegend, this.myCodeLegend, this.myOtherLegend, this.myObjectsLegend);
            legends.forEach(arg_0 -> ((MemoryStageLegends)this).add(arg_0));
        }

        @NotNull
        public SeriesLegend getJavaLegend() {
            SeriesLegend seriesLegend = this.myJavaLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(2);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getNativeLegend() {
            SeriesLegend seriesLegend = this.myNativeLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(3);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getGraphicsLegend() {
            SeriesLegend seriesLegend = this.myGraphicsLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(4);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getStackLegend() {
            SeriesLegend seriesLegend = this.myStackLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(5);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getCodeLegend() {
            SeriesLegend seriesLegend = this.myCodeLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(6);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getOtherLegend() {
            SeriesLegend seriesLegend = this.myOtherLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(7);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getTotalLegend() {
            SeriesLegend seriesLegend = this.myTotalLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(8);
            }
            return seriesLegend;
        }

        @NotNull
        public SeriesLegend getObjectsLegend() {
            SeriesLegend seriesLegend = this.myObjectsLegend;
            if (seriesLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(9);
            }
            return seriesLegend;
        }

        @NotNull
        public EventLegend<GcDurationData> getGcDurationLegend() {
            EventLegend<GcDurationData> eventLegend = this.myGcDurationLegend;
            if (eventLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(10);
            }
            return eventLegend;
        }

        @NotNull
        public EventLegend<AllocationSamplingRateDurationData> getSamplingRateDurationLegend() {
            EventLegend<AllocationSamplingRateDurationData> eventLegend = this.mySamplingRateDurationLegend;
            if (eventLegend == null) {
                MemoryStageLegends.$$$reportNull$$$0(11);
            }
            return eventLegend;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memoryStage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/memory/MemoryProfilerStage$MemoryStageLegends";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/memory/MemoryProfilerStage$MemoryStageLegends";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavaLegend";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNativeLegend";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGraphicsLegend";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStackLegend";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCodeLegend";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOtherLegend";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTotalLegend";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectsLegend";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGcDurationLegend";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSamplingRateDurationLegend";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

