/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.android.tools.profilers.memory.adapters.HeapSet;
import java.util.Collection;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryHeapView
extends AspectObserver {
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private JComboBox<HeapSet> myComboBox;
    @Nullable
    private CaptureObject myCaptureObject;

    MemoryHeapView(@NotNull MemoryProfilerStage stage) {
        if (stage == null) {
            MemoryHeapView.$$$reportNull$$$0(0);
        }
        this.myComboBox = new ProfilerCombobox();
        this.myCaptureObject = null;
        this.myStage = stage;
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::setNewCapture).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::updateCaptureState).onChange((Enum)MemoryProfilerAspect.CURRENT_HEAP, this::refreshHeap);
        this.myComboBox.addActionListener(e -> {
            Object item = this.myComboBox.getSelectedItem();
            if (item instanceof HeapSet) {
                this.myStage.selectHeapSet((HeapSet)item);
            }
        });
        this.setNewCapture();
        this.refreshHeap();
    }

    @NotNull
    JComboBox<HeapSet> getComponent() {
        JComboBox<HeapSet> jComboBox = this.myComboBox;
        if (jComboBox == null) {
            MemoryHeapView.$$$reportNull$$$0(1);
        }
        return jComboBox;
    }

    private void setNewCapture() {
        this.myCaptureObject = this.myStage.getSelectedCapture();
        this.myComboBox.setModel(new DefaultComboBoxModel());
        this.myComboBox.setRenderer((ListCellRenderer<HeapSet>)((Object)new HeapListCellRenderer()));
        this.myStage.selectHeapSet(null);
    }

    private void updateCaptureState() {
        CaptureObject captureObject = this.myStage.getSelectedCapture();
        if (this.myCaptureObject != captureObject) {
            return;
        }
        this.myCaptureObject = captureObject;
        if (this.myCaptureObject == null) {
            return;
        }
        Collection<HeapSet> heaps = this.myCaptureObject.getHeapSets();
        HeapSet[] heapsArray = heaps.toArray(new HeapSet[heaps.size()]);
        DefaultComboBoxModel<HeapSet> comboBoxModel = new DefaultComboBoxModel<HeapSet>(heapsArray);
        this.myComboBox.setModel(comboBoxModel);
    }

    void refreshHeap() {
        Object selectedObject;
        HeapSet heapSet = this.myStage.getSelectedHeapSet();
        if (!Objects.equals(heapSet, selectedObject = this.myComboBox.getSelectedItem())) {
            this.myComboBox.setSelectedItem(heapSet);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryHeapView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryHeapView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class HeapListCellRenderer
    extends ProfilerComboboxCellRenderer<HeapSet> {
        private HeapListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends HeapSet> list, HeapSet value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                HeapListCellRenderer.$$$reportNull$$$0(0);
            }
            if (value != null) {
                this.append(value.getName() + " heap");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/memory/MemoryHeapView$HeapListCellRenderer", "customizeCellRenderer"));
        }
    }
}

