/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.memory.AllocationSamplingRateDurationData;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class AllocationSamplingRateDataSeries
implements DataSeries<AllocationSamplingRateDurationData> {
    @NotNull
    private MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;

    public AllocationSamplingRateDataSeries(@NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Common.Session session) {
        if (client == null) {
            AllocationSamplingRateDataSeries.$$$reportNull$$$0(0);
        }
        if (session == null) {
            AllocationSamplingRateDataSeries.$$$reportNull$$$0(1);
        }
        this.myClient = client;
        this.mySession = session;
    }

    public List<SeriesData<AllocationSamplingRateDurationData>> getDataForXRange(Range xRange) {
        MemoryProfiler.AllocationSamplingRateEvent currentEvent;
        long rangeMin = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMin());
        long rangeMax = TimeUnit.MICROSECONDS.toNanos((long)xRange.getMax());
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(0L).setEndTime(Long.MAX_VALUE);
        List events = this.myClient.getJvmtiData(dataRequestBuilder.build()).getAllocSamplingRateEventsList();
        ArrayList<SeriesData<AllocationSamplingRateDurationData>> seriesData = new ArrayList<SeriesData<AllocationSamplingRateDurationData>>();
        MemoryProfiler.AllocationSamplingRateEvent prevRateEvent = null;
        for (int i = 0; i < events.size() && (currentEvent = (MemoryProfiler.AllocationSamplingRateEvent)events.get(i)).getTimestamp() <= rangeMax; ++i) {
            long durationUs;
            MemoryProfiler.AllocationSamplingRateEvent nextRateEvent = i == events.size() - 1 ? null : (MemoryProfiler.AllocationSamplingRateEvent)events.get(i + 1);
            long l = durationUs = nextRateEvent == null ? TimeUnit.NANOSECONDS.toMicros(Long.MAX_VALUE) : TimeUnit.NANOSECONDS.toMicros(nextRateEvent.getTimestamp() - currentEvent.getTimestamp());
            if (nextRateEvent == null || nextRateEvent.getTimestamp() > rangeMin) {
                seriesData.add((SeriesData<AllocationSamplingRateDurationData>)new SeriesData(TimeUnit.NANOSECONDS.toMicros(currentEvent.getTimestamp()), (Object)new AllocationSamplingRateDurationData(durationUs, prevRateEvent, currentEvent)));
            }
            prevRateEvent = currentEvent;
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/memory/AllocationSamplingRateDataSeries";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

