/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.android.tools.profiler.proto.MemoryServiceGrpc;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public final class AllocStatsDataSeries
implements DataSeries<Long> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final MemoryServiceGrpc.MemoryServiceBlockingStub myClient;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final AspectObserver myObserver;
    private boolean myIsAgentAttached;
    @NotNull
    private Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> myFilter;

    public AllocStatsDataSeries(@NotNull StudioProfilers profilers, @NotNull MemoryServiceGrpc.MemoryServiceBlockingStub client, @NotNull Function<MemoryProfiler.MemoryData.AllocStatsSample, Long> filter) {
        if (profilers == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(0);
        }
        if (client == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(2);
        }
        this.myIsAgentAttached = false;
        this.myProfilers = profilers;
        this.myClient = client;
        this.mySession = this.myProfilers.getSession();
        this.myFilter = filter;
        this.myObserver = new AspectObserver();
        this.myProfilers.addDependency(this.myObserver).onChange((Enum)ProfilerAspect.AGENT, this::agentStatusChanged);
        this.agentStatusChanged();
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            AllocStatsDataSeries.$$$reportNull$$$0(3);
        }
        if (!this.myIsAgentAttached) {
            return Collections.emptyList();
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        MemoryProfiler.MemoryRequest.Builder dataRequestBuilder = MemoryProfiler.MemoryRequest.newBuilder().setSession(this.mySession).setStartTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTime(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        MemoryProfiler.MemoryData response = this.myClient.getData(dataRequestBuilder.build());
        ArrayList<SeriesData<Long>> seriesData = new ArrayList<SeriesData<Long>>();
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : response.getAllocStatsSamplesList()) {
            long dataTimestamp = TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp());
            seriesData.add((SeriesData<Long>)new SeriesData(dataTimestamp, (Object)this.myFilter.apply(sample)));
        }
        return seriesData;
    }

    private void agentStatusChanged() {
        this.myIsAgentAttached = this.myProfilers.isAgentAttached();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilers";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/memory/AllocStatsDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

