/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profilers.energy.EnergyDuration;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsTableTooltipInfoModel
extends AspectModel<Aspect> {
    @NotNull
    private final Range myGlobalRange;
    private final long mySystemTimeDelta;
    @Nullable
    private EnergyDuration myDuration;
    @Nullable
    private EnergyProfiler.EnergyEvent myCurrentSelectedEvent;

    EnergyEventsTableTooltipInfoModel(@NotNull Range globalRange, long systemTimeDelta) {
        if (globalRange == null) {
            EnergyEventsTableTooltipInfoModel.$$$reportNull$$$0(0);
        }
        this.myGlobalRange = globalRange;
        this.mySystemTimeDelta = systemTimeDelta;
    }

    public EnergyEventsTableTooltipInfoModel(@NotNull Range globalRange) {
        if (globalRange == null) {
            EnergyEventsTableTooltipInfoModel.$$$reportNull$$$0(1);
        }
        this(globalRange, TimeUnit.MICROSECONDS.toMillis((long)globalRange.getMax()) - System.currentTimeMillis());
    }

    public void update(@NotNull EnergyDuration duration, @NotNull Range range) {
        if (duration == null) {
            EnergyEventsTableTooltipInfoModel.$$$reportNull$$$0(2);
        }
        if (range == null) {
            EnergyEventsTableTooltipInfoModel.$$$reportNull$$$0(3);
        }
        EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)duration.getEventList().get(0);
        EnergyProfiler.EnergyEvent lastEvent = (EnergyProfiler.EnergyEvent)duration.getEventList().get(duration.getEventList().size() - 1);
        if (range.getMax() < (double)TimeUnit.NANOSECONDS.toMicros(firstEvent.getTimestamp()) || lastEvent.getIsTerminal() && range.getMin() > (double)TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp())) {
            duration = null;
        }
        EnergyProfiler.EnergyEvent newSelectedEvent = null;
        if (duration != null) {
            for (EnergyProfiler.EnergyEvent event : duration.getEventList()) {
                long minTimestamp = TimeUnit.MICROSECONDS.toNanos((long)range.getMin());
                long maxTimestamp = TimeUnit.MICROSECONDS.toNanos((long)range.getMax());
                if (event.getTimestamp() < minTimestamp || event.getTimestamp() > maxTimestamp) continue;
                newSelectedEvent = event;
                break;
            }
        }
        if (duration != this.myDuration || newSelectedEvent != this.myCurrentSelectedEvent) {
            this.myDuration = duration;
            this.myCurrentSelectedEvent = newSelectedEvent;
            this.changed(Aspect.EVENT);
        }
    }

    @Nullable
    public EnergyDuration getDuration() {
        return this.myDuration;
    }

    @Nullable
    public EnergyProfiler.EnergyEvent getCurrentSelectedEvent() {
        return this.myCurrentSelectedEvent;
    }

    @Nullable
    public String getStatusString() {
        return this.myCurrentSelectedEvent == null ? "Active" : EnergyDuration.getMetadataName(this.myCurrentSelectedEvent.getMetadataCase());
    }

    public String getDateFormattedString(long timestampMs) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("hh:mm a");
        return timeFormat.format(new Date(timestampMs - this.mySystemTimeDelta));
    }

    public String getSimplifiedClockFormattedString(long timestampUs) {
        return TimeFormatter.getSimplifiedClockString((long)(timestampUs - (long)this.myGlobalRange.getMin()));
    }

    public String getRangeString() {
        String unknownString;
        if (this.myDuration == null) {
            return null;
        }
        EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)this.myDuration.getEventList().get(0);
        EnergyProfiler.EnergyEvent lastEvent = (EnergyProfiler.EnergyEvent)this.myDuration.getEventList().get(this.myDuration.getEventList().size() - 1);
        String startTime = this.getSimplifiedClockFormattedString(TimeUnit.NANOSECONDS.toMicros(firstEvent.getTimestamp()));
        switch (this.myDuration.getKind()) {
            case WAKE_LOCK: {
                unknownString = "Unreleased";
                break;
            }
            case JOB: {
                unknownString = "Unfinished";
                break;
            }
            default: {
                unknownString = "Alive";
            }
        }
        String endTime = lastEvent.getIsTerminal() ? this.getSimplifiedClockFormattedString(TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp())) : unknownString;
        return startTime + " - " + endTime;
    }

    public String getDurationString() {
        if (this.myDuration == null) {
            return null;
        }
        EnergyProfiler.EnergyEvent firstEvent = (EnergyProfiler.EnergyEvent)this.myDuration.getEventList().get(0);
        EnergyProfiler.EnergyEvent lastEvent = (EnergyProfiler.EnergyEvent)this.myDuration.getEventList().get(this.myDuration.getEventList().size() - 1);
        if (!lastEvent.getIsTerminal()) {
            return null;
        }
        return TimeFormatter.getSingleUnitDurationString((long)TimeUnit.NANOSECONDS.toMicros(lastEvent.getTimestamp() - firstEvent.getTimestamp()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventsTableTooltipInfoModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Aspect {
        EVENT;

    }
}

