/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.energy;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.proto.EnergyServiceGrpc;
import com.android.tools.profilers.energy.EnergyDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyEventsFetcher {
    private final AspectObserver myAspectObserver;
    @NotNull
    private final EnergyServiceGrpc.EnergyServiceBlockingStub myClient;
    @NotNull
    Common.Session mySession;
    @NotNull
    private final List<Listener> myListeners;
    @NotNull
    private final Range myRange;
    @Nullable
    private List<EnergyDuration> myDurationList;

    public EnergyEventsFetcher(@NotNull EnergyServiceGrpc.EnergyServiceBlockingStub client, @NotNull Common.Session session, @NotNull Range range) {
        if (client == null) {
            EnergyEventsFetcher.$$$reportNull$$$0(0);
        }
        if (session == null) {
            EnergyEventsFetcher.$$$reportNull$$$0(1);
        }
        if (range == null) {
            EnergyEventsFetcher.$$$reportNull$$$0(2);
        }
        this.myAspectObserver = new AspectObserver();
        this.myListeners = new ArrayList<Listener>();
        this.myClient = client;
        this.mySession = session;
        this.myRange = range;
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::handleRangeUpdated);
        this.handleRangeUpdated();
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            EnergyEventsFetcher.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener);
        if (this.myDurationList != null) {
            this.fireListeners(this.myDurationList);
        }
    }

    private void handleRangeUpdated() {
        ArrayList<EnergyDuration> durationList = new ArrayList<EnergyDuration>();
        if (!this.myRange.isEmpty()) {
            EnergyProfiler.EnergyRequest request = EnergyProfiler.EnergyRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax())).build();
            List eventList = this.myClient.getEvents(request).getEventsList();
            List<EnergyDuration> partialDurations = EnergyDuration.groupById(eventList);
            for (EnergyDuration partialDuration : partialDurations) {
                EnergyProfiler.EnergyEventGroupRequest eventGroupRequest = EnergyProfiler.EnergyEventGroupRequest.newBuilder().setSession(this.mySession).setEventId(((EnergyProfiler.EnergyEvent)partialDuration.getEventList().get(0)).getEventId()).build();
                durationList.add(new EnergyDuration(this.myClient.getEventGroup(eventGroupRequest).getEventsList()));
            }
        }
        if (this.myDurationList == null || !this.myDurationList.equals(durationList)) {
            this.myDurationList = durationList;
            this.fireListeners(this.myDurationList);
        }
    }

    private void fireListeners(@NotNull List<EnergyDuration> list) {
        if (list == null) {
            EnergyEventsFetcher.$$$reportNull$$$0(4);
        }
        for (Listener l : this.myListeners) {
            l.onUpdated(list);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/energy/EnergyEventsFetcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fireListeners";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onUpdated(@NotNull List<EnergyDuration> var1);
    }
}

