/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.capturedetails.CapturePane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

abstract class StatusPane
extends CapturePane {
    @NotNull
    private String myStatus;
    @NotNull
    private JLabel myDurationLabel;
    @NotNull
    private final String myTechnology;
    @NotNull
    protected final CpuProfilerStage myStage;
    @NotNull
    protected final AspectObserver myObserver;

    public StatusPane(@NotNull CpuProfilerStageView stageView, @NotNull String statusLabel) {
        if (stageView == null) {
            StatusPane.$$$reportNull$$$0(0);
        }
        if (statusLabel == null) {
            StatusPane.$$$reportNull$$$0(1);
        }
        super(stageView);
        this.myStage = (CpuProfilerStage)stageView.getStage();
        this.myStatus = statusLabel;
        this.myDurationLabel = StatusPane.createLabel("", false);
        this.myTechnology = ProfilingTechnology.fromConfig(this.myStage.getProfilerConfigModel().getProfilingConfiguration()).getName();
        this.myObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME, this::updateDuration);
        this.disableInteraction();
        this.updateView();
    }

    @Override
    void populateContent(@NotNull JPanel panel) {
        if (panel == null) {
            StatusPane.$$$reportNull$$$0(2);
        }
        JPanel mainPanel = new JPanel((LayoutManager)new TabularLayout("*,300px,*", "*,150px,*"));
        JPanel statusPanel = new JPanel((LayoutManager)new TabularLayout("*,Fit,20px,Fit,*", "28px,Fit,Fit,Fit,Fit,*").setVGap(JBUI.scale((int)5)));
        statusPanel.setBorder(new LineBorder(ProfilerColors.CPU_CAPTURE_STATUS, 1));
        JLabel status = StatusPane.createLabel("Status", true);
        JLabel actualStatus = StatusPane.createLabel(this.myStatus, false);
        JLabel duration = StatusPane.createLabel("Duration", true);
        JLabel technology = StatusPane.createLabel("Type", true);
        JLabel actualTechnology = StatusPane.createLabel(this.myTechnology, false);
        statusPanel.add((Component)status, new TabularLayout.Constraint(1, 1));
        statusPanel.add((Component)actualStatus, new TabularLayout.Constraint(1, 3));
        statusPanel.add((Component)duration, new TabularLayout.Constraint(2, 1));
        statusPanel.add((Component)this.myDurationLabel, new TabularLayout.Constraint(2, 3));
        statusPanel.add((Component)technology, new TabularLayout.Constraint(3, 1));
        statusPanel.add((Component)actualTechnology, new TabularLayout.Constraint(3, 3));
        statusPanel.add((Component)this.createButtonPanel(), new TabularLayout.Constraint(4, 3, 1));
        mainPanel.add((Component)statusPanel, new TabularLayout.Constraint(1, 1));
        panel.add((Component)mainPanel, "Center");
    }

    private void updateDuration() {
        this.myDurationLabel.setText(this.getDurationText());
    }

    private static JLabel createLabel(String text, boolean isRightAligned) {
        JLabel label = new JLabel(text, isRightAligned ? 4 : 2);
        label.setFont(ProfilerFonts.STANDARD_FONT);
        label.setForeground(ProfilerColors.CPU_CAPTURE_STATUS);
        label.setBorder((Border)JBUI.Borders.empty());
        return label;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new TabularLayout("Fit", "4px,*"));
        panel.add((Component)this.createAbortButton(), new TabularLayout.Constraint(1, 0));
        return panel;
    }

    protected abstract JButton createAbortButton();

    @NotNull
    protected abstract String getDurationText();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stageView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusLabel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/StatusPane";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "populateContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

