/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpNode;
import com.android.tools.profilers.cpu.capturedetails.BottomUpTreeModel;
import com.android.tools.profilers.cpu.capturedetails.TopDownNode;
import com.android.tools.profilers.cpu.capturedetails.TopDownTreeModel;
import java.util.ArrayList;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaptureDetails {
    public Type getType();

    public static class FlameChart
    implements ChartDetails {
        @NotNull
        private final Range myFlameRange;
        @Nullable
        private CaptureNode myFlameNode;
        @Nullable
        private final TopDownNode myTopDownNode;
        @NotNull
        private final Range mySelectionRange;
        @NotNull
        private final AspectModel<Aspect> myAspectModel;

        public FlameChart(@NotNull Range selectionRange, @Nullable CaptureNode captureNode) {
            if (selectionRange == null) {
                FlameChart.$$$reportNull$$$0(0);
            }
            this.mySelectionRange = selectionRange;
            this.myFlameRange = new Range();
            this.myAspectModel = new AspectModel();
            if (captureNode == null) {
                this.myFlameNode = null;
                this.myTopDownNode = null;
                return;
            }
            this.myTopDownNode = new TopDownNode(captureNode);
            selectionRange.addDependency(this.myAspectModel).onChange((Enum)Range.Aspect.RANGE, this::selectionRangeChanged);
            this.selectionRangeChanged();
        }

        private void selectionRangeChanged() {
            assert (this.myTopDownNode != null);
            this.myTopDownNode.update(this.mySelectionRange);
            if (this.myTopDownNode.getGlobalTotal() > 0.0) {
                double start = Math.max((double)this.myTopDownNode.getNodes().get(0).getStart(), this.mySelectionRange.getMin());
                this.myFlameNode = this.convertToFlameChart(this.myTopDownNode, start, 0);
            } else {
                this.myFlameNode = null;
            }
            this.myFlameRange.set(this.mySelectionRange);
            this.myAspectModel.changed((Enum)Aspect.NODE);
        }

        @NotNull
        public Range getRange() {
            Range range = this.myFlameRange;
            if (range == null) {
                FlameChart.$$$reportNull$$$0(1);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myFlameNode;
        }

        @NotNull
        public AspectModel<Aspect> getAspect() {
            AspectModel<Aspect> aspectModel = this.myAspectModel;
            if (aspectModel == null) {
                FlameChart.$$$reportNull$$$0(2);
            }
            return aspectModel;
        }

        @Override
        public Type getType() {
            return Type.FLAME_CHART;
        }

        /*
         * WARNING - void declaration
         */
        private CaptureNode convertToFlameChart(@NotNull TopDownNode topDown, double start, int n) {
            void depth;
            if (topDown == null) {
                FlameChart.$$$reportNull$$$0(3);
            }
            assert (topDown.getGlobalTotal() > 0.0);
            CaptureNode node = new CaptureNode(topDown.getNodes().get(0).getData());
            node.setFilterType(topDown.getNodes().get(0).getFilterType());
            node.setStartGlobal((long)start);
            node.setStartThread((long)start);
            node.setEndGlobal((long)(start + topDown.getGlobalTotal()));
            node.setEndThread((long)(start + topDown.getThreadTotal()));
            node.setDepth((int)depth);
            for (TopDownNode child : topDown.getChildren()) {
                child.update(this.mySelectionRange);
            }
            ArrayList sortedChildren = new ArrayList(topDown.getChildren());
            sortedChildren.sort((o1, o2) -> {
                int cmp = Boolean.compare(o1.isUnmatched(), o2.isUnmatched());
                return cmp == 0 ? Double.compare(o2.getGlobalTotal(), o1.getGlobalTotal()) : cmp;
            });
            for (TopDownNode child : sortedChildren) {
                if (child.getGlobalTotal() == 0.0) continue;
                node.addChild(this.convertToFlameChart(child, start, (int)(depth + true)));
                start += child.getGlobalTotal();
            }
            return node;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectionRange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topDown";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$FlameChart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAspect";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToFlameChart";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Aspect {
            NODE;

        }
    }

    public static class CallChart
    implements ChartDetails {
        @NotNull
        private final Range myRange;
        @Nullable
        private CaptureNode myNode;

        public CallChart(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                CallChart.$$$reportNull$$$0(0);
            }
            this.myRange = range;
            this.myNode = node;
        }

        @NotNull
        public Range getRange() {
            Range range = this.myRange;
            if (range == null) {
                CallChart.$$$reportNull$$$0(1);
            }
            return range;
        }

        @Override
        @Nullable
        public CaptureNode getNode() {
            return this.myNode;
        }

        @Override
        public Type getType() {
            return Type.CALL_CHART;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$CallChart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class BottomUp
    implements CaptureDetails {
        @Nullable
        private BottomUpTreeModel myModel;

        public BottomUp(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                BottomUp.$$$reportNull$$$0(0);
            }
            this.myModel = node == null ? null : new BottomUpTreeModel(range, new BottomUpNode(node));
        }

        @Nullable
        public BottomUpTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Type getType() {
            return Type.BOTTOM_UP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$BottomUp", "<init>"));
        }
    }

    public static class TopDown
    implements CaptureDetails {
        @Nullable
        private final TopDownTreeModel myModel;

        public TopDown(@NotNull Range range, @Nullable CaptureNode node) {
            if (range == null) {
                TopDown.$$$reportNull$$$0(0);
            }
            this.myModel = node == null ? null : new TopDownTreeModel(range, new TopDownNode(node));
        }

        @Nullable
        public TopDownTreeModel getModel() {
            return this.myModel;
        }

        @Override
        public Type getType() {
            return Type.TOP_DOWN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$TopDown", "<init>"));
        }
    }

    public static interface ChartDetails
    extends CaptureDetails {
        @Nullable
        public CaptureNode getNode();
    }

    public static enum Type {
        TOP_DOWN(TopDown::new),
        BOTTOM_UP(BottomUp::new),
        CALL_CHART(CallChart::new),
        FLAME_CHART(FlameChart::new);

        @NotNull
        private final BiFunction<Range, CaptureNode, CaptureDetails> myBuilder;

        private Type(BiFunction<Range, CaptureNode, CaptureDetails> builder) {
            if (builder == null) {
                Type.$$$reportNull$$$0(0);
            }
            this.myBuilder = builder;
        }

        public CaptureDetails build(Range range, CaptureNode node) {
            return this.myBuilder.apply(range, node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/android/tools/profilers/cpu/capturedetails/CaptureDetails$Type", "<init>"));
        }
    }
}

