/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.capturedetails;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.capturedetails.CpuTreeNode;
import com.android.tools.profilers.cpu.nodemodel.CaptureNodeModel;
import com.android.tools.profilers.cpu.nodemodel.SingleNameModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class BottomUpNode
extends CpuTreeNode<BottomUpNode> {
    private final List<CaptureNode> myPathNodes;
    private final boolean myIsRoot;
    private boolean myChildrenBuilt;

    private BottomUpNode(String id) {
        super(id);
        this.myPathNodes = new ArrayList<CaptureNode>();
        this.myIsRoot = false;
        this.myChildrenBuilt = false;
    }

    public BottomUpNode(@NotNull CaptureNode node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(0);
        }
        super("Root");
        this.myPathNodes = new ArrayList<CaptureNode>();
        this.myIsRoot = true;
        this.myChildrenBuilt = true;
        ArrayList<CaptureNode> allNodes = new ArrayList<CaptureNode>();
        Stack<CaptureNode> stack = new Stack<CaptureNode>();
        stack.add(node);
        while (!stack.isEmpty()) {
            CaptureNode curNode = (CaptureNode)stack.pop();
            allNodes.add(curNode);
            for (int i = curNode.getChildren().size() - 1; i >= 0; --i) {
                stack.add(curNode.getChildren().get(i));
            }
        }
        HashMap<String, BottomUpNode> children = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        for (CaptureNode curNode : allNodes) {
            BottomUpNode child;
            assert (curNode.getData() != null);
            String curId = curNode.getData().getId();
            BottomUpNode bottomUpNode = child = curNode.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(curId) : (BottomUpNode)children.get(curId);
            if (child == null) {
                child = new BottomUpNode(curId);
                if (curNode.isUnmatched()) {
                    unmatchedChildren.put(curId, child);
                } else {
                    children.put(curId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(curNode);
            child.addNode(curNode);
        }
        this.addNode(node);
        for (BottomUpNode child : this.getChildren()) {
            child.buildChildren();
        }
    }

    private void addPathNode(@NotNull CaptureNode node) {
        if (node == null) {
            BottomUpNode.$$$reportNull$$$0(1);
        }
        this.myPathNodes.add(node);
    }

    public boolean buildChildren() {
        if (this.myChildrenBuilt) {
            return false;
        }
        HashMap<String, BottomUpNode> children = new HashMap<String, BottomUpNode>();
        HashMap<String, BottomUpNode> unmatchedChildren = new HashMap<String, BottomUpNode>();
        assert (this.myPathNodes.size() == this.getNodes().size());
        for (int i = 0; i < this.myPathNodes.size(); ++i) {
            BottomUpNode child;
            CaptureNode parent = this.myPathNodes.get(i).getParent();
            if (parent == null) continue;
            assert (parent.getData() != null);
            String parentId = parent.getData().getId();
            BottomUpNode bottomUpNode = child = parent.isUnmatched() ? (BottomUpNode)unmatchedChildren.get(parentId) : (BottomUpNode)children.get(parentId);
            if (child == null) {
                child = new BottomUpNode(parentId);
                if (parent.isUnmatched()) {
                    unmatchedChildren.put(parentId, child);
                } else {
                    children.put(parentId, child);
                }
                this.addChild(child);
            }
            child.addPathNode(parent);
            child.addNode(this.getNodes().get(i));
        }
        this.myChildrenBuilt = true;
        return true;
    }

    @Override
    public void update(@NotNull Range range) {
        if (range == null) {
            BottomUpNode.$$$reportNull$$$0(2);
        }
        this.myGlobalTotal = 0.0;
        double self = 0.0;
        CaptureNode outerSoFar = null;
        for (CaptureNode node : this.myNodes) {
            if (outerSoFar == null || node.getEnd() > outerSoFar.getEnd()) {
                if (outerSoFar != null) {
                    this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
                }
                outerSoFar = node;
            }
            self += BottomUpNode.getIntersection(range, node, ClockType.GLOBAL);
            for (CaptureNode child : node.getChildren()) {
                self -= BottomUpNode.getIntersection(range, child, ClockType.GLOBAL);
            }
        }
        if (outerSoFar != null) {
            this.myGlobalTotal += BottomUpNode.getIntersection(range, outerSoFar, ClockType.GLOBAL);
        }
        this.myGlobalChildrenTotal = this.myGlobalTotal - self;
    }

    @Override
    @NotNull
    public CaptureNodeModel getMethodModel() {
        if (this.myIsRoot) {
            SingleNameModel singleNameModel = new SingleNameModel("");
            if (singleNameModel == null) {
                BottomUpNode.$$$reportNull$$$0(3);
            }
            return singleNameModel;
        }
        CaptureNodeModel model = this.myPathNodes.get(0).getData();
        assert (model != null);
        CaptureNodeModel captureNodeModel = model;
        if (captureNodeModel == null) {
            BottomUpNode.$$$reportNull$$$0(4);
        }
        return captureNodeModel;
    }

    @Override
    public CaptureNode.FilterType getFilterType() {
        if (this.myIsRoot) {
            return CaptureNode.FilterType.MATCH;
        }
        return this.myPathNodes.get(0).getFilterType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/capturedetails/BottomUpNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/capturedetails/BottomUpNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addPathNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

