/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.atrace;

import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuThreadInfo;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.AtraceDecompressor;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import com.android.tools.profilers.cpu.atrace.AtraceFrameManager;
import com.android.tools.profilers.cpu.atrace.CpuThreadSliceInfo;
import com.android.tools.profilers.cpu.nodemodel.AtraceNodeModel;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import trebuchet.model.CpuModel;
import trebuchet.model.CpuProcessSlice;
import trebuchet.model.Model;
import trebuchet.model.ProcessModel;
import trebuchet.model.SchedSlice;
import trebuchet.model.ThreadModel;
import trebuchet.model.base.SliceGroup;
import trebuchet.task.ImportTask;
import trebuchet.util.PrintlnImportFeedback;

public class AtraceParser
implements TraceParser {
    public static final int INVALID_PROCESS = Integer.MAX_VALUE;
    public static final String RENDER_THREAD_NAME = "RenderThread";
    private final Map<CpuThreadInfo, CaptureNode> myCaptureTreeNodes;
    private final Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> myCpuSchedulingToCpuData;
    private final Map<Integer, List<SeriesData<CpuProfilerStage.ThreadState>>> myThreadStateData;
    private final List<SeriesData<Long>> myCpuUtilizationSeries;
    private int myProcessId;
    private double myMonoTimeAtBeginningSeconds;
    private ProcessModel myProcessModel;
    private Model myModel;
    private Range myRange;
    private AtraceFrameManager myFrameInfo;

    public AtraceParser(@NotNull File file) throws IOException {
        if (file == null) {
            AtraceParser.$$$reportNull$$$0(0);
        }
        this(Integer.MAX_VALUE);
        this.parseModelIfNeeded(file);
    }

    public AtraceParser(int processId) {
        this.myMonoTimeAtBeginningSeconds = 0.0;
        this.myProcessId = processId;
        this.myCaptureTreeNodes = new HashMap<CpuThreadInfo, CaptureNode>();
        this.myThreadStateData = new HashMap<Integer, List<SeriesData<CpuProfilerStage.ThreadState>>>();
        this.myCpuSchedulingToCpuData = new HashMap<Integer, List<SeriesData<CpuThreadSliceInfo>>>();
        this.myCpuUtilizationSeries = new LinkedList<SeriesData<Long>>();
    }

    @Override
    public CpuCapture parse(File file, int traceId) throws IOException {
        this.parseModelIfNeeded(file);
        double startTimestampUs = this.convertToUserTimeUs(this.myModel.getBeginTimestamp());
        double endTimestampUs = this.convertToUserTimeUs(this.myModel.getEndTimestamp());
        this.myRange = new Range(startTimestampUs, endTimestampUs);
        this.myProcessModel = this.myModel.getProcesses().get(this.myProcessId);
        if (this.myProcessModel == null) {
            throw new IllegalArgumentException(String.format("A process with the id %s was not found while parsing the capture.", this.myProcessId));
        }
        this.buildCaptureTreeNodes();
        this.buildThreadStateData();
        this.buildCpuStateData();
        this.myFrameInfo = new AtraceFrameManager(this.myProcessModel, (Function<Double, Long>)((Function)this::convertToUserTimeUs), AtraceParser.findRenderThreadId(this.myProcessModel));
        return new AtraceCpuCapture(this, traceId);
    }

    private void parseModelIfNeeded(@NotNull File file) throws IOException {
        if (file == null) {
            AtraceParser.$$$reportNull$$$0(1);
        }
        if (this.myModel == null) {
            AtraceDecompressor reader = new AtraceDecompressor(file);
            ImportTask task = new ImportTask(new PrintlnImportFeedback());
            this.myModel = task.importBuffer(reader);
            this.myMonoTimeAtBeginningSeconds = Double.compare(this.myModel.getParentTimestamp(), 0.0) == 0 ? this.myModel.getBeginTimestamp() : this.myModel.getParentTimestamp() - (this.myModel.getParentTimestampBootTime() - this.myModel.getBeginTimestamp());
        }
    }

    public boolean isMissingData() {
        return this.myModel.getRealtimeTimestamp() == 0L;
    }

    @NotNull
    public CpuThreadSliceInfo[] getProcessList(String hint) {
        assert (this.myModel != null);
        CpuThreadSliceInfo[] processList = new CpuThreadSliceInfo[this.myModel.getProcesses().size()];
        Stream<ProcessModel> processStream = this.myModel.getProcesses().values().stream();
        int index = 0;
        String hintLower = hint.toLowerCase(Locale.getDefault());
        processStream = processStream.sorted((a, b) -> {
            String aNameLower = AtraceParser.getMainThreadForProcess(a).toLowerCase(Locale.getDefault());
            String bNameLower = AtraceParser.getMainThreadForProcess(b).toLowerCase(Locale.getDefault());
            if (hintLower.contains(aNameLower) && !hintLower.contains(bNameLower)) {
                return -1;
            }
            if (hintLower.contains(bNameLower) && !hintLower.contains(aNameLower)) {
                return 1;
            }
            if (aNameLower.startsWith("<") && !bNameLower.startsWith("<")) {
                return 1;
            }
            if (bNameLower.startsWith("<") && !aNameLower.startsWith("<")) {
                return -1;
            }
            int threadsGreater = b.getThreads().size() - a.getThreads().size();
            if (threadsGreater != 0) {
                return threadsGreater;
            }
            int name = aNameLower.compareTo(bNameLower);
            if (name == 0) {
                return b.getId() - a.getId();
            }
            return name;
        });
        List processes = processStream.collect(Collectors.toList());
        for (ProcessModel process : processes) {
            String name = AtraceParser.getMainThreadForProcess(process);
            processList[index++] = new CpuThreadSliceInfo(process.getId(), name, process.getId(), name);
        }
        if (processList == null) {
            AtraceParser.$$$reportNull$$$0(2);
        }
        return processList;
    }

    public void setSelectProcess(@NotNull CpuThreadSliceInfo process) {
        if (process == null) {
            AtraceParser.$$$reportNull$$$0(3);
        }
        assert (this.myModel != null);
        assert (this.myModel.getProcesses().containsKey(process.getProcessId()));
        this.myProcessId = process.getProcessId();
    }

    @Override
    public boolean supportsDualClock() {
        return false;
    }

    private static double secondsToUs(double time) {
        return time * 1000000.0;
    }

    @Override
    public Map<CpuThreadInfo, CaptureNode> getCaptureTrees() {
        return this.myCaptureTreeNodes;
    }

    @NotNull
    public Map<Integer, List<SeriesData<CpuProfilerStage.ThreadState>>> getThreadStateDataSeries() {
        Map<Integer, List<SeriesData<CpuProfilerStage.ThreadState>>> map = this.myThreadStateData;
        if (map == null) {
            AtraceParser.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    public Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> getCpuThreadSliceInfoStates() {
        Map<Integer, List<SeriesData<CpuThreadSliceInfo>>> map = this.myCpuSchedulingToCpuData;
        if (map == null) {
            AtraceParser.$$$reportNull$$$0(5);
        }
        return map;
    }

    @NotNull
    public List<SeriesData<Long>> getCpuUtilizationSeries() {
        List<SeriesData<Long>> list = this.myCpuUtilizationSeries;
        if (list == null) {
            AtraceParser.$$$reportNull$$$0(6);
        }
        return list;
    }

    public int getRenderThreadId() {
        return AtraceParser.findRenderThreadId(this.myProcessModel);
    }

    @NotNull
    public List<SeriesData<AtraceFrame>> getFrames(AtraceFrameFilterConfig filter) {
        ArrayList<SeriesData<AtraceFrame>> framesSeries = new ArrayList<SeriesData<AtraceFrame>>();
        List<AtraceFrame> framesList = this.myFrameInfo.buildFramesList(filter);
        for (int i = 1; i < framesList.size(); ++i) {
            AtraceFrame current = framesList.get(i);
            AtraceFrame past = framesList.get(i - 1);
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.convertToUserTimeUs(past.getTotalRangeSeconds().getMin()), (Object)past));
            if (!(past.getTotalRangeSeconds().getMax() < current.getTotalRangeSeconds().getMin())) continue;
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.convertToUserTimeUs(past.getTotalRangeSeconds().getMax()), (Object)AtraceFrame.EMPTY));
        }
        if (!framesList.isEmpty()) {
            AtraceFrame lastFrame = framesList.get(framesList.size() - 1);
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.convertToUserTimeUs(lastFrame.getTotalRangeSeconds().getMin()), (Object)lastFrame));
            framesSeries.add((SeriesData<AtraceFrame>)new SeriesData(this.convertToUserTimeUs(lastFrame.getTotalRangeSeconds().getMax()), (Object)AtraceFrame.EMPTY));
        }
        ArrayList<SeriesData<AtraceFrame>> arrayList = framesSeries;
        if (arrayList == null) {
            AtraceParser.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void buildCaptureTreeNodes() {
        Range range = this.getRange();
        for (ThreadModel thread2 : this.myProcessModel.getThreads()) {
            CpuThreadSliceInfo threadInfo = new CpuThreadSliceInfo(thread2.getId(), thread2.getName(), thread2.getProcess().getId(), thread2.getProcess().getName());
            CaptureNode root = new CaptureNode(new AtraceNodeModel(thread2.getName()));
            root.setStartGlobal((long)range.getMin());
            root.setEndGlobal((long)range.getMax());
            this.myCaptureTreeNodes.put(threadInfo, root);
            for (SliceGroup slice : thread2.getSlices()) {
                CaptureNode node = this.populateCaptureNode(slice, 1);
                root.addChild(node);
            }
        }
    }

    private CaptureNode populateCaptureNode(SliceGroup slice, int depth) {
        CaptureNode node = new CaptureNode(new AtraceNodeModel(slice.getName()));
        node.setStartGlobal(this.convertToUserTimeUs(slice.getStartTime()));
        node.setEndGlobal(this.convertToUserTimeUs(slice.getEndTime()));
        node.setStartThread(this.convertToUserTimeUs(slice.getStartTime()));
        node.setEndThread(this.convertToUserTimeUs(slice.getStartTime() + slice.getCpuTime()));
        node.setDepth(depth);
        for (SliceGroup child : slice.getChildren()) {
            node.addChild(this.populateCaptureNode(child, depth + 1));
        }
        return node;
    }

    private void buildThreadStateData() {
        for (ThreadModel thread2 : this.myProcessModel.getThreads()) {
            ArrayList<SeriesData> states = new ArrayList<SeriesData>();
            this.myThreadStateData.put(thread2.getId(), states);
            CpuProfilerStage.ThreadState lastState = CpuProfilerStage.ThreadState.UNKNOWN;
            for (SchedSlice slice : thread2.getSchedSlices()) {
                long startTimeUs = this.convertToUserTimeUs(slice.getStartTime());
                CpuProfilerStage.ThreadState state = AtraceParser.getState(slice);
                if (state == lastState) continue;
                states.add(new SeriesData(startTimeUs, (Object)state));
                lastState = state;
            }
        }
    }

    private void buildCpuStateData() {
        this.myCpuUtilizationSeries.add((SeriesData<Long>)new SeriesData(this.convertToUserTimeUs(this.myModel.getBeginTimestamp()), (Object)0L));
        for (CpuModel cpu : this.myModel.getCpus()) {
            ListIterator<SeriesData<Long>> cpuSeriesIt = this.myCpuUtilizationSeries.listIterator();
            ArrayList<SeriesData> processList = new ArrayList<SeriesData>();
            CpuProcessSlice lastSlice = cpu.getSlices().get(0);
            for (CpuProcessSlice slice : cpu.getSlices()) {
                long sliceStartTimeUs = this.convertToUserTimeUs(slice.getStartTime());
                long sliceEndTimeUs = this.convertToUserTimeUs(slice.getEndTime());
                long durationUs = sliceEndTimeUs - sliceStartTimeUs;
                if (slice.getStartTime() > lastSlice.getEndTime()) {
                    processList.add(new SeriesData(sliceEndTimeUs, (Object)CpuThreadSliceInfo.NULL_THREAD));
                }
                processList.add(new SeriesData(sliceStartTimeUs, (Object)new CpuThreadSliceInfo(slice.getThreadId(), slice.getThreadName(), slice.getId(), slice.getName(), durationUs)));
                lastSlice = slice;
                if (slice.getId() != this.myProcessId) continue;
                AtraceParser.buildCpuUtilizationData(cpuSeriesIt, sliceStartTimeUs, sliceEndTimeUs);
            }
            processList.add(new SeriesData(this.convertToUserTimeUs(this.myModel.getEndTimestamp()), (Object)CpuThreadSliceInfo.NULL_THREAD));
            this.myCpuSchedulingToCpuData.put(cpu.getId(), processList);
        }
        this.myCpuUtilizationSeries.replaceAll(series -> {
            SeriesData seriesData = series;
            seriesData.value = (Long)seriesData.value * (long)(100.0 / ((double)this.myModel.getCpus().size() * 1.0));
            return series;
        });
    }

    @NotNull
    private static SeriesData<Long> buildCpuUtilizationData(ListIterator<SeriesData<Long>> cpuSeriesIt, Long sliceStartTimeUs, Long sliceEndTimeUs) {
        SeriesData<Long> seriesData;
        SeriesData<Long> current;
        Object usedCpuCount = Long.valueOf(1L);
        SeriesData<Long> last = null;
        if (cpuSeriesIt.hasPrevious()) {
            last = cpuSeriesIt.previous();
        }
        while (cpuSeriesIt.hasNext()) {
            SeriesData<Long> current2 = cpuSeriesIt.next();
            if (current2.x > sliceStartTimeUs) {
                cpuSeriesIt.previous();
                if (last == null) break;
                usedCpuCount = (Long)last.value + 1L;
                break;
            }
            last = current2;
        }
        SeriesData<Long> startProcessPoint = new SeriesData<Long>(sliceStartTimeUs.longValue(), usedCpuCount);
        cpuSeriesIt.add(startProcessPoint);
        last = startProcessPoint;
        while (cpuSeriesIt.hasNext()) {
            current = cpuSeriesIt.next();
            if (current.x > sliceEndTimeUs) {
                cpuSeriesIt.previous();
                usedCpuCount = (Long)last.value;
                break;
            }
            seriesData = current;
            Long l = (Long)seriesData.value;
            seriesData.value = (Long)seriesData.value + 1L;
            Long l2 = seriesData.value;
            usedCpuCount = (Long)current.value;
            cpuSeriesIt.set(current);
            last = current;
        }
        current = usedCpuCount;
        seriesData = usedCpuCount = Long.valueOf(usedCpuCount.longValue() - 1L);
        SeriesData endProcessPoint = new SeriesData(sliceEndTimeUs.longValue(), usedCpuCount);
        cpuSeriesIt.add((SeriesData<Long>)endProcessPoint);
        SeriesData<Long> seriesData2 = last = endProcessPoint;
        if (seriesData2 == null) {
            AtraceParser.$$$reportNull$$$0(8);
        }
        return seriesData2;
    }

    private static CpuProfilerStage.ThreadState getState(SchedSlice slice) {
        switch (slice.getState()) {
            case RUNNING: {
                return CpuProfilerStage.ThreadState.RUNNING_CAPTURED;
            }
            case WAKING: 
            case RUNNABLE: {
                return CpuProfilerStage.ThreadState.RUNNABLE_CAPTURED;
            }
            case EXIT_DEAD: {
                return CpuProfilerStage.ThreadState.DEAD_CAPTURED;
            }
            case SLEEPING: {
                return CpuProfilerStage.ThreadState.SLEEPING_CAPTURED;
            }
            case UNINTR_SLEEP: {
                return CpuProfilerStage.ThreadState.WAITING_CAPTURED;
            }
            case UNINTR_SLEEP_IO: {
                return CpuProfilerStage.ThreadState.WAITING_IO_CAPTURED;
            }
        }
        return CpuProfilerStage.ThreadState.UNKNOWN;
    }

    @Override
    public Range getRange() {
        return this.myRange;
    }

    private long convertToUserTimeUs(double timestampInSeconds) {
        return (long)AtraceParser.secondsToUs(timestampInSeconds - this.myModel.getBeginTimestamp() + this.myMonoTimeAtBeginningSeconds);
    }

    @NotNull
    private static String getMainThreadForProcess(@NotNull ProcessModel process) {
        String name;
        if (process == null) {
            AtraceParser.$$$reportNull$$$0(9);
        }
        if ((name = process.getName()).startsWith("<")) {
            for (ThreadModel threads : process.getThreads()) {
                if (threads.getId() != process.getId()) continue;
                String string = threads.getName();
                if (string == null) {
                    AtraceParser.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        String string = name;
        if (string == null) {
            AtraceParser.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static int findRenderThreadId(@NotNull ProcessModel process) {
        if (process == null) {
            AtraceParser.$$$reportNull$$$0(12);
        }
        Optional<ThreadModel> renderThread = process.getThreads().stream().filter(thread2 -> thread2.getName().equalsIgnoreCase(RENDER_THREAD_NAME)).findFirst();
        return renderThread.map(ThreadModel::getId).orElse(Integer.MAX_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/atrace/AtraceParser";
                break;
            }
            case 3: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/atrace/AtraceParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadStateDataSeries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuThreadSliceInfoStates";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCpuUtilizationSeries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCpuUtilizationData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainThreadForProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseModelIfNeeded";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSelectProcess";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMainThreadForProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRenderThreadId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

