/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import org.jetbrains.annotations.NotNull;

public enum ProfilingTechnology {
    ART_SAMPLED("Java Method Sample Recording", "Samples Java code using Android Runtime"),
    ART_INSTRUMENTED("Java Method Trace Recording", "Instruments Java code using Android Runtime"),
    ART_UNSPECIFIED("Java Method Recording", "Profiles Java code using Android Runtime"),
    SIMPLEPERF("C/C++ Function Recording", "Samples native code using simpleperf"),
    ATRACE("System Trace Recording", "Traces Java and native code at the Android platform level");

    @NotNull
    private final String myName;
    @NotNull
    private final String myDescription;

    private ProfilingTechnology(String name, String description) {
        if (name == null) {
            ProfilingTechnology.$$$reportNull$$$0(0);
        }
        if (description == null) {
            ProfilingTechnology.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            ProfilingTechnology.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static ProfilingTechnology fromTypeAndMode(@NotNull CpuProfiler.CpuProfilerType type, @NotNull CpuProfiler.CpuProfilerMode mode) {
        if (type == null) {
            ProfilingTechnology.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            ProfilingTechnology.$$$reportNull$$$0(5);
        }
        switch (type) {
            case ART: {
                if (mode == CpuProfiler.CpuProfilerMode.SAMPLED) {
                    ProfilingTechnology profilingTechnology = ART_SAMPLED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(6);
                    }
                    return profilingTechnology;
                }
                if (mode == CpuProfiler.CpuProfilerMode.INSTRUMENTED) {
                    ProfilingTechnology profilingTechnology = ART_INSTRUMENTED;
                    if (profilingTechnology == null) {
                        ProfilingTechnology.$$$reportNull$$$0(7);
                    }
                    return profilingTechnology;
                }
                ProfilingTechnology profilingTechnology = ART_UNSPECIFIED;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(8);
                }
                return profilingTechnology;
            }
            case SIMPLEPERF: {
                ProfilingTechnology profilingTechnology = SIMPLEPERF;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(9);
                }
                return profilingTechnology;
            }
            case ATRACE: {
                ProfilingTechnology profilingTechnology = ATRACE;
                if (profilingTechnology == null) {
                    ProfilingTechnology.$$$reportNull$$$0(10);
                }
                return profilingTechnology;
            }
        }
        throw new IllegalStateException("Error while trying to get the name of an unknown profiling configuration");
    }

    @NotNull
    public static ProfilingTechnology fromConfig(@NotNull ProfilingConfiguration config) {
        if (config == null) {
            ProfilingTechnology.$$$reportNull$$$0(11);
        }
        ProfilingTechnology profilingTechnology = ProfilingTechnology.fromTypeAndMode(config.getProfilerType(), config.getMode());
        if (profilingTechnology == null) {
            ProfilingTechnology.$$$reportNull$$$0(12);
        }
        return profilingTechnology;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/ProfilingTechnology";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTypeAndMode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypeAndMode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

