/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.ProfilerTooltipView;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.CpuProfilerStageView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;

public class CpuThreadsTooltipView
extends ProfilerTooltipView {
    @NotNull
    private final CpuThreadsTooltip myTooltip;
    @NotNull
    private final ProfilerTimeline myTimeline;
    @NotNull
    private final JPanel myContent;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JLabel myState;
    @NotNull
    private final JLabel myDuration;
    @NotNull
    private final JPanel myUnavailableDetails;

    protected CpuThreadsTooltipView(@NotNull CpuProfilerStageView view, @NotNull CpuThreadsTooltip tooltip) {
        if (view == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(0);
        }
        if (tooltip == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(1);
        }
        super(view.getTimeline());
        this.myTimeline = view.getTimeline();
        this.myTooltip = tooltip;
        this.myContent = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)8)));
        this.myLabel = CpuThreadsTooltipView.createTooltipLabel();
        this.myState = CpuThreadsTooltipView.createTooltipLabel();
        this.myDuration = CpuThreadsTooltipView.createTooltipLabel();
        this.myUnavailableDetails = new JPanel((LayoutManager)new TabularLayout("*").setVGap(JBUI.scale((int)1)));
        tooltip.addDependency(this).onChange((Enum)CpuThreadsTooltip.Aspect.THREAD_STATE, this::stateChanged);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTooltip.removeDependencies(this);
    }

    private void addRow(JPanel parent, JComponent c) {
        int nextRow = parent.getComponentCount();
        parent.add((Component)c, new TabularLayout.Constraint(nextRow, 0));
    }

    private void stateChanged() {
        Range range = this.myTimeline.getTooltipRange();
        this.myContent.removeAll();
        if (range.isEmpty()) {
            this.addRow(this.myContent, this.myUnavailableDetails);
            return;
        }
        String title = this.myTooltip.getThreadName() != null ? this.myTooltip.getThreadName() : "CPU";
        this.myLabel.setText(String.format("Thread: %s", title));
        this.addRow(this.myContent, this.myLabel);
        if (this.myTooltip.getThreadState() != null) {
            this.myState.setText(CpuThreadsTooltipView.threadStateToString(this.myTooltip.getThreadState()));
            this.addRow(this.myContent, this.myState);
            if (this.myTooltip.getDurationUs() > 0L) {
                this.myDuration.setText(TimeFormatter.getSingleUnitDurationString((long)this.myTooltip.getDurationUs()));
                this.addRow(this.myContent, this.myDuration);
            }
            if (!CpuThreadsTooltipView.threadStateIsCaptured(this.myTooltip.getThreadState())) {
                this.addRow(this.myContent, this.myUnavailableDetails);
            }
        }
    }

    @Override
    @NotNull
    protected JComponent createTooltip() {
        JSeparator separator = new JSeparator(0);
        separator.setMinimumSize(separator.getPreferredSize());
        this.addRow(this.myUnavailableDetails, separator);
        JLabel unavailableLabel = new JLabel("Details Unavailable");
        unavailableLabel.setFont(ProfilerFonts.TOOLTIP_BODY_FONT);
        unavailableLabel.setForeground(ProfilerColors.TOOLTIP_LOW_CONTRAST);
        this.addRow(this.myUnavailableDetails, unavailableLabel);
        this.addRow(this.myContent, this.myUnavailableDetails);
        JPanel jPanel = this.myContent;
        if (jPanel == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static boolean threadStateIsCaptured(@NotNull CpuProfilerStage.ThreadState state) {
        if (state == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(3);
        }
        switch (state) {
            case RUNNING_CAPTURED: 
            case RUNNABLE_CAPTURED: 
            case SLEEPING_CAPTURED: 
            case DEAD_CAPTURED: 
            case WAITING_CAPTURED: 
            case WAITING_IO_CAPTURED: 
            case HAS_ACTIVITY: {
                return true;
            }
        }
        return false;
    }

    private static String threadStateToString(@NotNull CpuProfilerStage.ThreadState state) {
        if (state == null) {
            CpuThreadsTooltipView.$$$reportNull$$$0(4);
        }
        switch (state) {
            case RUNNING_CAPTURED: 
            case RUNNING: {
                return "Running";
            }
            case RUNNABLE_CAPTURED: {
                return "Runnable";
            }
            case SLEEPING_CAPTURED: 
            case SLEEPING: {
                return "Sleeping";
            }
            case DEAD_CAPTURED: 
            case DEAD: {
                return "Dead";
            }
            case WAITING_CAPTURED: 
            case WAITING: {
                return "Waiting";
            }
            case WAITING_IO_CAPTURED: {
                return "Waiting on IO";
            }
            case HAS_ACTIVITY: {
                return "Thread activity";
            }
            case NO_ACTIVITY: {
                return "No thread activity";
            }
        }
        return "Unknown";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsTooltipView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "threadStateIsCaptured";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "threadStateToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

