/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profilers.ProfilerTooltip;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadsTooltip
extends AspectModel<Aspect>
implements ProfilerTooltip {
    @NotNull
    private final CpuProfilerStage myStage;
    @Nullable
    private String myThreadName;
    @Nullable
    private DataSeries<CpuProfilerStage.ThreadState> mySeries;
    @Nullable
    private CpuProfilerStage.ThreadState myThreadState;
    private long myDurationUs;

    CpuThreadsTooltip(@NotNull CpuProfilerStage stage) {
        if (stage == null) {
            CpuThreadsTooltip.$$$reportNull$$$0(0);
        }
        this.myStage = stage;
        Range tooltipRange = stage.getStudioProfilers().getTimeline().getTooltipRange();
        tooltipRange.addDependency((AspectObserver)this).onChange((Enum)Range.Aspect.RANGE, this::updateThreadState);
    }

    @Override
    public void dispose() {
        this.myStage.getStudioProfilers().getTimeline().getTooltipRange().removeDependencies((AspectObserver)this);
    }

    private void updateThreadState() {
        this.myThreadState = null;
        this.myDurationUs = 0L;
        if (this.mySeries == null) {
            this.changed(Aspect.THREAD_STATE);
            return;
        }
        Range tooltipRange = this.myStage.getStudioProfilers().getTimeline().getTooltipRange();
        List series = this.mySeries.getDataForXRange(this.myStage.getStudioProfilers().getTimeline().getViewRange());
        int threadStateIndex = Collections.binarySearch(series, new SeriesData((long)tooltipRange.getMin(), null), Comparator.comparingDouble(seriesData -> seriesData.x));
        if (threadStateIndex < 0) {
            threadStateIndex = -threadStateIndex - 2;
        }
        if (threadStateIndex >= 0) {
            SeriesData currentState = (SeriesData)series.get(threadStateIndex);
            this.myThreadState = (CpuProfilerStage.ThreadState)((Object)currentState.value);
            if (threadStateIndex < series.size() - 1) {
                this.myDurationUs = ((SeriesData)series.get((int)(threadStateIndex + 1))).x - currentState.x;
            }
        }
        this.changed(Aspect.THREAD_STATE);
    }

    void setThread(@Nullable String threadName, @Nullable DataSeries<CpuProfilerStage.ThreadState> stateSeries) {
        this.myThreadName = threadName;
        this.mySeries = stateSeries;
        this.updateThreadState();
    }

    @Nullable
    public String getThreadName() {
        return this.myThreadName;
    }

    @Nullable
    CpuProfilerStage.ThreadState getThreadState() {
        return this.myThreadState;
    }

    public long getDurationUs() {
        return this.myDurationUs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stage", "com/android/tools/profilers/cpu/CpuThreadsTooltip", "<init>"));
    }

    public static enum Aspect {
        THREAD_STATE;

    }
}

