/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.android.tools.profilers.DragAndDropListModel;
import com.android.tools.profilers.DragAndDropModelListElement;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ImportedTraceThreadDataSeries;
import com.android.tools.profilers.cpu.MergeCaptureDataSeries;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuThreadsModel
extends DragAndDropListModel<RangedCpuThread> {
    @NotNull
    private static final String RENDER_THREAD_NAME = "RenderThread";
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Common.Session mySession;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    protected final HashMap<Integer, RangedCpuThread> myThreadIdToCpuThread;

    public CpuThreadsModel(@NotNull Range range, @NotNull CpuProfilerStage stage, @NotNull Common.Session session) {
        if (range == null) {
            CpuThreadsModel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuThreadsModel.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CpuThreadsModel.$$$reportNull$$$0(2);
        }
        this.myRange = range;
        this.myStage = stage;
        this.mySession = session;
        this.myAspectObserver = new AspectObserver();
        this.myThreadIdToCpuThread = new HashMap();
        this.myRange.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::rangeChanged);
        this.rangeChanged();
        this.sortElements();
    }

    public void rangeChanged() {
        if (this.myStage.isImportTraceMode()) {
            this.contentsChanged();
            return;
        }
        CpuProfiler.GetThreadsRequest.Builder request = CpuProfiler.GetThreadsRequest.newBuilder().setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)this.myRange.getMax()));
        CpuServiceGrpc.CpuServiceBlockingStub client = this.myStage.getStudioProfilers().getClient().getCpuClient();
        CpuProfiler.GetThreadsResponse response = client.getThreads(request.build());
        HashMap<Integer, RangedCpuThread> requestedThreadsRangedCpuThreads = new HashMap<Integer, RangedCpuThread>();
        for (CpuProfiler.GetThreadsResponse.Thread newThread : response.getThreadsList()) {
            RangedCpuThread cpuThread = this.myThreadIdToCpuThread.computeIfAbsent(newThread.getTid(), id -> new RangedCpuThread(this.myRange, newThread.getTid(), newThread.getName()));
            requestedThreadsRangedCpuThreads.put(newThread.getTid(), cpuThread);
        }
        for (int i = 0; i < this.getSize(); ++i) {
            RangedCpuThread element = (RangedCpuThread)this.getElementAt(i);
            if (requestedThreadsRangedCpuThreads.containsKey(element.getThreadId())) {
                requestedThreadsRangedCpuThreads.remove(element.getThreadId());
                continue;
            }
            this.removeOrderedElement(element);
            --i;
        }
        for (RangedCpuThread element : requestedThreadsRangedCpuThreads.values()) {
            this.insertOrderedElement(element);
        }
        this.contentsChanged();
    }

    private void sortElements() {
        Object[] elements = this.toArray();
        this.clearOrderedElements();
        Arrays.sort(elements, (a, b) -> {
            RangedCpuThread first = (RangedCpuThread)a;
            RangedCpuThread second = (RangedCpuThread)b;
            if (first.isMainThread()) {
                return -1;
            }
            if (second.isMainThread()) {
                return 1;
            }
            assert (first.getName() != null);
            assert (second.getName() != null);
            boolean firstIsRenderThread = first.getName().equals(RENDER_THREAD_NAME);
            boolean secondIsRenderThread = second.getName().equals(RENDER_THREAD_NAME);
            if (firstIsRenderThread && secondIsRenderThread) {
                return first.getThreadId() - second.getThreadId();
            }
            if (firstIsRenderThread) {
                return -1;
            }
            if (secondIsRenderThread) {
                return 1;
            }
            int nameResult = first.getName().compareTo(second.getName());
            if (nameResult == 0) {
                return first.getThreadId() - second.getThreadId();
            }
            return nameResult;
        });
        for (Object element : elements) {
            RangedCpuThread rangedCpuThread = (RangedCpuThread)element;
            this.insertOrderedElement(rangedCpuThread);
        }
    }

    void buildImportedTraceThreads(@NotNull CpuCapture capture) {
        if (capture == null) {
            CpuThreadsModel.$$$reportNull$$$0(3);
        }
        List<RangedCpuThread> threads = capture.getThreads().stream().map(thread2 -> new RangedCpuThread(this.myRange, thread2.getId(), thread2.getName(), capture)).collect(Collectors.toList());
        threads.forEach(this::insertOrderedElement);
        this.sortElements();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "capture";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadsModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "buildImportedTraceThreads";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class RangedCpuThread
    implements DragAndDropModelListElement {
        private final int myThreadId;
        private final boolean myIsMainThread;
        private final String myName;
        private final Range myRange;
        private final StateChartModel<CpuProfilerStage.ThreadState> myModel;
        private final DataSeries<CpuProfilerStage.ThreadState> mySeries;
        private final AtraceDataSeries<CpuProfilerStage.ThreadState> myAtraceDataSeries;

        public RangedCpuThread(Range range, int threadId, String name) {
            this(range, threadId, name, null);
        }

        public RangedCpuThread(Range range, int threadId, @Nullable String name, CpuCapture capture) {
            this.myRange = range;
            this.myThreadId = threadId;
            this.myName = name;
            this.myModel = new StateChartModel();
            if (capture == null) {
                ThreadStateDataSeries threadStateDataSeries = new ThreadStateDataSeries(CpuThreadsModel.this.myStage.getStudioProfilers().getClient().getCpuClient(), CpuThreadsModel.this.mySession, this.myThreadId);
                this.myAtraceDataSeries = new AtraceDataSeries(CpuThreadsModel.this.myStage, atraceCapture -> atraceCapture.getThreadStatesForThread(this.myThreadId));
                this.mySeries = new MergeCaptureDataSeries<CpuProfilerStage.ThreadState>(CpuThreadsModel.this.myStage, threadStateDataSeries, this.myAtraceDataSeries);
                this.myIsMainThread = this.myThreadId == CpuThreadsModel.this.mySession.getPid();
            } else {
                if (capture.getType() == CpuProfiler.CpuProfilerType.ATRACE) {
                    this.myAtraceDataSeries = new AtraceDataSeries<CpuProfilerStage.ThreadState>(CpuThreadsModel.this.myStage, atraceCapture -> atraceCapture.getThreadStatesForThread(this.myThreadId));
                    this.mySeries = this.myAtraceDataSeries;
                } else {
                    this.myAtraceDataSeries = null;
                    this.mySeries = new ImportedTraceThreadDataSeries(capture, this.myThreadId);
                }
                this.myIsMainThread = this.myThreadId == capture.getMainThreadId();
            }
            this.myModel.addSeries(new RangedSeries(this.myRange, this.mySeries));
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        public String getName() {
            return this.myName;
        }

        public StateChartModel<CpuProfilerStage.ThreadState> getModel() {
            return this.myModel;
        }

        public DataSeries<CpuProfilerStage.ThreadState> getStateSeries() {
            return this.mySeries;
        }

        @Override
        public int getId() {
            return this.myThreadId;
        }

        public boolean isMainThread() {
            return this.myIsMainThread;
        }
    }
}

