/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.stdui.menu.CommonSeparatorUI;
import com.android.tools.adtui.util.SwingUtil;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.JComboBoxView;
import com.android.tools.profilers.ProfilerCombobox;
import com.android.tools.profilers.ProfilerComboboxCellRenderer;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.ProfilingConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.SeparatorUI;
import org.jetbrains.annotations.NotNull;

public class CpuProfilingConfigurationView {
    static final ProfilingConfiguration EDIT_CONFIGURATIONS_ENTRY = new ProfilingConfiguration("Edit Configurations...", CpuProfiler.CpuProfilerType.UNSPECIFIED_PROFILER, CpuProfiler.CpuProfilerMode.UNSPECIFIED_MODE);
    static final ProfilingConfiguration CONFIG_SEPARATOR_ENTRY = new ProfilingConfiguration("Configuration Separator Entry", CpuProfiler.CpuProfilerType.UNSPECIFIED_PROFILER, CpuProfiler.CpuProfilerMode.UNSPECIFIED_MODE);
    private final ProfilingConfiguration API_INITIATED_TRACING_PROFILING_CONFIG;
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final IdeProfilerComponents myIdeProfilerComponents;
    @NotNull
    private final JComboBox<ProfilingConfiguration> myComboBox;

    public CpuProfilingConfigurationView(@NotNull CpuProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (stage == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(1);
        }
        this.API_INITIATED_TRACING_PROFILING_CONFIG = new ProfilingConfiguration("Debug API (Java)", CpuProfiler.CpuProfilerType.ART, CpuProfiler.CpuProfilerMode.INSTRUMENTED);
        this.myStage = stage;
        this.myIdeProfilerComponents = ideProfilerComponents;
        this.myComboBox = new ProfilerCombobox<ProfilingConfiguration>(new DefaultComboBoxModel<ProfilingConfiguration>(){

            @Override
            public void setSelectedItem(Object item) {
                if (item == CONFIG_SEPARATOR_ENTRY) {
                    return;
                }
                super.setSelectedItem(item);
            }
        });
        this.configureProfilingConfigCombo();
    }

    @NotNull
    public JComponent getComponent() {
        JComboBox<ProfilingConfiguration> jComboBox = this.myComboBox;
        if (jComboBox == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(2);
        }
        return jComboBox;
    }

    @VisibleForTesting
    @NotNull
    public ProfilingConfiguration getProfilingConfiguration() {
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            ProfilingConfiguration profilingConfiguration = this.API_INITIATED_TRACING_PROFILING_CONFIG;
            if (profilingConfiguration == null) {
                CpuProfilingConfigurationView.$$$reportNull$$$0(3);
            }
            return profilingConfiguration;
        }
        ProfilingConfiguration profilingConfiguration = this.myStage.getProfilerConfigModel().getProfilingConfiguration();
        if (profilingConfiguration == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(4);
        }
        return profilingConfiguration;
    }

    @VisibleForTesting
    void setProfilingConfiguration(@NotNull ProfilingConfiguration mode) {
        if (mode == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(5);
        }
        if (mode == EDIT_CONFIGURATIONS_ENTRY) {
            this.openProfilingConfigurationsDialog();
        } else if (mode != CONFIG_SEPARATOR_ENTRY) {
            this.myStage.getProfilerConfigModel().setProfilingConfiguration(mode);
        }
    }

    @VisibleForTesting
    void openProfilingConfigurationsDialog() {
        Consumer<ProfilingConfiguration> dialogCallback = configuration -> {
            if (configuration != null) {
                this.setProfilingConfiguration((ProfilingConfiguration)configuration);
            }
        };
        Common.Device selectedDevice = this.myStage.getStudioProfilers().getDevice();
        int deviceFeatureLevel = selectedDevice != null ? selectedDevice.getFeatureLevel() : 0;
        this.myIdeProfilerComponents.openCpuProfilingConfigurationsDialog(this.myStage.getProfilerConfigModel(), deviceFeatureLevel, dialogCallback);
        this.myStage.getStudioProfilers().getIdeServices().getFeatureTracker().trackOpenProfilingConfigDialog();
    }

    @NotNull
    @VisibleForTesting
    List<ProfilingConfiguration> getProfilingConfigurations() {
        ArrayList<ProfilingConfiguration> configs = new ArrayList<ProfilingConfiguration>();
        if (this.myStage.isApiInitiatedTracingInProgress()) {
            configs.add(this.API_INITIATED_TRACING_PROFILING_CONFIG);
            ArrayList<ProfilingConfiguration> arrayList = configs;
            if (arrayList == null) {
                CpuProfilingConfigurationView.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        configs.add(EDIT_CONFIGURATIONS_ENTRY);
        List<ProfilingConfiguration> customEntries = this.myStage.getProfilerConfigModel().getCustomProfilingConfigurationsDeviceFiltered();
        if (!customEntries.isEmpty()) {
            configs.add(CONFIG_SEPARATOR_ENTRY);
            configs.addAll(customEntries);
        }
        configs.add(CONFIG_SEPARATOR_ENTRY);
        configs.addAll(this.myStage.getProfilerConfigModel().getDefaultProfilingConfigurations());
        ArrayList<ProfilingConfiguration> arrayList = configs;
        if (arrayList == null) {
            CpuProfilingConfigurationView.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void configureProfilingConfigCombo() {
        JComboBoxView<ProfilingConfiguration, CpuProfilerAspect> profilingConfiguration = new JComboBoxView<ProfilingConfiguration, CpuProfilerAspect>(this.myComboBox, this.myStage.getAspect(), CpuProfilerAspect.PROFILING_CONFIGURATION, this::getProfilingConfigurations, this::getProfilingConfiguration, this::setProfilingConfiguration);
        profilingConfiguration.bind();
        SwingUtil.doNotSelectItems(this.myComboBox, e -> e == CONFIG_SEPARATOR_ENTRY);
        this.myComboBox.setRenderer((ListCellRenderer<ProfilingConfiguration>)((Object)new ProfilingConfigurationRenderer()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/cpu/CpuProfilingConfigurationView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/cpu/CpuProfilingConfigurationView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilingConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProfilingConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProfilingConfigurationRenderer
    extends ProfilerComboboxCellRenderer<ProfilingConfiguration> {
        private ProfilingConfigurationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (value == CONFIG_SEPARATOR_ENTRY) {
                JSeparator separator = new JSeparator();
                separator.setUI((SeparatorUI)new CommonSeparatorUI());
                return separator;
            }
            return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends ProfilingConfiguration> list, ProfilingConfiguration value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ProfilingConfigurationRenderer.$$$reportNull$$$0(0);
            }
            this.append(value.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/profilers/cpu/CpuProfilingConfigurationView$ProfilingConfigurationRenderer", "customizeCellRenderer"));
        }
    }
}

