/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.cpu.AtraceDataSeries;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerStage;
import com.android.tools.profilers.cpu.atrace.AtraceCpuCapture;
import com.android.tools.profilers.cpu.atrace.AtraceFrame;
import com.android.tools.profilers.cpu.atrace.AtraceFrameFilterConfig;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultListModel;
import org.jetbrains.annotations.NotNull;

public class CpuFramesModel
extends DefaultListModel<FrameState> {
    @NotNull
    private final CpuProfilerStage myStage;
    @NotNull
    private final Range myRange;
    @NotNull
    private final AspectObserver myAspectObserver;
    public static final long SLOW_FRAME_RATE_US = TimeUnit.MILLISECONDS.toMicros(17L);

    public CpuFramesModel(@NotNull Range range, @NotNull CpuProfilerStage stage) {
        if (range == null) {
            CpuFramesModel.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CpuFramesModel.$$$reportNull$$$0(1);
        }
        this.myRange = range;
        this.myStage = stage;
        this.myAspectObserver = new AspectObserver();
        this.myStage.getAspect().addDependency(this.myAspectObserver).onChange((Enum)CpuProfilerAspect.CAPTURE_SELECTION, this::captureStateChanged);
        range.addDependency(this.myAspectObserver).onChange((Enum)Range.Aspect.RANGE, this::contentsChanged);
    }

    private void captureStateChanged() {
        this.removeAllElements();
        CpuCapture capture = this.myStage.getCapture();
        if (capture instanceof AtraceCpuCapture) {
            AtraceCpuCapture atraceCapture = (AtraceCpuCapture)capture;
            this.addElement(new FrameState("Main", new AtraceFrameFilterConfig("Choreographer#doFrame", capture.getMainThreadId(), SLOW_FRAME_RATE_US), this.myStage));
            this.addElement(new FrameState("Render", new AtraceFrameFilterConfig("(DrawFrame|doFrame|queueBuffer)", atraceCapture.getRenderThreadId(), SLOW_FRAME_RATE_US), this.myStage));
        }
        this.contentsChanged();
    }

    private void contentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/cpu/CpuFramesModel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class FrameState {
        @NotNull
        private final AtraceDataSeries<AtraceFrame> myAtraceCpuStateDataSeries;
        @NotNull
        private final StateChartModel<AtraceFrame> myModel;
        private final String myThreadName;
        private final int myThreadId;

        public FrameState(@NotNull String threadName, @NotNull AtraceFrameFilterConfig filter, CpuProfilerStage stage) {
            if (filter == null) {
                FrameState.$$$reportNull$$$0(0);
            }
            if (stage == null) {
                FrameState.$$$reportNull$$$0(1);
            }
            this.myModel = new StateChartModel();
            this.myThreadName = threadName;
            this.myThreadId = filter.getThreadId();
            this.myAtraceCpuStateDataSeries = new AtraceDataSeries(stage, capture -> capture.getFrames(filter));
            this.myModel.addSeries(new RangedSeries(CpuFramesModel.this.myRange, this.myAtraceCpuStateDataSeries));
        }

        public String getThreadName() {
            return this.myThreadName;
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        @NotNull
        public AtraceDataSeries<AtraceFrame> getSeries() {
            AtraceDataSeries<AtraceFrame> atraceDataSeries = this.myAtraceCpuStateDataSeries;
            if (atraceDataSeries == null) {
                FrameState.$$$reportNull$$$0(2);
            }
            return atraceDataSeries;
        }

        @NotNull
        public StateChartModel<AtraceFrame> getModel() {
            StateChartModel<AtraceFrame> stateChartModel = this.myModel;
            if (stateChartModel == null) {
                FrameState.$$$reportNull$$$0(3);
            }
            return stateChartModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stage";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/profilers/cpu/CpuFramesModel$FrameState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/profilers/cpu/CpuFramesModel$FrameState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeries";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

