/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerAction;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerContextMenu;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.ProfilerMonitorView;
import com.android.tools.profilers.ProfilerScrollbar;
import com.android.tools.profilers.ProfilerTimeline;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StudioMonitorStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.ViewBinder;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuMonitorTooltip;
import com.android.tools.profilers.cpu.CpuMonitorTooltipView;
import com.android.tools.profilers.cpu.CpuMonitorView;
import com.android.tools.profilers.energy.EnergyMonitor;
import com.android.tools.profilers.energy.EnergyMonitorTooltip;
import com.android.tools.profilers.energy.EnergyMonitorTooltipView;
import com.android.tools.profilers.energy.EnergyMonitorView;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.event.EventMonitorView;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.android.tools.profilers.memory.MemoryMonitor;
import com.android.tools.profilers.memory.MemoryMonitorTooltip;
import com.android.tools.profilers.memory.MemoryMonitorTooltipView;
import com.android.tools.profilers.memory.MemoryMonitorView;
import com.android.tools.profilers.network.NetworkMonitor;
import com.android.tools.profilers.network.NetworkMonitorTooltip;
import com.android.tools.profilers.network.NetworkMonitorTooltipView;
import com.android.tools.profilers.network.NetworkMonitorView;
import com.android.tools.profilers.stacktrace.ContextMenuItem;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StudioMonitorStageView
extends StageView<StudioMonitorStage> {
    @NotNull
    private final List<ProfilerMonitorView> myViews;

    public StudioMonitorStageView(@NotNull StudioProfilersView profilersView, @NotNull StudioMonitorStage stage) {
        if (profilersView == null) {
            StudioMonitorStageView.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            StudioMonitorStageView.$$$reportNull$$$0(1);
        }
        super(profilersView, stage);
        ViewBinder binder = new ViewBinder();
        binder.bind(NetworkMonitor.class, NetworkMonitorView::new);
        binder.bind(CpuMonitor.class, CpuMonitorView::new);
        binder.bind(MemoryMonitor.class, MemoryMonitorView::new);
        binder.bind(EventMonitor.class, EventMonitorView::new);
        boolean isEnergyProfilerEnabled = ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureConfig().isEnergyProfilerEnabled();
        if (isEnergyProfilerEnabled) {
            binder.bind(EnergyMonitor.class, EnergyMonitorView::new);
        }
        ProfilerScrollbar sb = new ProfilerScrollbar(this.getTimeline(), this.getComponent());
        this.getComponent().add((Component)((Object)sb), "South");
        JPanel topPanel = new JPanel((LayoutManager)new TabularLayout("*", "*,Fit-"));
        topPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        TabularLayout layout = new TabularLayout("*");
        JPanel monitors = new JPanel((LayoutManager)layout);
        ProfilerTimeline timeline = stage.getStudioProfilers().getTimeline();
        this.getTooltipPanel().setLayout(new FlowLayout(0, 0, 0));
        RangeTooltipComponent tooltip = new RangeTooltipComponent(timeline.getTooltipRange(), timeline.getViewRange(), timeline.getDataRange(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> true);
        this.getTooltipBinder().bind(NetworkMonitorTooltip.class, NetworkMonitorTooltipView::new);
        this.getTooltipBinder().bind(CpuMonitorTooltip.class, CpuMonitorTooltipView::new);
        this.getTooltipBinder().bind(MemoryMonitorTooltip.class, MemoryMonitorTooltipView::new);
        this.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        if (isEnergyProfilerEnabled) {
            this.getTooltipBinder().bind(EnergyMonitorTooltip.class, EnergyMonitorTooltipView::new);
        }
        this.myViews = new ArrayList<ProfilerMonitorView>(stage.getMonitors().size());
        int rowIndex = 0;
        for (final ProfilerMonitor monitor : stage.getMonitors()) {
            ProfilerMonitorView view = (ProfilerMonitorView)((Object)binder.build(profilersView, monitor));
            view.registerTooltip(tooltip, stage);
            JComponent component = view.getComponent();
            component.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        StudioMonitorStageView.this.expandMonitor(monitor);
                    }
                }
            });
            component.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                    if (keyCode == 10 && monitor.isFocused()) {
                        StudioMonitorStageView.this.expandMonitor(monitor);
                    }
                }
            });
            IdeProfilerComponents ideProfilerComponents = this.getIdeComponents();
            ContextMenuInstaller contextMenuInstaller = ideProfilerComponents.createContextMenuInstaller();
            ProfilerAction.Builder builder = new ProfilerAction.Builder("Open " + monitor.getName());
            ProfilerAction action = builder.setActionRunnable(() -> this.expandMonitor(monitor)).setKeyStrokes(KeyStroke.getKeyStroke(10, 0)).setContainerComponent(component).build();
            ProfilerContextMenu.createIfAbsent(component).add(action);
            contextMenuInstaller.installGenericContextMenu(component, action);
            contextMenuInstaller.installGenericContextMenu(component, ContextMenuItem.SEPARATOR);
            profilersView.installCommonMenuItems(component);
            int weight = (int)(view.getVerticalWeight() * 100.0f);
            layout.setRowSizing(rowIndex, weight > 0 ? weight + "*" : "Fit-");
            monitors.add((Component)component, new TabularLayout.Constraint(rowIndex, 0));
            ++rowIndex;
            this.myViews.add(view);
        }
        StudioProfilers profilers = stage.getStudioProfilers();
        JComponent timeAxis = this.buildTimeAxis(profilers);
        topPanel.add((Component)tooltip, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)monitors, new TabularLayout.Constraint(0, 0));
        topPanel.add((Component)timeAxis, new TabularLayout.Constraint(1, 0));
        this.getComponent().add((Component)topPanel, "Center");
    }

    private void expandMonitor(ProfilerMonitor monitor) {
        ((StudioMonitorStage)((Object)this.getStage())).getStudioProfilers().getIdeServices().getFeatureTracker().trackSelectMonitor();
        monitor.expand();
    }

    @Override
    public JComponent getToolbar() {
        return new JPanel();
    }

    @Override
    public boolean needsProcessSelection() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profilersView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stage";
                break;
            }
        }
        objectArray[1] = "com/android/tools/profilers/StudioMonitorStageView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

