/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfilers;
import org.jetbrains.annotations.NotNull;

public class NullMonitorStage
extends Stage {
    private Type myType;
    private final AspectModel<Aspect> myAspect;

    public NullMonitorStage(@NotNull StudioProfilers profiler) {
        if (profiler == null) {
            NullMonitorStage.$$$reportNull$$$0(0);
        }
        super(profiler);
        this.myAspect = new AspectModel();
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.DEVICES, this::updateType);
        this.updateType();
    }

    public AspectModel<Aspect> getAspect() {
        return this.myAspect;
    }

    private void updateType() {
        Common.Device device = this.getStudioProfilers().getDevice();
        if (device == null) {
            this.myType = Type.NO_DEVICE;
        } else {
            try {
                int deviceFeatureLevel = device.getFeatureLevel();
                this.myType = deviceFeatureLevel < 21 ? Type.UNSUPPORTED_DEVICE : Type.NO_DEBUGGABLE_PROCESS;
            }
            catch (NumberFormatException e) {
                this.myType = Type.UNSUPPORTED_DEVICE;
            }
        }
        this.myAspect.changed((Enum)Aspect.NULL_MONITOR_TYPE);
    }

    public Type getType() {
        return this.myType;
    }

    @Override
    public void enter() {
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(((Object)((Object)this)).getClass());
    }

    @Override
    public void exit() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profiler", "com/android/tools/profilers/NullMonitorStage", "<init>"));
    }

    static enum Aspect {
        NULL_MONITOR_TYPE;

    }

    static enum Type {
        NO_DEVICE,
        NO_DEBUGGABLE_PROCESS,
        UNSUPPORTED_DEVICE;

    }
}

