/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.AspectObserver;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JComboBox;

public class JComboBoxView<T, A extends Enum<A>>
implements ItemListener {
    private final Supplier<List<T>> myList;
    private final Supplier<T> myGet;
    private final Consumer<T> mySet;
    private final JComboBox<T> myCombo;
    private final AspectModel<A> myObject;
    private final A myAspect;
    private final AspectObserver myAspectObserver = new AspectObserver();
    private boolean myIgnoreEvents;

    public JComboBoxView(JComboBox<T> combo, AspectModel<A> object, A aspect, Supplier<List<T>> list, Supplier<T> get, Consumer<T> set) {
        this.myList = list;
        this.myGet = get;
        this.mySet = set;
        this.myCombo = combo;
        this.myObject = object;
        this.myAspect = aspect;
    }

    public void bind() {
        this.myCombo.addItemListener(this);
        this.myObject.addDependency(this.myAspectObserver).onChange(this.myAspect, this::changed);
        this.changed();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1 && !this.myIgnoreEvents) {
            Object item = event.getItem();
            this.mySet.accept(item);
        }
    }

    private void changed() {
        List<T> list = this.myList.get();
        T selected = this.myGet.get();
        this.myIgnoreEvents = true;
        this.myCombo.removeAllItems();
        if (list.isEmpty()) {
            this.myCombo.addItem(null);
        } else {
            for (T t : list) {
                this.myCombo.addItem(t);
            }
        }
        this.myCombo.setSelectedItem(selected);
        this.myIgnoreEvents = false;
    }
}

