/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.energy;

import com.android.tools.profiler.proto.NetworkProfiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface PowerProfile {
    public static final String GPS_PROVIDER = "gps";
    public static final String NETWORK_PROVIDER = "network";
    public static final String PASSIVE_PROVIDER = "passive";

    public int getCpuUsage(@NotNull CpuCoreUsage[] var1);

    public int getNetworkUsage(@NotNull NetworkStats var1);

    public int getLocationUsage(@NotNull LocationStats var1);

    public static final class LocationStats {
        public final LocationType myLocationType;
        public final long myDurationNs;
        public final long mySampleIntervalNs;

        /*
         * WARNING - void declaration
         */
        public LocationStats(@NotNull LocationType type, long durationNs, long l) {
            void sampleIntervalNs;
            if (type == null) {
                LocationStats.$$$reportNull$$$0(0);
            }
            this.myLocationType = type;
            this.myDurationNs = durationNs;
            this.mySampleIntervalNs = sampleIntervalNs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/datastore/energy/PowerProfile$LocationStats", "<init>"));
        }
    }

    public static final class LocationEvent {
        public final int myEventId;
        public final LocationType myLocationType;

        public LocationEvent(int id, @NotNull LocationType type) {
            if (type == null) {
                LocationEvent.$$$reportNull$$$0(0);
            }
            this.myEventId = id;
            this.myLocationType = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/datastore/energy/PowerProfile$LocationEvent", "<init>"));
        }
    }

    public static final class NetworkStats {
        public final NetworkType myNetworkType;
        public final long myReceivingBps;
        public final long mySendingBps;

        public NetworkStats(NetworkType type, long receivingBps, long sendingBps) {
            this.myNetworkType = type;
            this.myReceivingBps = receivingBps;
            this.mySendingBps = sendingBps;
        }
    }

    public static final class CpuCoreUsage {
        public final double myAppUsage;
        public final double myCoreUsage;
        public final int myCoreId;
        public final int myMinFrequencyKhz;
        public final int myMaxFrequencyKhz;
        public final int myFrequencyKhz;
        public final boolean myIsLittleCore;

        public CpuCoreUsage(int coreId, double appUsage, double coreUsage, int minFrequencyKhz, int maxFrequencyKhz, int frequencyKhz, boolean isLittleCore) {
            this.myCoreId = coreId;
            this.myAppUsage = appUsage;
            this.myCoreUsage = coreUsage;
            this.myMinFrequencyKhz = minFrequencyKhz;
            this.myMaxFrequencyKhz = maxFrequencyKhz;
            this.myFrequencyKhz = frequencyKhz;
            this.myIsLittleCore = isLittleCore;
        }
    }

    public static final class DefaultPowerProfile
    implements PowerProfile {
        static final int MIN_CORE_FREQ_KHZ = 300000;
        static final int MAX_BIG_CORE_FREQ_KHZ = 2457600;
        static final int MAX_LITTLE_CORE_FREQ_KHZ = 0x1D0100;

        @Override
        public int getCpuUsage(@NotNull CpuCoreUsage[] usages) {
            if (usages == null) {
                DefaultPowerProfile.$$$reportNull$$$0(0);
            }
            if (usages.length == 0) {
                return 0;
            }
            double totalMilliAmps = 0.0;
            List<CpuCoreUsage> usagesList = Arrays.asList(usages);
            Collections.sort(usagesList, Comparator.comparingInt(o -> o.myMaxFrequencyKhz));
            boolean lowerClusterActivationAdded = false;
            boolean higherClusterActivationAdded = false;
            boolean cpuActivationAdded = false;
            for (CpuCoreUsage core : usagesList) {
                double fMhz = DefaultPowerProfile.renormalizeFrequency(core, core.myIsLittleCore ? 0x1D0100 : 2457600);
                double f2 = fMhz * fMhz;
                double f3 = f2 * fMhz;
                if (core.myAppUsage > 0.0) {
                    if (!cpuActivationAdded) {
                        cpuActivationAdded = true;
                        totalMilliAmps += 17.757;
                    }
                    if (core.myIsLittleCore && !lowerClusterActivationAdded) {
                        lowerClusterActivationAdded = true;
                        totalMilliAmps += 6.478;
                    } else if (!core.myIsLittleCore && !higherClusterActivationAdded) {
                        higherClusterActivationAdded = true;
                        totalMilliAmps += 6.141;
                    }
                }
                if (core.myIsLittleCore) {
                    totalMilliAmps += (5.79689E-9 * f3 - 8.31587E-6 * f2 + 0.0109841 * fMhz + 0.513398) * core.myAppUsage * core.myCoreUsage;
                    continue;
                }
                totalMilliAmps += (2.48408E-8 * f3 - 4.68129E-5 * f2 + 0.0551123 * fMhz - 1.96322) * core.myAppUsage * core.myCoreUsage;
            }
            return (int)totalMilliAmps;
        }

        @Override
        public int getNetworkUsage(@NotNull NetworkStats networkStats) {
            if (networkStats == null) {
                DefaultPowerProfile.$$$reportNull$$$0(1);
            }
            if (networkStats.myNetworkType != NetworkType.WIFI && networkStats.myNetworkType != NetworkType.RADIO) {
                return 0;
            }
            if (networkStats.myReceivingBps == 0L && networkStats.mySendingBps == 0L) {
                return 0;
            }
            int usage = 0;
            if (networkStats.myReceivingBps > 0L) {
                usage += networkStats.myNetworkType == NetworkType.WIFI ? DefaultPowerProfile.fitBps(1.0, 99.0, networkStats.myReceivingBps, 1000000L) : DefaultPowerProfile.fitBps(10.0, 40.0, networkStats.myReceivingBps, 200000L);
            }
            if (networkStats.mySendingBps > 0L) {
                usage += networkStats.myNetworkType == NetworkType.WIFI ? DefaultPowerProfile.fitBps(1.0, 249.0, networkStats.mySendingBps, 500000L) : DefaultPowerProfile.fitBps(10.0, 190.0, networkStats.mySendingBps, 200000L);
            }
            return usage;
        }

        @Override
        public int getLocationUsage(@NotNull LocationStats locationStats) {
            if (locationStats == null) {
                DefaultPowerProfile.$$$reportNull$$$0(2);
            }
            switch (locationStats.myLocationType) {
                case GPS: {
                    return (int)(90.0 * (double)locationStats.myDurationNs / (double)locationStats.mySampleIntervalNs);
                }
                case GPS_ACQUIRE: {
                    return 90;
                }
                case NETWORK: {
                    return (int)(30.0 * (double)locationStats.myDurationNs / (double)locationStats.mySampleIntervalNs);
                }
            }
            return 0;
        }

        @VisibleForTesting
        static double renormalizeFrequency(@NotNull CpuCoreUsage core, int maxFrequencyKhz) {
            if (core == null) {
                DefaultPowerProfile.$$$reportNull$$$0(3);
            }
            double clampedFreq = Ints.constrainToRange((int)core.myFrequencyKhz, (int)core.myMinFrequencyKhz, (int)core.myMaxFrequencyKhz);
            return ((clampedFreq - (double)core.myMinFrequencyKhz) / (double)(core.myMaxFrequencyKhz - core.myMinFrequencyKhz) * (double)(maxFrequencyKhz - 300000) + 300000.0) * 0.001;
        }

        static int fitBps(double base, double scale, long bps, long normalizer) {
            return (int)(base + scale * (double)Longs.constrainToRange((long)bps, (long)0L, (long)normalizer) / (double)normalizer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "networkStats";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locationStats";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "core";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/datastore/energy/PowerProfile$DefaultPowerProfile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCpuUsage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNetworkUsage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLocationUsage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renormalizeFrequency";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum LocationType {
        NONE,
        PASSIVE,
        NETWORK,
        GPS_ACQUIRE,
        GPS;


        @NotNull
        public static LocationType from(@NotNull String protoLocationProvider) {
            if (protoLocationProvider == null) {
                LocationType.$$$reportNull$$$0(0);
            }
            switch (protoLocationProvider) {
                case "gps": {
                    LocationType locationType = GPS;
                    if (locationType == null) {
                        LocationType.$$$reportNull$$$0(1);
                    }
                    return locationType;
                }
                case "network": {
                    LocationType locationType = NETWORK;
                    if (locationType == null) {
                        LocationType.$$$reportNull$$$0(2);
                    }
                    return locationType;
                }
                case "passive": {
                    LocationType locationType = PASSIVE;
                    if (locationType == null) {
                        LocationType.$$$reportNull$$$0(3);
                    }
                    return locationType;
                }
            }
            LocationType locationType = NONE;
            if (locationType == null) {
                LocationType.$$$reportNull$$$0(4);
            }
            return locationType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "protoLocationProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/datastore/energy/PowerProfile$LocationType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/datastore/energy/PowerProfile$LocationType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum NetworkType {
        WIFI,
        RADIO,
        NONE;


        @NotNull
        public static NetworkType from(NetworkProfiler.ConnectivityData.NetworkType protoNetworkType) {
            switch (protoNetworkType) {
                case MOBILE: {
                    NetworkType networkType = RADIO;
                    if (networkType == null) {
                        NetworkType.$$$reportNull$$$0(0);
                    }
                    return networkType;
                }
                case WIFI: {
                    NetworkType networkType = WIFI;
                    if (networkType == null) {
                        NetworkType.$$$reportNull$$$0(1);
                    }
                    return networkType;
                }
            }
            NetworkType networkType = NONE;
            if (networkType == null) {
                NetworkType.$$$reportNull$$$0(2);
            }
            return networkType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/datastore/energy/PowerProfile$NetworkType", "from"));
        }
    }
}

