/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EnergyProfiler;
import com.android.tools.profiler.protobuf3jarjar.InvalidProtocolBufferException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EnergyTable
extends DataStoreTable<EventStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            EnergyTable.$$$reportNull$$$0(0);
        }
        super.initialize(connection);
        try {
            this.createTable("Energy_Sample", "Session INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "Sample BLOB NOT NULL");
            this.createTable("Energy_Event", "Session INTEGER NOT NULL", "Id INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "IsTerminal BIT NOT NULL", "Event BLOB NOT NULL");
            this.createUniqueIndex("Energy_Sample", "Session", "Timestamp");
            this.createUniqueIndex("Energy_Event", "Session", "Id", "Timestamp");
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(EventStatements.INSERT_SAMPLE, "INSERT OR REPLACE INTO Energy_Sample (Session, Timestamp, Sample) values (?, ?, ?)");
            this.createStatement(EventStatements.INSERT_EVENT, "INSERT OR REPLACE INTO Energy_Event (Session, Id, Timestamp, IsTerminal, Event) values (?, ?, ?, ?, ?)");
            this.createStatement(EventStatements.QUERY_SAMPLE, "SELECT Sample from Energy_Sample WHERE Session = ? AND Timestamp >= ? AND Timestamp < ?;");
            this.createStatement(EventStatements.QUERY_EVENT, "SELECT Latest_Events.Event, Latest_Events.Timestamp  FROM   (SELECT Event, Id, MAX(Timestamp) AS Timestamp, IsTerminal    FROM Energy_Event    WHERE Session = ? AND TimeStamp < ?    GROUP BY Id) AS Latest_Events  WHERE IsTerminal = 0 UNION SELECT Event, Timestamp FROM Energy_Event  WHERE Session = ? AND Timestamp >= ? AND Timestamp < ?ORDER BY Timestamp;");
            this.createStatement(EventStatements.QUERY_EVENT_GROUP, "SELECT Event, Timestamp FROM Energy_Event  WHERE Session = ? AND Id = ?ORDER BY Timestamp;");
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
        }
    }

    public void insertOrReplace(@NotNull Common.Session session, @NotNull EnergyProfiler.EnergySample sample) {
        if (session == null) {
            EnergyTable.$$$reportNull$$$0(1);
        }
        if (sample == null) {
            EnergyTable.$$$reportNull$$$0(2);
        }
        this.execute(EventStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertOrReplace(@NotNull Common.Session session, @NotNull EnergyProfiler.EnergyEvent event) {
        if (session == null) {
            EnergyTable.$$$reportNull$$$0(3);
        }
        if (event == null) {
            EnergyTable.$$$reportNull$$$0(4);
        }
        this.execute(EventStatements.INSERT_EVENT, session.getSessionId(), event.getEventId(), event.getTimestamp(), event.getIsTerminal(), event.toByteArray());
    }

    @NotNull
    public List<EnergyProfiler.EnergySample> getSamples(@NotNull EnergyProfiler.EnergyRequest request) {
        List<EnergyProfiler.EnergySample> list;
        if (request == null) {
            EnergyTable.$$$reportNull$$$0(5);
        }
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_SAMPLE, request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            list = EnergyTable.getSamplesFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            ArrayList<EnergyProfiler.EnergySample> arrayList = new ArrayList<EnergyProfiler.EnergySample>();
            if (arrayList == null) {
                EnergyTable.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (list == null) {
            EnergyTable.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<EnergyProfiler.EnergyEvent> getEvents(@NotNull EnergyProfiler.EnergyRequest request) {
        List<EnergyProfiler.EnergyEvent> list;
        if (request == null) {
            EnergyTable.$$$reportNull$$$0(8);
        }
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_EVENT, request.getSession().getSessionId(), request.getStartTimestamp(), request.getSession().getSessionId(), request.getStartTimestamp(), request.getEndTimestamp());
            list = EnergyTable.getEventsFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            ArrayList<EnergyProfiler.EnergyEvent> arrayList = new ArrayList<EnergyProfiler.EnergyEvent>();
            if (arrayList == null) {
                EnergyTable.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        if (list == null) {
            EnergyTable.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<EnergyProfiler.EnergyEvent> getEventGroup(@NotNull EnergyProfiler.EnergyEventGroupRequest request) {
        List<EnergyProfiler.EnergyEvent> list;
        if (request == null) {
            EnergyTable.$$$reportNull$$$0(11);
        }
        try {
            ResultSet results = this.executeQuery(EventStatements.QUERY_EVENT_GROUP, request.getSession().getSessionId(), request.getEventId());
            list = EnergyTable.getEventsFromResultSet(results);
        }
        catch (SQLException ex) {
            EnergyTable.onError(ex);
            ArrayList<EnergyProfiler.EnergyEvent> arrayList = new ArrayList<EnergyProfiler.EnergyEvent>();
            if (arrayList == null) {
                EnergyTable.$$$reportNull$$$0(13);
            }
            return arrayList;
        }
        if (list == null) {
            EnergyTable.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private static List<EnergyProfiler.EnergySample> getSamplesFromResultSet(@NotNull ResultSet results) {
        if (results == null) {
            EnergyTable.$$$reportNull$$$0(14);
        }
        ArrayList<EnergyProfiler.EnergySample> samples = new ArrayList<EnergyProfiler.EnergySample>();
        try {
            while (results.next()) {
                EnergyProfiler.EnergySample.Builder sampleBuilder = EnergyProfiler.EnergySample.newBuilder();
                sampleBuilder.mergeFrom(results.getBytes(1));
                samples.add(sampleBuilder.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EnergyTable.onError(ex);
        }
        ArrayList<EnergyProfiler.EnergySample> arrayList = samples;
        if (arrayList == null) {
            EnergyTable.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    private static List<EnergyProfiler.EnergyEvent> getEventsFromResultSet(@NotNull ResultSet results) {
        if (results == null) {
            EnergyTable.$$$reportNull$$$0(16);
        }
        ArrayList<EnergyProfiler.EnergyEvent> events = new ArrayList<EnergyProfiler.EnergyEvent>();
        try {
            while (results.next()) {
                EnergyProfiler.EnergyEvent.Builder eventBuilder = EnergyProfiler.EnergyEvent.newBuilder();
                eventBuilder.mergeFrom(results.getBytes(1));
                events.add(eventBuilder.build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            EnergyTable.onError(ex);
        }
        ArrayList<EnergyProfiler.EnergyEvent> arrayList = events;
        if (arrayList == null) {
            EnergyTable.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/EnergyTable";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/EnergyTable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSamples";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSamplesFromResultSet";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsFromResultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "insertOrReplace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSamples";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getEvents";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEventGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSamplesFromResultSet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEventsFromResultSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EventStatements {
        INSERT_SAMPLE,
        QUERY_SAMPLE,
        INSERT_EVENT,
        QUERY_EVENT,
        QUERY_EVENT_GROUP;

    }
}

