/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.explorer;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModel;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.lang.ant.config.AntNoFileException;
import com.intellij.lang.ant.config.ExecutionEvent;
import com.intellij.lang.ant.config.actions.AntBuildFilePropertiesAction;
import com.intellij.lang.ant.config.actions.RemoveBuildFileAction;
import com.intellij.lang.ant.config.execution.AntRunConfiguration;
import com.intellij.lang.ant.config.execution.AntRunConfigurationType;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.explorer.AntBuildFileNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntExecuteBeforeRunDialog;
import com.intellij.lang.ant.config.explorer.AntExplorerTreeStructure;
import com.intellij.lang.ant.config.explorer.AntNodeDescriptor;
import com.intellij.lang.ant.config.explorer.AntTargetNodeDescriptor;
import com.intellij.lang.ant.config.explorer.SaveMetaTargetDialog;
import com.intellij.lang.ant.config.impl.ExecuteAfterCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteBeforeCompilationEvent;
import com.intellij.lang.ant.config.impl.ExecuteCompositeTargetEvent;
import com.intellij.lang.ant.config.impl.MetaTarget;
import com.intellij.lang.ant.config.impl.configuration.BuildFilePropertiesPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import icons.AntIcons;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntExplorer
extends SimpleToolWindowPanel
implements DataProvider,
Disposable {
    private Project myProject;
    private Tree myTree;
    private final AntBuildFilePropertiesAction myAntBuildFilePropertiesAction;
    private AntConfiguration myConfig;
    private final AntExplorerTreeStructure myTreeStructure;
    private StructureTreeModel myTreeModel;
    private final TreeExpander myTreeExpander;

    public AntExplorer(@NotNull Project project) {
        StructureTreeModel treeModel;
        AntConfiguration config;
        if (project == null) {
            AntExplorer.$$$reportNull$$$0(0);
        }
        super(true, true);
        this.myTreeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)AntExplorer.this.myTree);
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)AntExplorer.this.myTree, (int)1);
            }

            public boolean canExpand() {
                AntConfiguration config = AntExplorer.this.myConfig;
                return config != null && !config.getBuildFileList().isEmpty();
            }

            public boolean canCollapse() {
                return this.canExpand();
            }
        };
        this.setTransferHandler(new MyTransferHandler());
        this.myProject = project;
        this.myConfig = config = AntConfiguration.getInstance(project);
        this.myTreeStructure = new AntExplorerTreeStructure(project);
        this.myTreeStructure.setFilteredTargets(AntConfigurationBase.getInstance(project).isFilterTargets());
        this.myTreeModel = treeModel = new StructureTreeModel((AbstractTreeStructure)this.myTreeStructure);
        this.myTree = new Tree((TreeModel)new AsyncTreeModel((TreeModel)treeModel, (Disposable)this));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new NodeRenderer()));
        final AntConfigurationListener listener = new AntConfigurationListener(){

            @Override
            public void configurationLoaded() {
                treeModel.invalidate();
            }

            @Override
            public void buildFileAdded(AntBuildFile buildFile) {
                treeModel.invalidate();
            }

            @Override
            public void buildFileChanged(AntBuildFile buildFile) {
                treeModel.invalidate((Object)buildFile, true);
            }

            @Override
            public void buildFileRemoved(AntBuildFile buildFile) {
                treeModel.invalidate();
            }
        };
        config.addAntConfigurationListener(listener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                config.removeAntConfigurationListener(listener);
            }
        });
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch((JTree)this.myTree);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                AntExplorer.this.popupInvoked(comp, x, y);
            }
        });
        new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.myTree, null){

            protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (dataContext == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (treePath == null) {
                    5.$$$reportNull$$$0(2);
                }
                AntExplorer.this.runSelection(DataManager.getInstance().getDataContext((Component)AntExplorer.this.myTree));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataContext";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "treePath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$5";
                objectArray[2] = "processDoubleClick";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.installOn((Component)this.myTree);
        this.myTree.registerKeyboardAction((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntExplorer.this.runSelection(DataManager.getInstance().getDataContext((Component)AntExplorer.this.myTree));
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.myTree.setLineStyleAngled();
        this.myAntBuildFilePropertiesAction = new AntBuildFilePropertiesAction(this);
        this.setToolbar(this.createToolbarPanel());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        Object refresher = Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{KeymapManagerListener.class, DomEventListener.class}, (proxy, method, args) -> treeModel.invalidate());
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)((KeymapManagerListener)refresher));
        DomManager.getDomManager((Project)project).addDomEventListener((DomEventListener)refresher, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void beforeRunTasksChanged() {
                treeModel.invalidate();
            }
        });
    }

    public void dispose() {
        Tree tree = this.myTree;
        if (tree != null) {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)tree);
            for (KeyStroke keyStroke : tree.getRegisteredKeyStrokes()) {
                tree.unregisterKeyboardAction(keyStroke);
            }
            this.myTree = null;
        }
        this.myTreeModel = null;
        this.myProject = null;
        this.myConfig = null;
    }

    private JPanel createToolbarPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddAction());
        group.add((AnAction)new RemoveAction());
        group.add((AnAction)new RunAction());
        group.add((AnAction)new ShowAllTargetsAction());
        AnAction action = CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this));
        action.getTemplatePresentation().setDescription(AntBundle.message("ant.explorer.expand.all.nodes.action.description", new Object[0]));
        group.add(action);
        action = CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this));
        action.getTemplatePresentation().setDescription(AntBundle.message("ant.explorer.collapse.all.nodes.action.description", new Object[0]));
        group.add(action);
        group.add((AnAction)this.myAntBuildFilePropertiesAction);
        ActionToolbar actionToolBar = ActionManager.getInstance().createActionToolbar("AntExplorerToolbar", (ActionGroup)group, true);
        return JBUI.Panels.simplePanel((Component)actionToolBar.getComponent());
    }

    private void addBuildFile() {
        FileChooserDescriptor descriptor = AntExplorer.createXmlDescriptor();
        descriptor.setTitle(AntBundle.message("select.ant.build.file.dialog.title", new Object[0]));
        descriptor.setDescription(AntBundle.message("select.ant.build.file.dialog.description", new Object[0]));
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
        this.addBuildFile(files);
    }

    private void addBuildFile(VirtualFile[] files) {
        if (files.length == 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            AntConfiguration antConfiguration = this.myConfig;
            if (antConfiguration == null) {
                return;
            }
            ArrayList<VirtualFile> ignoredFiles = new ArrayList<VirtualFile>();
            for (VirtualFile file : files) {
                try {
                    antConfiguration.addBuildFile(file);
                }
                catch (AntNoFileException e) {
                    ignoredFiles.add(e.getFile());
                }
            }
            if (ignoredFiles.size() != 0) {
                StringBuilder message = new StringBuilder();
                String separator = "";
                for (VirtualFile virtualFile : ignoredFiles) {
                    message.append(separator);
                    message.append(virtualFile.getPresentableUrl());
                    separator = "\n";
                }
                String messageText = message.toString();
                Messages.showWarningDialog((Project)this.myProject, (String)messageText, (String)AntBundle.message("cannot.add.ant.files.dialog.title", new Object[0]));
            }
        });
    }

    public void removeSelectedBuildFiles() {
        Collection<AntBuildFileBase> files = this.getSelectedBuildFiles();
        if (!files.isEmpty()) {
            if (files.size() == 1) {
                this.removeBuildFile(files.iterator().next());
            } else {
                int result = Messages.showYesNoDialog((Project)this.myProject, (String)("Do you want to remove references to " + files.size() + " build files?"), (String)AntBundle.message("confirm.remove.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    for (AntBuildFileBase file : files) {
                        this.myConfig.removeBuildFile(file);
                    }
                }
            }
        }
    }

    public void removeBuildFile() {
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile == null) {
            return;
        }
        this.removeBuildFile(buildFile);
    }

    private void removeBuildFile(AntBuildFile buildFile) {
        String fileName = buildFile.getPresentableUrl();
        int result = Messages.showYesNoDialog((Project)this.myProject, (String)AntBundle.message("remove.the.reference.to.file.confirmation.text", fileName), (String)AntBundle.message("confirm.remove.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (result != 0) {
            return;
        }
        this.myConfig.removeBuildFile(buildFile);
    }

    public void setBuildFileProperties() {
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile != null && BuildFilePropertiesPanel.editBuildFile(buildFile, this.myProject)) {
            this.myConfig.updateBuildFile(buildFile);
        }
    }

    private void runSelection(DataContext dataContext) {
        if (!this.canRunSelection()) {
            return;
        }
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile != null) {
            List<String> targets = AntExplorer.getTargetNamesFromPaths(this.myTree.getSelectionPaths());
            ExecutionHandler.runBuild(buildFile, targets, null, dataContext, Collections.emptyList(), AntBuildListener.NULL);
        }
    }

    private boolean canRunSelection() {
        if (this.myTree == null) {
            return false;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        AntBuildFileBase buildFile = this.getCurrentBuildFile();
        if (buildFile == null || !buildFile.exists()) {
            return false;
        }
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            AntBuildFileNodeDescriptor buildFileNodeDescriptor = userObject instanceof AntTargetNodeDescriptor ? (AntBuildFileNodeDescriptor)((Object)((DefaultMutableTreeNode)node.getParent()).getUserObject()) : (userObject instanceof AntBuildFileNodeDescriptor ? (AntBuildFileNodeDescriptor)((Object)userObject) : null);
            if (buildFileNodeDescriptor != null && buildFileNodeDescriptor.getBuildFile() == buildFile) continue;
            return false;
        }
        return true;
    }

    private static List<String> getTargetNamesFromPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> targets = new ArrayList<String>();
        for (TreePath path : paths) {
            Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(userObject instanceof AntTargetNodeDescriptor)) continue;
            AntBuildTargetBase target = ((AntTargetNodeDescriptor)((Object)userObject)).getTarget();
            if (target instanceof MetaTarget) {
                ContainerUtil.addAll(targets, target.getTargetNames());
                continue;
            }
            targets.add(target.getName());
        }
        return targets;
    }

    private static AntBuildTarget[] getTargetObjectsFromPaths(TreePath[] paths) {
        return (AntBuildTarget[])Arrays.stream(paths).map(path -> ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).filter(userObject -> userObject instanceof AntTargetNodeDescriptor).map(userObject -> ((AntTargetNodeDescriptor)((Object)((Object)userObject))).getTarget()).toArray(AntBuildTarget[]::new);
    }

    public boolean isBuildFileSelected() {
        if (this.myProject == null) {
            return false;
        }
        AntBuildFileBase file = this.getCurrentBuildFile();
        return file != null && file.exists();
    }

    @Nullable
    private AntBuildFileBase getCurrentBuildFile() {
        AntBuildFileNodeDescriptor descriptor = this.getCurrentBuildFileNodeDescriptor();
        return (AntBuildFileBase)(descriptor == null ? null : descriptor.getBuildFile());
    }

    @NotNull
    private Collection<AntBuildFileBase> getSelectedBuildFiles() {
        if (this.myTree == null) {
            List<AntBuildFileBase> list = Collections.emptyList();
            if (list == null) {
                AntExplorer.$$$reportNull$$$0(1);
            }
            return list;
        }
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            List<AntBuildFileBase> list = Collections.emptyList();
            if (list == null) {
                AntExplorer.$$$reportNull$$$0(2);
            }
            return list;
        }
        HashSet<AntBuildFileBase> result = new HashSet<AntBuildFileBase>();
        block0: for (TreePath path : paths) {
            for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof AntBuildFileNodeDescriptor)) continue;
                AntBuildFileBase file = (AntBuildFileBase)((AntBuildFileNodeDescriptor)((Object)userObject)).getBuildFile();
                if (file == null) continue block0;
                result.add(file);
                continue block0;
            }
        }
        HashSet<AntBuildFileBase> hashSet = result;
        if (hashSet == null) {
            AntExplorer.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @Nullable
    private AntBuildFileNodeDescriptor getCurrentBuildFileNodeDescriptor() {
        Tree tree = this.myTree;
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
            Object userObject = node.getUserObject();
            if (!(userObject instanceof AntBuildFileNodeDescriptor)) continue;
            return (AntBuildFileNodeDescriptor)((Object)userObject);
        }
        return null;
    }

    private void popupInvoked(Component comp, int x, int y) {
        DefaultMutableTreeNode node;
        Object userObject = null;
        TreePath path = this.myTree.getSelectionPath();
        if (path != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null) {
            userObject = node.getUserObject();
        }
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RunAction());
        group.add((AnAction)new CreateMetaTargetAction());
        group.add((AnAction)new MakeAntRunConfigurationAction());
        group.add((AnAction)new RemoveMetaTargetsOrBuildFileAction());
        group.add(ActionManager.getInstance().getAction("EditSource"));
        if (userObject instanceof AntBuildFileNodeDescriptor) {
            group.add((AnAction)new RemoveBuildFileAction(this));
        }
        if (userObject instanceof AntTargetNodeDescriptor) {
            AntBuildTargetBase target = ((AntTargetNodeDescriptor)((Object)userObject)).getTarget();
            DefaultActionGroup executeOnGroup = new DefaultActionGroup(AntBundle.message("ant.explorer.execute.on.action.group.name", new Object[0]), true);
            executeOnGroup.add((AnAction)new ExecuteOnEventAction(target, ExecuteBeforeCompilationEvent.getInstance()));
            executeOnGroup.add((AnAction)new ExecuteOnEventAction(target, ExecuteAfterCompilationEvent.getInstance()));
            executeOnGroup.addSeparator();
            executeOnGroup.add((AnAction)new ExecuteBeforeRunAction(target));
            group.add((AnAction)executeOnGroup);
            group.add((AnAction)new AssignShortcutAction(target.getActionId()));
        }
        group.add((AnAction)this.myAntBuildFilePropertiesAction);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("AntExplorerPopup", (ActionGroup)group);
        popupMenu.getComponent().show(comp, x, y);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            AntExplorer.$$$reportNull$$$0(4);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            AntTargetNodeDescriptor targetNodeDescriptor;
            AntBuildTargetBase buildTarget;
            Navigatable descriptor;
            AntBuildFileBase buildFile2 = this.getCurrentBuildFile();
            if (buildFile2 == null) {
                return null;
            }
            VirtualFile file = buildFile2.getVirtualFile();
            if (file == null) {
                return null;
            }
            TreePath treePath = this.myTree.getLeadSelectionPath();
            if (treePath == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (node == null) {
                return null;
            }
            if (node.getUserObject() instanceof AntTargetNodeDescriptor && (descriptor = (buildTarget = (targetNodeDescriptor = (AntTargetNodeDescriptor)((Object)node.getUserObject())).getTarget()).getOpenFileDescriptor()) != null && descriptor.canNavigate()) {
                return descriptor;
            }
            if (file.isValid()) {
                return new OpenFileDescriptor(this.myProject, file);
            }
        } else {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "ant.antToolWindow";
            }
            if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
                return this.myProject != null ? this.myTreeExpander : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                List<VirtualFile> virtualFiles = this.collectAntFiles(buildFile -> {
                    VirtualFile virtualFile = buildFile.getVirtualFile();
                    if (virtualFile != null && virtualFile.isValid()) {
                        return virtualFile;
                    }
                    return null;
                });
                return virtualFiles == null ? null : virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                List<PsiElement> elements = this.collectAntFiles(AntBuildFile::getAntFile);
                return elements == null ? null : elements.toArray(PsiElement.EMPTY_ARRAY);
            }
        }
        return super.getData(dataId);
    }

    private <T> List<T> collectAntFiles(Function<AntBuildFile, T> function) {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        LinkedHashSet<AntBuildFile> antFiles = new LinkedHashSet<AntBuildFile>();
        block0: for (TreePath path : paths) {
            for (DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null; node = (DefaultMutableTreeNode)node.getParent()) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof AntBuildFileNodeDescriptor)) continue;
                AntBuildFile buildFile = ((AntBuildFileNodeDescriptor)((Object)userObject)).getBuildFile();
                if (buildFile == null) continue block0;
                antFiles.add(buildFile);
                continue block0;
            }
        }
        ArrayList result = new ArrayList();
        ContainerUtil.addAllNotNull(result, (Iterable)ContainerUtil.map(antFiles, function));
        return result.isEmpty() ? null : result;
    }

    public static FileChooserDescriptor createXmlDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                boolean b = super.isFileVisible(file, showHiddenFiles);
                if (!file.isDirectory()) {
                    b &= StdFileTypes.XML.equals(file.getFileType());
                }
                return b;
            }
        };
    }

    private void setTargetsFiltered(boolean value) {
        try {
            this.myTreeStructure.setFilteredTargets(value);
            AntConfigurationBase.getInstance(this.myProject).setFilterTargets(value);
        }
        finally {
            this.myTreeModel.invalidate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/explorer/AntExplorer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedBuildFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private MyTransferHandler() {
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (this.canImport(support)) {
                AntExplorer.this.addBuildFile(this.getAntFiles(support));
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])support.getDataFlavors());
        }

        private VirtualFile[] getAntFiles(TransferHandler.TransferSupport support) {
            ArrayList virtualFileList = new ArrayList();
            List fileList = FileCopyPasteUtil.getFileList((Transferable)support.getTransferable());
            if (fileList != null) {
                for (File file : fileList) {
                    ContainerUtil.addIfNotNull(virtualFileList, (Object)VfsUtil.findFileByIoFile((File)file, (boolean)true));
                }
            }
            return VfsUtilCore.toVirtualFileArray(virtualFileList);
        }
    }

    private final class AssignShortcutAction
    extends AnAction {
        private final String myActionId;

        AssignShortcutAction(String actionId) {
            super(AntBundle.message("ant.explorer.assign.shortcut.action.name", new Object[0]));
            this.myActionId = actionId;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AssignShortcutAction.$$$reportNull$$$0(0);
            }
            new EditKeymapsDialog(AntExplorer.this.myProject, this.myActionId).show();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AssignShortcutAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myActionId != null && ActionManager.getInstance().getAction(this.myActionId) != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$AssignShortcutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveMetaTargetsOrBuildFileAction
    extends AnAction {
        RemoveMetaTargetsOrBuildFileAction() {
            super(AntBundle.message("remove.meta.targets.action.name", new Object[0]), AntBundle.message("remove.meta.targets.action.description", new Object[0]), null);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)AntExplorer.this.myTree);
            Disposer.register((Disposable)AntExplorer.this, (Disposable)new Disposable(){

                public void dispose() {
                    RemoveMetaTargetsOrBuildFileAction.this.unregisterCustomShortcutSet((JComponent)AntExplorer.this.myTree);
                }
            });
            AntExplorer.this.myTree.registerKeyboardAction((ActionListener)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RemoveMetaTargetsOrBuildFileAction.this.doAction();
                }
            }, KeyStroke.getKeyStroke(127, 0), 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveMetaTargetsOrBuildFileAction.$$$reportNull$$$0(0);
            }
            this.doAction();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doAction() {
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            try {
                AntBuildFileNodeDescriptor descriptor;
                DefaultMutableTreeNode node;
                if (paths.length == 1 && (node = (DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof AntBuildFileNodeDescriptor && (descriptor = (AntBuildFileNodeDescriptor)((Object)node.getUserObject())).getBuildFile().equals(AntExplorer.this.getCurrentBuildFile())) {
                    AntExplorer.this.removeBuildFile();
                    return;
                }
                AntBuildTarget[] targets = AntExplorer.getTargetObjectsFromPaths(paths);
                AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(AntExplorer.this.myProject);
                for (AntBuildTarget buildTarget : targets) {
                    if (!(buildTarget instanceof MetaTarget)) continue;
                    for (ExecutionEvent event : antConfiguration.getEventsForTarget(buildTarget)) {
                        if (!(event instanceof ExecuteCompositeTargetEvent)) continue;
                        antConfiguration.clearTargetForEvent(event);
                    }
                }
            }
            finally {
                AntExplorer.this.myTreeModel.invalidate();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveMetaTargetsOrBuildFileAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = e.getPresentation();
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            if (paths == null) {
                presentation.setEnabled(false);
                return;
            }
            if (paths.length == 1) {
                AntTargetNodeDescriptor descr;
                AntBuildTargetBase target;
                String text = AntBundle.message("remove.meta.target.action.name", new Object[0]);
                boolean enabled = false;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
                if (node.getUserObject() instanceof AntBuildFileNodeDescriptor) {
                    AntBuildFileNodeDescriptor descriptor = (AntBuildFileNodeDescriptor)((Object)node.getUserObject());
                    if (descriptor.getBuildFile().equals(AntExplorer.this.getCurrentBuildFile())) {
                        text = AntBundle.message("remove.selected.build.file.action.name", new Object[0]);
                        enabled = true;
                    }
                } else if (node.getUserObject() instanceof AntTargetNodeDescriptor && (target = (descr = (AntTargetNodeDescriptor)((Object)node.getUserObject())).getTarget()) instanceof MetaTarget) {
                    enabled = true;
                }
                presentation.setText(text);
                presentation.setEnabled(enabled);
            } else {
                presentation.setText(AntBundle.message("remove.selected.meta.targets.action.name", new Object[0]));
                AntBuildTarget[] targets = AntExplorer.getTargetObjectsFromPaths(paths);
                boolean enabled = targets.length > 0;
                for (AntBuildTarget buildTarget : targets) {
                    if (buildTarget instanceof MetaTarget) continue;
                    enabled = false;
                    break;
                }
                presentation.setEnabled(enabled);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$RemoveMetaTargetsOrBuildFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CreateMetaTargetAction
    extends AnAction {
        CreateMetaTargetAction() {
            super(AntBundle.message("ant.create.meta.target.action.name", new Object[0]), AntBundle.message("ant.create.meta.target.action.description", new Object[0]), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            AntBuildFileBase buildFile;
            if (e == null) {
                CreateMetaTargetAction.$$$reportNull$$$0(0);
            }
            if ((buildFile = AntExplorer.this.getCurrentBuildFile()) != null) {
                List targets = AntExplorer.getTargetNamesFromPaths(AntExplorer.this.myTree.getSelectionPaths());
                ExecuteCompositeTargetEvent event = new ExecuteCompositeTargetEvent(targets);
                SaveMetaTargetDialog dialog = new SaveMetaTargetDialog((Component)AntExplorer.this.myTree, event, AntConfigurationBase.getInstance(AntExplorer.this.myProject), buildFile);
                dialog.setTitle(e.getPresentation().getText());
                if (dialog.showAndGet()) {
                    AntExplorer.this.myTreeModel.invalidate((Object)buildFile, true);
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateMetaTargetAction.$$$reportNull$$$0(1);
            }
            TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
            e.getPresentation().setEnabled(paths != null && paths.length > 1 && AntExplorer.this.canRunSelection());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$CreateMetaTargetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ExecuteBeforeRunAction
    extends AnAction {
        private final AntBuildTarget myTarget;

        ExecuteBeforeRunAction(AntBuildTarget target) {
            super(AntBundle.message("executes.before.run.debug.acton.name", new Object[0]));
            this.myTarget = target;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteBeforeRunAction.$$$reportNull$$$0(0);
            }
            AntExecuteBeforeRunDialog dialog = new AntExecuteBeforeRunDialog(AntExplorer.this.myProject, this.myTarget);
            dialog.show();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteBeforeRunAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.myTarget.getModel().getBuildFile().exists());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$ExecuteBeforeRunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ExecuteOnEventAction
    extends ToggleAction {
        private final AntBuildTargetBase myTarget;
        private final ExecutionEvent myExecutionEvent;

        ExecuteOnEventAction(AntBuildTargetBase target, ExecutionEvent executionEvent) {
            super(executionEvent.getPresentableName());
            this.myTarget = target;
            this.myExecutionEvent = executionEvent;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteOnEventAction.$$$reportNull$$$0(0);
            }
            return this.myTarget.equals(AntConfigurationBase.getInstance(AntExplorer.this.myProject).getTargetForEvent(this.myExecutionEvent));
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            if (event == null) {
                ExecuteOnEventAction.$$$reportNull$$$0(1);
            }
            AntConfigurationBase antConfiguration = AntConfigurationBase.getInstance(AntExplorer.this.myProject);
            if (state) {
                AntBuildFileBase buildFile = (AntBuildFileBase)(this.myTarget instanceof MetaTarget ? ((MetaTarget)this.myTarget).getBuildFile() : this.myTarget.getModel().getBuildFile());
                antConfiguration.setTargetForEvent(buildFile, this.myTarget.getName(), this.myExecutionEvent);
            } else {
                antConfiguration.clearTargetForEvent(this.myExecutionEvent);
            }
            AntExplorer.this.myTreeModel.invalidate();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecuteOnEventAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            AntBuildFile buildFile = this.myTarget.getModel().getBuildFile();
            e.getPresentation().setEnabled(buildFile != null && buildFile.exists());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$ExecuteOnEventAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ShowAllTargetsAction
    extends ToggleAction {
        ShowAllTargetsAction() {
            super(AntBundle.message("filter.ant.targets.action.name", new Object[0]), AntBundle.message("filter.ant.targets.action.description", new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            Project project;
            if (event == null) {
                ShowAllTargetsAction.$$$reportNull$$$0(0);
            }
            return (project = AntExplorer.this.myProject) != null && AntConfigurationBase.getInstance(project).isFilterTargets();
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            if (event == null) {
                ShowAllTargetsAction.$$$reportNull$$$0(1);
            }
            AntExplorer.this.setTargetsFiltered(flag);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$ShowAllTargetsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MakeAntRunConfigurationAction
    extends AnAction {
        MakeAntRunConfigurationAction() {
            super(AntBundle.message("make.ant.runconfiguration.name", new Object[0]), null, AntIcons.Build);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MakeAntRunConfigurationAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(AntExplorer.this.myTree.getSelectionCount() == 1 && AntExplorer.this.canRunSelection());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            AntBuildFileBase buildFile;
            if (e == null) {
                MakeAntRunConfigurationAction.$$$reportNull$$$0(1);
            }
            if ((buildFile = AntExplorer.this.getCurrentBuildFile()) == null || !buildFile.exists()) {
                return;
            }
            TreePath selectionPath = AntExplorer.this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Object userObject = node.getUserObject();
            AntBuildTarget target = null;
            if (userObject instanceof AntTargetNodeDescriptor) {
                AntTargetNodeDescriptor targetNodeDescriptor = (AntTargetNodeDescriptor)((Object)userObject);
                target = targetNodeDescriptor.getTarget();
            } else if (userObject instanceof AntBuildFileNodeDescriptor) {
                AntBuildModel model = ((AntBuildFileNodeDescriptor)((Object)userObject)).getBuildFile().getModel();
                target = model.findTarget(model.getDefaultTargetName());
            }
            String string = name = target != null ? target.getDisplayName() : null;
            if (target == null || name == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)AntExplorer.this.myProject);
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(name, AntRunConfigurationType.class);
            AntRunConfiguration configuration = (AntRunConfiguration)settings.getConfiguration();
            configuration.acceptSettings(target);
            if (RunDialog.editConfiguration((Project)e.getProject(), (RunnerAndConfigurationSettings)settings, (String)ExecutionBundle.message((String)"create.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration.getName()}))) {
                runManager.addConfiguration(settings);
                runManager.setSelectedConfiguration(settings);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$MakeAntRunConfigurationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RunAction
    extends AnAction {
        RunAction() {
            super(AntBundle.message("run.ant.file.or.target.action.name", new Object[0]), AntBundle.message("run.ant.file.or.target.action.description", new Object[0]), AllIcons.Actions.Execute);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RunAction.$$$reportNull$$$0(0);
            }
            AntExplorer.this.runSelection(e.getDataContext());
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RunAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            String place = event.getPlace();
            if ("AntExplorerToolbar".equals(place)) {
                presentation.setText(AntBundle.message("run.ant.file.or.target.action.name", new Object[0]));
            } else {
                TreePath[] paths = AntExplorer.this.myTree.getSelectionPaths();
                if (paths != null && paths.length == 1 && ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof AntBuildFileNodeDescriptor) {
                    presentation.setText(AntBundle.message("run.ant.build.action.name", new Object[0]));
                } else if (paths == null || paths.length == 1) {
                    presentation.setText(AntBundle.message("run.ant.target.action.name", new Object[0]));
                } else {
                    presentation.setText(AntBundle.message("run.ant.targets.action.name", new Object[0]));
                }
            }
            presentation.setEnabled(AntExplorer.this.canRunSelection());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$RunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveAction
    extends AnAction {
        RemoveAction() {
            super(AntBundle.message("remove.ant.file.action.name", new Object[0]), AntBundle.message("remove.ant.file.action.description", new Object[0]), IconUtil.getRemoveIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            AntExplorer.this.removeSelectedBuildFiles();
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                RemoveAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(AntExplorer.this.getCurrentBuildFile() != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ant/config/explorer/AntExplorer$RemoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddAction
    extends AnAction {
        AddAction() {
            super(AntBundle.message("add.ant.file.action.name", new Object[0]), AntBundle.message("add.ant.file.action.description", new Object[0]), IconUtil.getAddIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            AntExplorer.this.addBuildFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/ant/config/explorer/AntExplorer$AddAction", "actionPerformed"));
        }
    }

    private static final class NodeRenderer
    extends ColoredTreeCellRenderer {
        private NodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (tree == null) {
                NodeRenderer.$$$reportNull$$$0(0);
            }
            if ((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof AntNodeDescriptor) {
                AntNodeDescriptor descriptor = (AntNodeDescriptor)((Object)userObject);
                descriptor.customize((SimpleColoredComponent)this);
            } else {
                this.append(tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/lang/ant/config/explorer/AntExplorer$NodeRenderer", "customizeCellRenderer"));
        }
    }
}

