/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.model.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.JVMModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.JpsMavenModuleExtension;
import org.jetbrains.jps.maven.model.impl.MavenAnnotationProcessorTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class MavenAnnotationProcessorTarget
extends JVMModuleBuildTarget<BuildRootDescriptor> {
    private final MavenAnnotationProcessorTargetType myTargetType;

    public MavenAnnotationProcessorTarget(MavenAnnotationProcessorTargetType targetType, JpsModule module) {
        super((ModuleBasedBuildTargetType)targetType, module);
        this.myTargetType = targetType;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myTargetType.getTypeId() + ":" + this.myModule.getName();
        if (string == null) {
            MavenAnnotationProcessorTarget.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isTests() {
        return this.myTargetType.isTests();
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        JpsMavenModuleExtension moduleExtension = JpsMavenExtensionService.getInstance().getExtension(this.myModule);
        if (moduleExtension == null) {
            return Collections.emptyList();
        }
        HashSet<String> names = new HashSet<String>(moduleExtension.getAnnotationProcessorModules());
        JavaModuleBuildTargetType javaModuleBuildTargetType = JavaModuleBuildTargetType.getInstance((boolean)this.isTests());
        return this.myModule.getProject().getModules().stream().filter(module -> names.contains(module.getName())).map(module -> new ModuleBuildTarget(module, javaModuleBuildTargetType)).collect(Collectors.toList());
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        List<BuildRootDescriptor> list = Collections.emptyList();
        if (list == null) {
            MavenAnnotationProcessorTarget.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.emptyList();
        if (list == null) {
            MavenAnnotationProcessorTarget.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/maven/model/impl/MavenAnnotationProcessorTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

