/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class TypeIntersector {
    public static boolean isIntersectionEmpty(@NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        return TypeIntersector.intersectTypes(new LinkedHashSet<KotlinType>(Arrays.asList(typeA, typeB))) == null;
    }

    public static boolean isIncompatibleEnums(@NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        if (!TypeUtilsKt.isEnum(typeA) || !TypeUtilsKt.isEnum(typeB)) {
            return false;
        }
        return !typeA.getConstructor().equals(typeB.getConstructor());
    }

    @Nullable
    public static KotlinType intersectTypes(@NotNull Collection<KotlinType> types) {
        assert (!types.isEmpty()) : "Attempting to intersect empty collection of types, this case should be dealt with on the call site.";
        if (types.size() == 1) {
            return types.iterator().next();
        }
        KotlinType nothingOrNullableNothing = null;
        boolean allNullable = true;
        ArrayList<KotlinType> nullabilityStripped = new ArrayList<KotlinType>(types.size());
        for (KotlinType type2 : types) {
            if (KotlinTypeKt.isError(type2)) continue;
            if (KotlinBuiltIns.isNothingOrNullableNothing(type2)) {
                nothingOrNullableNothing = type2;
            }
            allNullable &= type2.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type2));
        }
        if (nothingOrNullableNothing != null) {
            return TypeUtils.makeNullableAsSpecified(nothingOrNullableNothing, allNullable);
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType("Intersection of error types: " + types);
        }
        KotlinTypeChecker typeChecker2 = KotlinTypeChecker.DEFAULT;
        ArrayList<KotlinType> resultingTypes = new ArrayList<KotlinType>();
        block1: for (KotlinType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker2, type3)) {
                boolean relativeToAll = true;
                for (KotlinType other : nullabilityStripped) {
                    boolean relative;
                    boolean mayBeEqual = TypeUnifier.mayBeEqual(type3, other);
                    boolean bl = relative = typeChecker2.isSubtypeOf(type3, other) || typeChecker2.isSubtypeOf(other, type3);
                    if (!mayBeEqual && !relative) {
                        return null;
                    }
                    if (relative) continue;
                    relativeToAll = false;
                    break;
                }
                if (relativeToAll) {
                    return TypeUtils.makeNullableAsSpecified(type3, allNullable);
                }
            }
            for (KotlinType other : nullabilityStripped) {
                if (type3.equals(other) || !typeChecker2.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (KotlinType other : resultingTypes) {
                if (!typeChecker2.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            KotlinType bestRepresentative = FlexibleTypesKt.singleBestRepresentative(nullabilityStripped);
            if (bestRepresentative == null) {
                bestRepresentative = UtilsKt.hackForTypeIntersector(nullabilityStripped);
            }
            if (bestRepresentative == null) {
                throw new AssertionError((Object)("Empty intersection for types " + types));
            }
            return TypeUtils.makeNullableAsSpecified(bestRepresentative, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((KotlinType)resultingTypes.get(0), allNullable);
        }
        IntersectionTypeConstructor constructor2 = new IntersectionTypeConstructor(resultingTypes);
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), constructor2, Collections.emptyList(), allNullable, constructor2.createScopeForKotlinType());
    }

    @NotNull
    public static KotlinType getUpperBoundsAsType(@NotNull TypeParameterDescriptor descriptor2) {
        return TypeIntersector.intersectUpperBounds(descriptor2, descriptor2.getUpperBounds());
    }

    public static KotlinType intersectUpperBounds(@NotNull TypeParameterDescriptor descriptor2, @NotNull List<KotlinType> upperBounds) {
        assert (!upperBounds.isEmpty()) : "Upper bound list is empty: " + descriptor2;
        KotlinType upperBoundsAsType = TypeIntersector.intersectTypes(upperBounds);
        return upperBoundsAsType != null ? upperBoundsAsType : DescriptorUtilsKt.getBuiltIns(descriptor2).getNothingType();
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull KotlinType type2, @NotNull KotlinType other) {
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(KotlinType withParameters2, KotlinType expected) {
            HashMap parameters2 = new HashMap();
            Function1 processor2 = parameterUsage -> {
                Variance howTheTypeIsUsedBefore = (Variance)((Object)((Object)parameters2.get(((TypeParameterUsage)parameterUsage).typeParameterDescriptor)));
                if (howTheTypeIsUsedBefore == null) {
                    howTheTypeIsUsedBefore = Variance.INVARIANT;
                }
                parameters2.put(((TypeParameterUsage)parameterUsage).typeParameterDescriptor, ((TypeParameterUsage)parameterUsage).howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                return Unit.INSTANCE;
            };
            TypeUnifier.processAllTypeParameters(withParameters2, Variance.INVARIANT, (Function1<TypeParameterUsage, Unit>)processor2, (Function1<TypeParameterDescriptor, Boolean>)((Function1)parameters2::containsKey));
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, (Function1<TypeParameterUsage, Unit>)processor2, (Function1<TypeParameterDescriptor, Boolean>)((Function1)parameters2::containsKey));
            ConstraintSystemBuilderImpl constraintSystem = new ConstraintSystemBuilderImpl();
            TypeSubstitutor substitutor3 = constraintSystem.registerTypeVariables(CallHandle.NONE.INSTANCE, parameters2.keySet(), false);
            constraintSystem.addSubtypeConstraint(withParameters2, substitutor3.substitute(expected, Variance.INVARIANT), ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.build().getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(KotlinType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result2, Function1<TypeParameterDescriptor, Boolean> containsParameter) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                if (((Boolean)containsParameter.invoke((Object)((TypeParameterDescriptor)descriptor2))).booleanValue()) {
                    return;
                }
                result2.invoke((Object)new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
                for (KotlinType superType : type2.getConstructor().getSupertypes()) {
                    TypeUnifier.processAllTypeParameters(superType, howThisTypeIsUsed, result2, containsParameter);
                }
            }
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result2, containsParameter);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }
}

