/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"findScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isKotlinFileType", "", "psi"})
public final class KotlinScriptDefinitionProviderKt {
    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file, @NotNull Project project) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                if (file.isDirectory() || Intrinsics.areEqual((Object)file.getExtension(), (Object)"kt")) break block6;
                String string = file.getExtension();
                JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaClassFileType, (String)"JavaClassFileType.INSTANCE");
                if (!Intrinsics.areEqual((Object)string, (Object)javaClassFileType.getDefaultExtension()) && KotlinScriptDefinitionProviderKt.isKotlinFileType(file)) break block7;
            }
            return null;
        }
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null) {
            if (!(psiFile instanceof KtFile)) {
                return null;
            }
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            KotlinScriptDefinition definition = scriptDefinitionProvider.findScriptDefinition(string);
            KotlinScriptDefinition kotlinScriptDefinition = definition;
            if (kotlinScriptDefinition == null) {
                kotlinScriptDefinition = scriptDefinitionProvider.getDefaultScriptDefinition();
            }
            return kotlinScriptDefinition;
        }
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
        return scriptDefinitionProvider.findScriptDefinition(string);
    }

    private static final boolean isKotlinFileType(VirtualFile file) {
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFile(file), (Object)((Object)KotlinFileType.INSTANCE)) || Intrinsics.areEqual((Object)typeRegistry.getFileTypeByFileName(file.getName()), (Object)((Object)KotlinFileType.INSTANCE));
    }
}

