/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.resolve.calls.NewCommonSuperTypeCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintKind;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorageKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.IntersectionTypeKt;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\"\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0017\u001a\u00020\u0010*\u00020\f2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0018\u001a\u0004\u0018\u00010\b*\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;", "", "typeApproximator", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "(Lorg/jetbrains/kotlin/types/TypeApproximator;)V", "getTypeApproximator", "()Lorg/jetbrains/kotlin/types/TypeApproximator;", "adjustCommonSupertypeWithKnowledgeOfNumberTypes", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "commonSuperType", "findResultIfThereIsEqualsConstraint", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "allowedFixToNotProperType", "", "findResultType", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "findResultTypeOrNull", "findSubType", "findSuperType", "isSuitableType", "resultType", "firstCandidate", "secondCandidate", "Context", "resolution"})
public final class ResultTypeResolver {
    @NotNull
    private final TypeApproximator typeApproximator;

    @NotNull
    public final UnwrappedType findResultType(@NotNull Context c, @NotNull VariableWithConstraints variableWithConstraints, @NotNull TypeVariableDirectionCalculator.ResolveDirection direction) {
        KotlinBuiltIns kotlinBuiltIns;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)variableWithConstraints, (String)"variableWithConstraints");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        UnwrappedType unwrappedType2 = this.findResultTypeOrNull(c, variableWithConstraints, direction);
        if (unwrappedType2 != null) {
            UnwrappedType unwrappedType3;
            UnwrappedType it = unwrappedType3 = unwrappedType2;
            return it;
        }
        KotlinBuiltIns $receiver = kotlinBuiltIns = variableWithConstraints.getTypeVariable().getFreshTypeConstructor().getBuiltIns();
        SimpleType simpleType2 = direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE ? $receiver.getNothingType() : $receiver.getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"variableWithConstraints.\u2026nullableAnyType\n        }");
        return simpleType2;
    }

    @Nullable
    public final UnwrappedType findResultTypeOrNull(@NotNull Context c, @NotNull VariableWithConstraints variableWithConstraints, @NotNull TypeVariableDirectionCalculator.ResolveDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)variableWithConstraints, (String)"variableWithConstraints");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        UnwrappedType unwrappedType2 = this.findResultIfThereIsEqualsConstraint(c, variableWithConstraints, false);
        if (unwrappedType2 != null) {
            UnwrappedType unwrappedType3;
            UnwrappedType it = unwrappedType3 = unwrappedType2;
            return it;
        }
        UnwrappedType subType = this.findSubType(c, variableWithConstraints);
        UnwrappedType superType = this.findSuperType(c, variableWithConstraints);
        UnwrappedType result2 = direction == TypeVariableDirectionCalculator.ResolveDirection.TO_SUBTYPE || direction == TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN ? this.resultType(c, subType, superType, variableWithConstraints) : this.resultType(c, superType, subType, variableWithConstraints);
        return result2;
    }

    private final UnwrappedType resultType(@NotNull Context $receiver, UnwrappedType firstCandidate, UnwrappedType secondCandidate, VariableWithConstraints variableWithConstraints) {
        if (firstCandidate == null || secondCandidate == null) {
            UnwrappedType unwrappedType2 = firstCandidate;
            if (unwrappedType2 == null) {
                unwrappedType2 = secondCandidate;
            }
            return unwrappedType2;
        }
        if (this.isSuitableType($receiver, firstCandidate, variableWithConstraints)) {
            return firstCandidate;
        }
        if (this.isSuitableType($receiver, secondCandidate, variableWithConstraints)) {
            return secondCandidate;
        }
        return firstCandidate;
    }

    private final boolean isSuitableType(@NotNull Context $receiver, UnwrappedType resultType, VariableWithConstraints variableWithConstraints) {
        for (Constraint constraint : variableWithConstraints.getConstraints()) {
            if (!$receiver.isProperType(constraint.getType()) || ConstraintStorageKt.checkConstraint(constraint.getType(), constraint.getKind(), resultType)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final UnwrappedType findSubType(Context c, VariableWithConstraints variableWithConstraints) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)variableWithConstraints.getConstraints();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            if (!(it.getKind() == ConstraintKind.LOWER && c.isProperType(it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lowerConstraints = (List)destination$iv$iv;
        $receiver$iv = lowerConstraints;
        if (!$receiver$iv.isEmpty()) {
            Collection<UnwrappedType> collection;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            $receiver$iv$iv = lowerConstraints;
            NewCommonSuperTypeCalculator newCommonSuperTypeCalculator = NewCommonSuperTypeCalculator.INSTANCE;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Constraint $i$a$1$filter = (Constraint)item$iv$iv;
                collection = destination$iv$iv2;
                UnwrappedType unwrappedType2 = it.getType();
                collection.add(unwrappedType2);
            }
            collection = (List)destination$iv$iv2;
            UnwrappedType commonSuperType = newCommonSuperTypeCalculator.commonSuperType((List<? extends UnwrappedType>)collection);
            UnwrappedType adjustedCommonSuperType = this.adjustCommonSupertypeWithKnowledgeOfNumberTypes(commonSuperType);
            UnwrappedType unwrappedType3 = this.typeApproximator.approximateToSuperType(adjustedCommonSuperType, TypeApproximatorConfiguration.CapturedTypesApproximation.INSTANCE);
            if (unwrappedType3 == null) {
                unwrappedType3 = adjustedCommonSuperType;
            }
            return unwrappedType3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final UnwrappedType adjustCommonSupertypeWithKnowledgeOfNumberTypes(UnwrappedType commonSuperType) {
        UnwrappedType unwrappedType2;
        TypeConstructor constructor2 = commonSuperType.getConstructor();
        TypeConstructor typeConstructor2 = constructor2;
        if (typeConstructor2 instanceof IntegerValueTypeConstructor || typeConstructor2 instanceof IntersectionTypeConstructor) {
            Object object;
            ArrayList<UnwrappedType> arrayList;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ArrayList<UnwrappedType> newSupertypes = new ArrayList<UnwrappedType>();
            ArrayList<UnwrappedType> numberSupertypes = new ArrayList<UnwrappedType>();
            Collection<KotlinType> collection = constructor2.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"constructor.supertypes");
            Iterable iterable = $receiver$iv = (Iterable)collection;
            ArrayList<UnwrappedType> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType2 = (KotlinType)item$iv$iv2;
                arrayList = destination$iv$iv;
                object = it.unwrap();
                arrayList.add((UnwrappedType)object);
            }
            for (UnwrappedType supertype2 : (List)destination$iv$iv) {
                if (TypeUtilsKt.isPrimitiveNumberType(supertype2)) {
                    numberSupertypes.add(supertype2);
                    continue;
                }
                newSupertypes.add(supertype2);
            }
            KotlinType representativeNumberType = TypeUtils.getDefaultPrimitiveNumberType((Collection<KotlinType>)numberSupertypes);
            if (representativeNumberType != null) {
                newSupertypes.add(representativeNumberType.unwrap());
            } else {
                void $receiver$iv$iv2;
                void $receiver$iv2;
                Iterable iterable2 = numberSupertypes;
                arrayList = newSupertypes;
                $receiver$iv = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv2) {
                    void it;
                    Object item$iv$iv2;
                    item$iv$iv2 = (KotlinType)item$iv$iv;
                    object = destination$iv$iv2;
                    UnwrappedType unwrappedType3 = it.unwrap();
                    object.add(unwrappedType3);
                }
                object = (List)destination$iv$iv2;
                arrayList.addAll((Collection)object);
            }
            unwrappedType2 = IntersectionTypeKt.intersectTypes((List<? extends UnwrappedType>)newSupertypes).makeNullableAsSpecified(commonSuperType.isMarkedNullable());
        } else {
            unwrappedType2 = commonSuperType;
        }
        return unwrappedType2;
    }

    /*
     * WARNING - void declaration
     */
    private final UnwrappedType findSuperType(Context c, VariableWithConstraints variableWithConstraints) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)variableWithConstraints.getConstraints();
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Constraint it = (Constraint)element$iv$iv;
            if (!(it.getKind() == ConstraintKind.UPPER && c.isProperType(it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List upperConstraints = (List)destination$iv$iv;
        $receiver$iv = upperConstraints;
        if (!$receiver$iv.isEmpty()) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv2 = upperConstraints;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it;
                Constraint $i$a$1$filter = (Constraint)item$iv$iv;
                Collection collection = destination$iv$iv2;
                UnwrappedType unwrappedType2 = it.getType();
                collection.add(unwrappedType2);
            }
            UnwrappedType upperType = IntersectionTypeKt.intersectTypes((List)destination$iv$iv2);
            UnwrappedType unwrappedType3 = this.typeApproximator.approximateToSubType(upperType, TypeApproximatorConfiguration.CapturedTypesApproximation.INSTANCE);
            if (unwrappedType3 == null) {
                unwrappedType3 = upperType;
            }
            return unwrappedType3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final UnwrappedType findResultIfThereIsEqualsConstraint(@NotNull Context c, @NotNull VariableWithConstraints variableWithConstraints, boolean allowedFixToNotProperType) {
        void $receiver$iv$iv;
        Constraint it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)variableWithConstraints, (String)"variableWithConstraints");
        Iterable iterable = $receiver$iv = (Iterable)variableWithConstraints.getConstraints();
        Iterable<UnwrappedType> destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it = (Constraint)element$iv$iv;
            if (!(it.getKind() == ConstraintKind.EQUALITY && c.isProperType(it.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properEqualsConstraint = (List)destination$iv$iv;
        $receiver$iv = properEqualsConstraint;
        if (!$receiver$iv.isEmpty()) {
            $receiver$iv$iv2 = $receiver$iv = (Iterable)properEqualsConstraint;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                it = (Constraint)item$iv$iv;
                Iterable<UnwrappedType> iterable2 = destination$iv$iv;
                UnwrappedType unwrappedType2 = it.getType();
                iterable2.add(unwrappedType2);
            }
            KotlinType kotlinType2 = FlexibleTypesKt.singleBestRepresentative((List)destination$iv$iv);
            if (kotlinType2 == null || (kotlinType2 = kotlinType2.unwrap()) == null) {
                kotlinType2 = ((Constraint)CollectionsKt.first((List)properEqualsConstraint)).getType();
            }
            return kotlinType2;
        }
        if (!allowedFixToNotProperType) {
            return null;
        }
        Iterable $receiver$iv2 = variableWithConstraints.getConstraints();
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Constraint it2 = (Constraint)element$iv$iv;
            if (!(it2.getKind() == ConstraintKind.EQUALITY)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List notProperEqualsConstraint = (List)destination$iv$iv2;
        Constraint constraint = (Constraint)CollectionsKt.singleOrNull((List)notProperEqualsConstraint);
        return constraint != null ? constraint.getType() : null;
    }

    @Nullable
    public static /* synthetic */ UnwrappedType findResultIfThereIsEqualsConstraint$default(ResultTypeResolver resultTypeResolver, Context context, VariableWithConstraints variableWithConstraints, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return resultTypeResolver.findResultIfThereIsEqualsConstraint(context, variableWithConstraints, bl);
    }

    @NotNull
    public final TypeApproximator getTypeApproximator() {
        return this.typeApproximator;
    }

    public ResultTypeResolver(@NotNull TypeApproximator typeApproximator) {
        Intrinsics.checkParameterIsNotNull((Object)typeApproximator, (String)"typeApproximator");
        this.typeApproximator = typeApproximator;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver$Context;", "", "isProperType", "", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "resolution"})
    public static interface Context {
        public boolean isProperType(@NotNull UnwrappedType var1);
    }
}

