/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorNonRoot;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.OverloadFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u0016\u0010\u0019\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JS\u0010\u001c\u001a\u00020\u000e2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130#H\u0082\bJ\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00180\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J?\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00132\u0006\u0010*\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130#H\u0082\bJ\"\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00130\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J$\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0002J\u0018\u00101\u001a\u00020.2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0002J\u0018\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020!H\u0002J\u0018\u00105\u001a\u00020.2\u0006\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020!H\u0002J\u0016\u00106\u001a\u00020\u000e2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0002J\f\u00108\u001a\u00020.*\u00020!H\u0002J\f\u00109\u001a\u00020.*\u00020!H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/resolve/OverloadResolver;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "overloadFilter", "Lorg/jetbrains/kotlin/resolve/OverloadFilter;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/OverloadFilter;Lorg/jetbrains/kotlin/resolve/OverloadChecker;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "mainFunctionDetector", "Lorg/jetbrains/kotlin/idea/MainFunctionDetector;", "checkOverloads", "", "c", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "checkOverloadsInClass", "members", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "nestedClassConstructors", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkOverloadsInPackage", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorNonRoot;", "checkOverloadsInPackages", "collectModulePackageMembersWithSameName", "packageMembersByName", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "interestingDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getMembersByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScope;", "Lorg/jetbrains/kotlin/name/Name;", "findConstructorsInNestedClassesAndTypeAliases", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "findRedeclarations", "getModulePackageMembersWithSameName", "descriptor", "getPossibleRedeclarationGroups", "groupModulePackageMembersByFqName", "isConstructorsOfDifferentRedeclaredClasses", "", "member1", "member2", "isDefinitionsForDifferentPlatforms", "isExpectDeclarationAndDefinition", "declaration", "definition", "isTopLevelMainInDifferentFiles", "reportRedeclarations", "redeclarations", "isPrivate", "isSynthesized", "frontend"})
public final class OverloadResolver {
    private final MainFunctionDetector mainFunctionDetector;
    private final BindingTrace trace;
    private final OverloadFilter overloadFilter;
    private final OverloadChecker overloadChecker;

    public final void checkOverloads(@NotNull BodiesResolveContext c) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        MultiMap<ClassDescriptor, FunctionDescriptor> inClasses = this.findConstructorsInNestedClassesAndTypeAliases(c);
        Iterator<ClassDescriptorWithResolutionScopes> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes value;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = value = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"value");
            Collection collection = inClasses.get((Object)value);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"inClasses.get(value)");
            this.checkOverloadsInClass(classDescriptorWithResolutionScopes, collection);
        }
        this.checkOverloadsInPackages(c);
    }

    private final MultiMap<ClassDescriptor, FunctionDescriptor> findConstructorsInNestedClassesAndTypeAliases(BodiesResolveContext c) {
        DeclarationDescriptor containingDeclaration2;
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.create<ClassDes\u2026or, FunctionDescriptor>()");
        MultiMap constructorsByOuterClass = multiMap;
        Iterator<ClassifierDescriptorWithTypeParameters> iterator2 = c.getDeclaredClasses().values().iterator();
        while (iterator2.hasNext()) {
            ClassDescriptorWithResolutionScopes klass2;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = klass2 = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"klass");
            ClassKind classKind = classDescriptorWithResolutionScopes.getKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"klass.kind");
            if (classKind.isSingleton()) continue;
            Name name2 = klass2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"klass.name");
            if (name2.isSpecial()) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)klass2.getContainingDeclaration(), (String)"klass.containingDeclaration");
            if (containingDeclaration2 instanceof ScriptDescriptor) continue;
            if (containingDeclaration2 instanceof ClassDescriptor) {
                constructorsByOuterClass.putValues((Object)containingDeclaration2, klass2.getConstructors());
                continue;
            }
            if (containingDeclaration2 instanceof FunctionDescriptor || containingDeclaration2 instanceof PropertyDescriptor || containingDeclaration2 instanceof PackageFragmentDescriptor) continue;
            throw (Throwable)new IllegalStateException("Illegal class container: " + containingDeclaration2);
        }
        iterator2 = c.getTypeAliases().values().iterator();
        while (iterator2.hasNext()) {
            TypeAliasDescriptor typeAlias2;
            TypeAliasDescriptor typeAliasDescriptor = typeAlias2 = (TypeAliasDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeAliasDescriptor, (String)"typeAlias");
            Intrinsics.checkExpressionValueIsNotNull((Object)typeAliasDescriptor.getContainingDeclaration(), (String)"typeAlias.containingDeclaration");
            if (!(containingDeclaration2 instanceof ClassDescriptor)) continue;
            constructorsByOuterClass.putValues((Object)containingDeclaration2, typeAlias2.getConstructors());
        }
        return constructorsByOuterClass;
    }

    private final void checkOverloadsInPackages(BodiesResolveContext c) {
        MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> membersByName = this.groupModulePackageMembersByFqName(c, this.overloadFilter);
        for (Map.Entry e : membersByName.entrySet()) {
            Object v = e.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
            this.checkOverloadsInPackage((Collection)v);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> groupModulePackageMembersByFqName(BodiesResolveContext c, OverloadFilter overloadFilter) {
        Iterable $receiver$iv$iv$iv;
        ClassifierDescriptor classifier;
        Name name2;
        Object scope2;
        Object containingPackageScope$iv$iv;
        ModuleDescriptor containingModule$iv$iv;
        DeclarationDescriptor containingPackage$iv$iv;
        OverloadResolver this_$iv$iv;
        OverloadResolver this_$iv;
        FqNameUnsafe descriptorFQN$iv;
        Collection<PropertyDescriptor> interestingDescriptors$iv;
        MultiMap packageMembersByName = new MultiMap();
        OverloadResolver overloadResolver = this;
        Collection<SimpleFunctionDescriptor> collection = c.getFunctions().values();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.descriptors.DeclarationDescriptor>");
        }
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)c.getDeclaredClasses().values()), (Iterable)c.getTypeAliases().values());
        HashSet<FqNameUnsafe> observedFQNs$iv = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection3;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"DescriptorUtils.getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection3 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection4 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection3 = collection4;
                    Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"descriptor.constructors");
                }
            } else {
                void $receiver$iv$iv$iv$iv;
                Collection collection5;
                Intrinsics.checkExpressionValueIsNotNull((Object)containingModule$iv$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope2 = containingPackageScope$iv$iv;
                Collection functions2 = scope2.getContributedFunctions(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                ClassifierDescriptor classifierDescriptor = classifier = scope2.getContributedClassifier(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                if (classifierDescriptor instanceof ClassDescriptor) {
                    ClassKind classKind = ((ClassDescriptor)classifier).getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)classKind), (String)"classifier.kind");
                    if (!classKind.isSingleton()) {
                        Collection<ClassConstructorDescriptor> collection6 = ((ClassDescriptor)classifier).getConstructors();
                        Intrinsics.checkExpressionValueIsNotNull(collection6, (String)"classifier.constructors");
                        collection5 = CollectionsKt.plus((Collection)functions2, (Iterable)collection6);
                    } else {
                        collection5 = functions2;
                    }
                } else {
                    collection5 = classifierDescriptor instanceof TypeAliasDescriptor ? (Collection)CollectionsKt.plus(functions2, (Iterable)((TypeAliasDescriptor)classifier).getConstructors()) : functions2;
                }
                Iterable iterable = $receiver$iv$iv$iv = (Iterable)collection5;
                Collection destination$iv$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                List possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection3 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection3;
            packageMembersByName.putValues((Object)descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        this_$iv = this;
        interestingDescriptors$iv = c.getProperties().values();
        observedFQNs$iv = new HashSet();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors$iv) {
            Collection<DeclarationDescriptorNonRoot> collection7;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"DescriptorUtils.getFqName(descriptor)");
            if (observedFQNs$iv.contains(descriptorFQN$iv)) continue;
            observedFQNs$iv.add(descriptorFQN$iv);
            this_$iv$iv = this_$iv;
            containingPackage$iv$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                containingPackageScope$iv$iv = declarationDescriptor;
                if (containingPackageScope$iv$iv instanceof CallableMemberDescriptor) {
                    collection7 = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(containingPackageScope$iv$iv instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection8 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection7 = collection8;
                    Intrinsics.checkExpressionValueIsNotNull(collection8, (String)"descriptor.constructors");
                }
            } else {
                void $receiver$iv$iv$iv$iv;
                Iterable $receiver$iv$iv$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)containingModule$iv$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                containingPackageScope$iv$iv = containingModule$iv$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv$iv).getFqName()).getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"descriptor.name");
                scope2 = containingPackageScope$iv$iv;
                Collection<? extends PropertyDescriptor> variables = scope2.getContributedVariables(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                classifier = scope2.getContributedClassifier(name2, NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                $receiver$iv$iv$iv = $receiver$iv$iv$iv2 = (Iterable)CollectionsKt.plus(variables, (Iterable)CollectionsKt.listOfNotNull((Object)classifier));
                Collection destination$iv$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv$iv : $receiver$iv$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv$iv;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv$iv), (Object)containingModule$iv$iv)) continue;
                    destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
                }
                List possibleOverloads$iv$iv = (List)destination$iv$iv$iv$iv;
                collection7 = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName$iv = collection7;
            packageMembersByName.putValues((Object)descriptorFQN$iv, packageMembersWithSameName$iv);
        }
        return packageMembersByName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void collectModulePackageMembersWithSameName(MultiMap<FqNameUnsafe, DeclarationDescriptorNonRoot> packageMembersByName, Collection<? extends DeclarationDescriptor> interestingDescriptors, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        HashSet<FqNameUnsafe> observedFQNs = new HashSet<FqNameUnsafe>();
        for (DeclarationDescriptor declarationDescriptor : interestingDescriptors) {
            Collection<DeclarationDescriptorNonRoot> collection;
            FqNameUnsafe descriptorFQN;
            if (!(declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)DescriptorUtils.getFqName(declarationDescriptor), (String)"DescriptorUtils.getFqName(descriptor)");
            if (observedFQNs.contains(descriptorFQN)) continue;
            observedFQNs.add(descriptorFQN);
            OverloadResolver this_$iv = this;
            DeclarationDescriptor containingPackage$iv = declarationDescriptor.getContainingDeclaration();
            if (!(containingPackage$iv instanceof PackageFragmentDescriptor)) {
                throw (Throwable)((Object)new AssertionError((Object)(declarationDescriptor + " is not a top-level package member")));
            }
            if (DescriptorUtils.getContainingModuleOrNull(declarationDescriptor) == null) {
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                if (declarationDescriptor2 instanceof CallableMemberDescriptor) {
                    collection = CollectionsKt.listOf((Object)declarationDescriptor);
                } else {
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + declarationDescriptor)));
                    Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)declarationDescriptor).getConstructors();
                    collection = collection2;
                    Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"descriptor.constructors");
                }
            } else {
                void $receiver$iv$iv$iv;
                Iterable $receiver$iv$iv;
                ModuleDescriptor containingModule$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)containingModule$iv, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
                MemberScope containingPackageScope$iv = containingModule$iv.getPackage(((PackageFragmentDescriptor)containingPackage$iv).getFqName()).getMemberScope();
                Name name2 = declarationDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
                Iterable iterable = $receiver$iv$iv = (Iterable)getMembersByName.invoke((Object)containingPackageScope$iv, (Object)name2);
                Collection destination$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    DeclarationDescriptorNonRoot it$iv = (DeclarationDescriptorNonRoot)element$iv$iv$iv;
                    if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it$iv), (Object)containingModule$iv)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                List possibleOverloads$iv = (List)destination$iv$iv$iv;
                collection = overloadFilter.filterPackageMemberOverloads(possibleOverloads$iv);
            }
            Collection<ClassConstructorDescriptor> packageMembersWithSameName = collection;
            packageMembersByName.putValues((Object)descriptorFQN, packageMembersWithSameName);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<DeclarationDescriptorNonRoot> getModulePackageMembersWithSameName(DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>> getMembersByName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        DeclarationDescriptor containingPackage = descriptor2.getContainingDeclaration();
        if (!(containingPackage instanceof PackageFragmentDescriptor)) {
            throw (Throwable)((Object)new AssertionError((Object)(descriptor2 + " is not a top-level package member")));
        }
        ModuleDescriptor moduleDescriptor2 = DescriptorUtils.getContainingModuleOrNull(descriptor2);
        if (moduleDescriptor2 == null) {
            Collection<ClassConstructorDescriptor> collection;
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof CallableMemberDescriptor) {
                collection = CollectionsKt.listOf((Object)descriptor2);
            } else if (declarationDescriptor instanceof ClassDescriptor) {
                Collection<ClassConstructorDescriptor> collection2 = ((ClassDescriptor)descriptor2).getConstructors();
                collection = collection2;
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"descriptor.constructors");
            } else {
                throw (Throwable)((Object)new AssertionError((Object)("Unexpected descriptor kind: " + descriptor2)));
            }
            return collection;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor2, (String)"DescriptorUtils.getConta\u2026: $descriptor\")\n        }");
        ModuleDescriptor containingModule = moduleDescriptor2;
        MemberScope containingPackageScope = containingModule.getPackage(((PackageFragmentDescriptor)containingPackage).getFqName()).getMemberScope();
        Name name2 = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"descriptor.name");
        Iterable iterable = $receiver$iv = (Iterable)getMembersByName.invoke((Object)containingPackageScope, (Object)name2);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv;
            if (!Intrinsics.areEqual((Object)DescriptorUtils.getContainingModule(it), (Object)containingModule)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List possibleOverloads = (List)destination$iv$iv;
        return overloadFilter.filterPackageMemberOverloads(possibleOverloads);
    }

    private final void checkOverloadsInClass(ClassDescriptorWithResolutionScopes classDescriptor2, Collection<? extends FunctionDescriptor> nestedClassConstructors) {
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"MultiMap.create<Name, CallableMemberDescriptor>()");
        MultiMap functionsByName = multiMap;
        Iterator<CallableMemberDescriptor> iterator2 = classDescriptor2.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            CallableMemberDescriptor callableMemberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor2 = callableMemberDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor2, (String)"function");
            functionsByName.putValue((Object)callableMemberDescriptor2.getName(), (Object)callableMemberDescriptor);
        }
        for (FunctionDescriptor functionDescriptor2 : nestedClassConstructors) {
            Name name2;
            DeclarationDescriptor declarationDescriptor = functionDescriptor2.getContainingDeclaration();
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"nestedConstructor.containingDeclaration");
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor.getName(), (String)"nestedConstructor.containingDeclaration.name");
            functionsByName.putValue((Object)name2, (Object)functionDescriptor2);
        }
        for (Map.Entry entry : functionsByName.entrySet()) {
            Object v = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"e.value");
            this.checkOverloadsInClass((Collection)v);
        }
    }

    private final void checkOverloadsInPackage(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        Object $receiver$iv;
        if (members2.size() == 1) {
            return;
        }
        LinkedHashMap redeclarationsMap = new LinkedHashMap();
        Object object = this.getPossibleRedeclarationGroups(members2).iterator();
        while (object.hasNext()) {
            Collection<DeclarationDescriptorNonRoot> redeclarationGroup = object.next();
            Collection<DeclarationDescriptorNonRoot> redeclarations = this.findRedeclarations(redeclarationGroup);
            $receiver$iv = redeclarations;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object object2;
                Map $receiver$iv2 = redeclarationsMap;
                Object element$iv = iterator2.next();
                DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                Object value$iv = $receiver$iv2.get(it);
                if (value$iv == null) {
                    Set answer$iv = new LinkedHashSet();
                    $receiver$iv2.put(it, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Set)object2).addAll(redeclarations);
            }
        }
        HashSet reported = new HashSet();
        $receiver$iv = redeclarationsMap;
        Iterator iterator3 = $receiver$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Object object3 = object = iterator3.next();
            DeclarationDescriptorNonRoot member = (DeclarationDescriptorNonRoot)object3.getKey();
            object3 = object;
            Set conflicting = (Set)object3.getValue();
            if (reported.contains(member)) continue;
            reported.addAll(conflicting);
            this.reportRedeclarations(conflicting);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Collection<DeclarationDescriptorNonRoot>> getPossibleRedeclarationGroups(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        void $receiver$iv$iv;
        Object element$iv$iv2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        ArrayList result2 = new ArrayList();
        Iterable iterable = $receiver$iv = (Iterable)members2;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv2 : $receiver$iv$iv2) {
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv2;
            if (!(!this.isPrivate(it))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List nonPrivates = (List)destination$iv$iv;
        Iterable $receiver$iv2 = members2;
        destination$iv$iv = $receiver$iv2;
        Map destination$iv$iv2 = new LinkedHashMap();
        element$iv$iv2 = $receiver$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv2;
            Object element$iv$iv3 = element$iv$iv2.next();
            DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv$iv3;
            SourceFile key$iv$iv = DescriptorUtils.getContainingSourceFile(it);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv3);
        }
        Map bySourceFile = destination$iv$iv2;
        boolean hasGroupIncludingNonPrivateMembers = false;
        for (List membersInFile : bySourceFile.values()) {
            boolean bl;
            block9: {
                Iterable $receiver$iv3 = membersInFile;
                if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv3) {
                        DeclarationDescriptorNonRoot it = (DeclarationDescriptorNonRoot)element$iv;
                        if (!this.isPrivate(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            hasGroupIncludingNonPrivateMembers = true;
            Set group = SetsKt.plus((Set)new LinkedHashSet(nonPrivates), (Iterable)membersInFile);
            result2.add(group);
        }
        if (!hasGroupIncludingNonPrivateMembers && nonPrivates.size() > 1) {
            result2.add(nonPrivates);
        }
        return result2;
    }

    private final boolean isPrivate(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof DeclarationDescriptorWithVisibility && Visibilities.isPrivate(((DeclarationDescriptorWithVisibility)$receiver).getVisibility());
    }

    private final void checkOverloadsInClass(Collection<? extends CallableMemberDescriptor> members2) {
        if (members2.size() == 1) {
            return;
        }
        this.reportRedeclarations(this.findRedeclarations(members2));
    }

    private final boolean isSynthesized(@NotNull DeclarationDescriptor $receiver) {
        return $receiver instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)$receiver).getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
    }

    private final Collection<DeclarationDescriptorNonRoot> findRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> members2) {
        LinkedHashSet<DeclarationDescriptorNonRoot> redeclarations = new LinkedHashSet<DeclarationDescriptorNonRoot>();
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : members2) {
            if (this.isSynthesized(declarationDescriptorNonRoot)) continue;
            for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 : members2) {
                if (Intrinsics.areEqual((Object)declarationDescriptorNonRoot, (Object)declarationDescriptorNonRoot2) || this.isConstructorsOfDifferentRedeclaredClasses(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isTopLevelMainInDifferentFiles(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isDefinitionsForDifferentPlatforms(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot, declarationDescriptorNonRoot2) || this.isExpectDeclarationAndDefinition(declarationDescriptorNonRoot2, declarationDescriptorNonRoot) || this.overloadChecker.isOverloadable(declarationDescriptorNonRoot, declarationDescriptorNonRoot2)) continue;
                redeclarations.add(declarationDescriptorNonRoot);
            }
        }
        return redeclarations;
    }

    private final boolean isConstructorsOfDifferentRedeclaredClasses(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!(member1 instanceof ConstructorDescriptor) || !(member2 instanceof ConstructorDescriptor)) {
            return false;
        }
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)member1).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters, (String)"member1.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent1 = classifierDescriptorWithTypeParameters;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = ((ConstructorDescriptor)member2).getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptorWithTypeParameters2, (String)"member2.containingDeclaration");
        ClassifierDescriptorWithTypeParameters parent2 = classifierDescriptorWithTypeParameters2;
        return parent1 != parent2 && Intrinsics.areEqual((Object)parent1.getContainingDeclaration(), (Object)parent2.getContainingDeclaration());
    }

    private final boolean isTopLevelMainInDifferentFiles(DeclarationDescriptor member1, DeclarationDescriptor member2) {
        if (!MainFunctionDetector.isMain$default(this.mainFunctionDetector, member1, false, false, false, 14, null) || !MainFunctionDetector.isMain$default(this.mainFunctionDetector, member2, false, false, false, 14, null)) {
            return false;
        }
        KtFile file1 = DescriptorToSourceUtils.getContainingFile(member1);
        KtFile file2 = DescriptorToSourceUtils.getContainingFile(member2);
        return file1 == null || file2 == null || file1 != file2;
    }

    private final boolean isExpectDeclarationAndDefinition(DeclarationDescriptor declaration2, DeclarationDescriptor definition) {
        return declaration2 instanceof MemberDescriptor && ((MemberDescriptor)declaration2).isExpect() && definition instanceof MemberDescriptor && !((MemberDescriptor)definition).isExpect();
    }

    private final boolean isDefinitionsForDifferentPlatforms(DeclarationDescriptorNonRoot member1, DeclarationDescriptorNonRoot member2) {
        if (!(member1 instanceof MemberDescriptor) || !(member2 instanceof MemberDescriptor)) {
            return false;
        }
        return ((MemberDescriptor)member1).isActual() && ((MemberDescriptor)member2).isActual() && Intrinsics.areEqual((Object)MultiTargetPlatformKt.getMultiTargetPlatform((MemberDescriptor)member1), (Object)MultiTargetPlatformKt.getMultiTargetPlatform((MemberDescriptor)member2)) ^ true;
    }

    private final void reportRedeclarations(Collection<? extends DeclarationDescriptorNonRoot> redeclarations) {
        if (redeclarations.isEmpty()) {
            return;
        }
        for (DeclarationDescriptorNonRoot declarationDescriptorNonRoot : redeclarations) {
            Diagnostic diagnostic;
            PsiElement it;
            BindingTrace bindingTrace;
            PsiElement psiElement2;
            PsiElement psiElement$iv;
            BindingTrace trace$iv;
            DeclarationDescriptorNonRoot declarationDescriptorNonRoot2 = declarationDescriptorNonRoot;
            if (declarationDescriptorNonRoot2 instanceof PropertyDescriptor || declarationDescriptorNonRoot2 instanceof ClassifierDescriptor) {
                trace$iv = this.trace;
                if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) != null) {
                    PsiElement psiElement3 = psiElement$iv = psiElement2;
                    bindingTrace = trace$iv;
                    ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.REDECLARATION.on(it, redeclarations);
                    Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.REDECLARATION.on(it, redeclarations)");
                    diagnostic = parametrizedDiagnostic;
                    bindingTrace.report(diagnostic);
                }
                continue;
            }
            if (!(declarationDescriptorNonRoot2 instanceof FunctionDescriptor)) continue;
            trace$iv = this.trace;
            if (DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptorNonRoot) == null) continue;
            it = psiElement$iv = psiElement2;
            bindingTrace = trace$iv;
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.CONFLICTING_OVERLOADS.on(it, redeclarations);
            Intrinsics.checkExpressionValueIsNotNull(parametrizedDiagnostic, (String)"Errors.CONFLICTING_OVERL\u2026DS.on(it, redeclarations)");
            diagnostic = parametrizedDiagnostic;
            bindingTrace.report(diagnostic);
        }
    }

    public OverloadResolver(@NotNull BindingTrace trace, @NotNull OverloadFilter overloadFilter, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)overloadFilter, (String)"overloadFilter");
        Intrinsics.checkParameterIsNotNull((Object)overloadChecker, (String)"overloadChecker");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.trace = trace;
        this.overloadFilter = overloadFilter;
        this.overloadChecker = overloadChecker;
        BindingContext bindingContext2 = this.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
        this.mainFunctionDetector = new MainFunctionDetector(bindingContext2, languageVersionSettings);
    }

    public static final /* synthetic */ Collection access$getModulePackageMembersWithSameName(OverloadResolver $this, DeclarationDescriptor descriptor2, OverloadFilter overloadFilter, Function2 getMembersByName) {
        return $this.getModulePackageMembersWithSameName(descriptor2, overloadFilter, (Function2<? super MemberScope, ? super Name, ? extends Collection<? extends DeclarationDescriptorNonRoot>>)getMembersByName);
    }
}

