/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KotlinStringLiteralTextEscaper;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtStringTemplateExpression
extends KtElementImplStub<KotlinPlaceHolderStub<KtStringTemplateExpression>>
implements KtExpression,
PsiLanguageInjectionHost {
    private static final TokenSet CLOSE_QUOTE_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{KtTokens.CLOSING_QUOTE});
    private static final TokenSet STRING_ENTRIES_TYPES = TokenSet.create((IElementType[])new IElementType[]{KtStubElementTypes.LONG_STRING_TEMPLATE_ENTRY, KtStubElementTypes.SHORT_STRING_TEMPLATE_ENTRY, KtStubElementTypes.LITERAL_STRING_TEMPLATE_ENTRY, KtStubElementTypes.ESCAPE_STRING_TEMPLATE_ENTRY});

    public KtStringTemplateExpression(@NotNull ASTNode node) {
        super(node);
    }

    public KtStringTemplateExpression(@NotNull KotlinPlaceHolderStub<KtStringTemplateExpression> stub) {
        super(stub, KtStubElementTypes.STRING_TEMPLATE);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        return KtExpressionImpl.Companion.replaceExpression(this, newElement, true, (Function1<? super PsiElement, ? extends PsiElement>)((Function1)x$0 -> super.replace(x$0)));
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitStringTemplateExpression(this, data);
    }

    @NotNull
    public KtStringTemplateEntry[] getEntries() {
        return (KtStringTemplateEntry[])this.getStubOrPsiChildren(STRING_ENTRIES_TYPES, (PsiElement[])KtStringTemplateEntry.EMPTY_ARRAY);
    }

    public boolean isValidHost() {
        return this.getNode().getChildren(CLOSE_QUOTE_TOKEN_SET).length != 0;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        KtExpression newExpression2 = new KtPsiFactory(this.getProject()).createExpressionIfPossible(text2);
        if (newExpression2 instanceof KtStringTemplateExpression) {
            return (KtStringTemplateExpression)this.replace((PsiElement)newExpression2);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text2);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new KotlinStringLiteralTextEscaper(this);
    }

    public boolean hasInterpolation() {
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof KtSimpleNameStringTemplateEntry) && !(child instanceof KtBlockStringTemplateEntry)) continue;
            return true;
        }
        return false;
    }
}

