/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.stubs.KotlinAnnotationEntryStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtAnnotationEntry
extends KtElementImplStub<KotlinAnnotationEntryStub>
implements KtCallElement {
    public KtAnnotationEntry(@NotNull ASTNode node) {
        super(node);
    }

    public KtAnnotationEntry(@NotNull KotlinAnnotationEntryStub stub) {
        super(stub, KtStubElementTypes.ANNOTATION_ENTRY);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitAnnotationEntry(this, data);
    }

    @IfNotParsed
    @Nullable
    public KtTypeReference getTypeReference() {
        KtConstructorCalleeExpression calleeExpression2 = this.getCalleeExpression();
        if (calleeExpression2 == null) {
            return null;
        }
        return calleeExpression2.getTypeReference();
    }

    @Override
    public KtConstructorCalleeExpression getCalleeExpression() {
        return (KtConstructorCalleeExpression)this.getStubOrPsiChild(KtStubElementTypes.CONSTRUCTOR_CALLEE);
    }

    @Override
    public KtValueArgumentList getValueArgumentList() {
        KotlinAnnotationEntryStub stub = (KotlinAnnotationEntryStub)this.getStub();
        if (stub == null && this.getGreenStub() != null) {
            return (KtValueArgumentList)this.findChildByType(KtNodeTypes.VALUE_ARGUMENT_LIST);
        }
        return (KtValueArgumentList)this.getStubOrPsiChild(KtStubElementTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        KotlinAnnotationEntryStub stub = (KotlinAnnotationEntryStub)this.getStub();
        if (stub != null && !stub.hasValueArguments()) {
            return Collections.emptyList();
        }
        KtValueArgumentList list2 = this.getValueArgumentList();
        return list2 != null ? list2.getArguments() : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<KtLambdaArgument> getLambdaArguments() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        if (typeArgumentList == null) {
            return Collections.emptyList();
        }
        return typeArgumentList.getArguments();
    }

    @Override
    public KtTypeArgumentList getTypeArgumentList() {
        KtTypeReference typeReference = this.getTypeReference();
        if (typeReference == null) {
            return null;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType) {
            KtUserType userType2 = (KtUserType)typeElement;
            return userType2.getTypeArgumentList();
        }
        return null;
    }

    @Nullable
    public PsiElement getAtSymbol() {
        return this.findChildByType(KtTokens.AT);
    }

    @Nullable
    public KtAnnotationUseSiteTarget getUseSiteTarget() {
        PsiElement parent2;
        KtAnnotationUseSiteTarget target = (KtAnnotationUseSiteTarget)this.getStubOrPsiChild(KtStubElementTypes.ANNOTATION_TARGET);
        if (target == null && (parent2 = this.getParentByStub()) instanceof KtAnnotation) {
            return ((KtAnnotation)parent2).getUseSiteTarget();
        }
        return target;
    }

    @Nullable
    public Name getShortName() {
        KtUserType userType2;
        String shortName;
        KotlinAnnotationEntryStub stub = (KotlinAnnotationEntryStub)this.getStub();
        if (stub != null) {
            String shortName2 = stub.getShortName();
            if (shortName2 != null) {
                return Name.identifier(shortName2);
            }
            return null;
        }
        KtTypeReference typeReference = this.getTypeReference();
        assert (typeReference != null) : "Annotation entry hasn't typeReference " + this.getText();
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement instanceof KtUserType && (shortName = (userType2 = (KtUserType)typeElement).getReferencedName()) != null) {
            return Name.identifier(shortName);
        }
        return null;
    }
}

