/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;

public abstract class CompositeFIF
implements FunctionIntrinsicFactory {
    @NotNull
    private final List<Pair<Predicate<FunctionDescriptor>, FunctionIntrinsic>> patternsAndIntrinsics = Lists.newArrayList();

    protected CompositeFIF() {
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @NotNull TranslationContext context) {
        for (Pair<Predicate<FunctionDescriptor>, FunctionIntrinsic> entry : this.patternsAndIntrinsics) {
            if (!((Predicate)entry.first).test(descriptor2)) continue;
            return (FunctionIntrinsic)entry.second;
        }
        return null;
    }

    protected void add(@NotNull Predicate<FunctionDescriptor> pattern, @NotNull FunctionIntrinsic intrinsic) {
        this.patternsAndIntrinsics.add((Pair<Predicate<FunctionDescriptor>, FunctionIntrinsic>)Pair.create(pattern, (Object)intrinsic));
    }
}

