/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.typePredicates.TypePredicatesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class PatternTranslator
extends AbstractTranslator {
    @NotNull
    public static PatternTranslator newInstance(@NotNull TranslationContext context) {
        return new PatternTranslator(context);
    }

    private PatternTranslator(@NotNull TranslationContext context) {
        super(context);
    }

    public static boolean isCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        return KtPsiUtil.isSafeCast(expression2) || KtPsiUtil.isUnsafeCast(expression2);
    }

    @NotNull
    public JsExpression translateCastExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2) {
        JsExpression onFail;
        assert (PatternTranslator.isCastExpression(expression2)) : "Expected cast expression, got " + expression2;
        KtExpression left = expression2.getLeft();
        JsExpression expressionToCast = Translation.translateAsExpression(left, this.context());
        KtTypeReference typeReference = expression2.getRight();
        assert (typeReference != null) : "Cast expression must have type reference";
        SimpleType anyType = this.context().getCurrentModule().getBuiltIns().getAnyType();
        expressionToCast = TranslationUtils.coerce(this.context(), expressionToCast, anyType);
        TemporaryVariable temporary = this.context().declareTemporary(expressionToCast, expression2);
        JsExpression isCheck = this.translateIsCheck(temporary.assignmentExpression(), typeReference);
        if (isCheck == null) {
            return expressionToCast;
        }
        if (KtPsiUtil.isSafeCast(expression2)) {
            onFail = new JsNullLiteral();
        } else {
            JsExpression throwCCEFunRef = this.context().getReferenceToIntrinsic("throwCCE");
            onFail = new JsInvocation(throwCCEFunRef, new JsExpression[0]);
        }
        JsConditional result2 = new JsConditional(isCheck, temporary.reference(), onFail);
        KotlinType targetType = BindingUtils.getTypeByReference(this.bindingContext(), typeReference);
        if (KtPsiUtil.isSafeCast(expression2)) {
            targetType = targetType.unwrap().makeNullableAsSpecified(true);
        }
        return TranslationUtils.coerce(this.context(), result2, targetType);
    }

    @NotNull
    public JsExpression translateIsExpression(@NotNull KtIsExpression expression2) {
        KtExpression left = expression2.getLeftHandSide();
        JsExpression expressionToCheck = Translation.translateAsExpression(left, this.context());
        SimpleType anyType = this.context().getCurrentModule().getBuiltIns().getAnyType();
        expressionToCheck = TranslationUtils.coerce(this.context(), expressionToCheck, anyType);
        KtTypeReference typeReference = expression2.getTypeReference();
        assert (typeReference != null);
        JsExpression result2 = this.translateIsCheck(expressionToCheck, typeReference);
        if (result2 == null) {
            return new JsBooleanLiteral(!expression2.isNegated());
        }
        if (expression2.isNegated()) {
            return JsAstUtils.not(result2);
        }
        return result2;
    }

    @Nullable
    public JsExpression translateIsCheck(@NotNull JsExpression subject, @NotNull KtTypeReference targetTypeReference) {
        KotlinType targetType = BindingUtils.getTypeByReference(this.bindingContext(), targetTypeReference);
        JsExpression checkFunReference = this.doGetIsTypeCheckCallable(targetType);
        if (checkFunReference == null) {
            return null;
        }
        boolean isReifiedType = TypeUtils.isReifiedTypeParameter(targetType);
        if (!isReifiedType && TypeUtils.isNullableType(targetType) || isReifiedType && KtPsiUtil.findChildByType(targetTypeReference, KtNodeTypes.NULLABLE_TYPE) != null) {
            checkFunReference = this.namer().orNull(checkFunReference);
        }
        return new JsInvocation(checkFunReference, subject);
    }

    @NotNull
    public JsExpression getIsTypeCheckCallable(@NotNull KotlinType type2) {
        JsExpression callable2 = this.doGetIsTypeCheckCallable(type2);
        assert (callable2 != null) : "This method should be called only to translate reified type parameters. `callable` should never be null for reified type parameters. Actual type: " + type2;
        if (!TypeUtils.isReifiedTypeParameter(type2) && TypeUtils.isNullableType(type2)) {
            return this.namer().orNull(callable2);
        }
        return callable2;
    }

    @Nullable
    private JsExpression doGetIsTypeCheckCallable(@NotNull KotlinType type2) {
        ClassifierDescriptor targetDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (targetDescriptor != null && AnnotationsUtils.isNativeInterface(targetDescriptor)) {
            return type2.isMarkedNullable() ? null : this.namer().isInstanceOf(JsAstUtils.pureFqn("Object", null));
        }
        JsExpression builtinCheck = this.getIsTypeCheckCallableForBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        builtinCheck = this.getIsTypeCheckCallableForPrimitiveBuiltin(type2);
        if (builtinCheck != null) {
            return builtinCheck;
        }
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull(type2);
        if (typeParameterDescriptor != null) {
            if (typeParameterDescriptor.isReified()) {
                return this.getIsTypeCheckCallableForReifiedType(typeParameterDescriptor);
            }
            JsExpression result2 = null;
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                JsExpression next2 = this.doGetIsTypeCheckCallable(upperBound);
                if (next2 == null) continue;
                result2 = result2 != null ? this.namer().andPredicate(result2, next2) : next2;
            }
            return result2;
        }
        ClassDescriptor referencedClass = DescriptorUtils.getClassDescriptorForType(type2);
        JsExpression typeName = ReferenceTranslator.translateAsTypeReference(referencedClass, this.context());
        return this.namer().isInstanceOf(typeName);
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForBuiltin(@NotNull KotlinType type2) {
        if (FunctionTypesKt.isFunctionTypeOrSubtype(type2) && !ReflectionTypes.isNumberedKPropertyOrKMutablePropertyType(type2)) {
            return this.namer().isTypeOf(new JsStringLiteral("function"));
        }
        if (KotlinBuiltIns.isArray(type2)) {
            if (ArrayFIF.typedArraysEnabled(this.context().getConfig())) {
                return this.namer().isArray();
            }
            return Namer.IS_ARRAY_FUN_REF;
        }
        if (TypePredicatesKt.getCHAR_SEQUENCE().test(type2)) {
            return this.namer().isCharSequence();
        }
        if (TypePredicatesKt.getCOMPARABLE().test(type2)) {
            return this.namer().isComparable();
        }
        return null;
    }

    @Nullable
    private JsExpression getIsTypeCheckCallableForPrimitiveBuiltin(@NotNull KotlinType type2) {
        Name typeName = DescriptorUtilsKt.getNameIfStandardType(type2);
        if (NamePredicate.STRING.test(typeName)) {
            return this.namer().isTypeOf(new JsStringLiteral("string"));
        }
        if (NamePredicate.BOOLEAN.test(typeName)) {
            return this.namer().isTypeOf(new JsStringLiteral("boolean"));
        }
        if (NamePredicate.LONG.test(typeName)) {
            return this.namer().isInstanceOf(Namer.kotlinLong());
        }
        if (NamePredicate.NUMBER.test(typeName)) {
            return this.namer().kotlin("isNumber");
        }
        if (NamePredicate.CHAR.test(typeName)) {
            return this.namer().kotlin("isChar");
        }
        if (NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS.test(typeName)) {
            return this.namer().isTypeOf(new JsStringLiteral("number"));
        }
        if (ArrayFIF.typedArraysEnabled(this.context().getConfig()) && KotlinBuiltIns.isPrimitiveArray(type2)) {
            PrimitiveType arrayType = KotlinBuiltIns.getPrimitiveArrayElementType(type2);
            assert (arrayType != null);
            return this.namer().isPrimitiveArray(arrayType);
        }
        return null;
    }

    @NotNull
    private JsExpression getIsTypeCheckCallableForReifiedType(@NotNull TypeParameterDescriptor typeParameter) {
        assert (typeParameter.isReified()) : "Expected reified type, actual: " + typeParameter;
        DeclarationDescriptor containingDeclaration2 = typeParameter.getContainingDeclaration();
        assert (containingDeclaration2 instanceof CallableDescriptor) : "Expected type parameter " + typeParameter + " to be contained in CallableDescriptor, actual: " + containingDeclaration2.getClass();
        JsExpression alias = this.context().getAliasForDescriptor(typeParameter);
        assert (alias != null) : "No alias found for reified type parameter: " + typeParameter;
        return alias;
    }

    @NotNull
    public JsExpression translateExpressionPattern(@NotNull KotlinType subjectType, @NotNull JsExpression expressionToMatch, @NotNull KtExpression patternExpression) {
        KotlinType patternType;
        KotlinType actualSubjectType;
        PrimitiveNumericComparisonInfo ieeeInfo = UtilsKt.getPrimitiveNumericComparisonInfo(this.context(), patternExpression);
        if (ieeeInfo != null) {
            actualSubjectType = ieeeInfo.getLeftType();
            patternType = ieeeInfo.getRightType();
        } else {
            actualSubjectType = UtilsKt.refineType(subjectType);
            patternType = UtilsKt.getPrecisePrimitiveTypeNotNull(this.context(), patternExpression);
        }
        EqualityType matchEquality = PatternTranslator.equalityType(actualSubjectType);
        EqualityType patternEquality = PatternTranslator.equalityType(patternType);
        JsExpression expressionToMatchAgainst = TranslationUtils.coerce(this.context(), this.translateExpressionForExpressionPattern(patternExpression), actualSubjectType);
        if (matchEquality == EqualityType.PRIMITIVE && patternEquality == EqualityType.PRIMITIVE) {
            return JsAstUtils.equality(expressionToMatch, expressionToMatchAgainst);
        }
        if (expressionToMatchAgainst instanceof JsNullLiteral) {
            return TranslationUtils.nullCheck(actualSubjectType, expressionToMatch, this.context(), false);
        }
        return TopLevelFIF.KOTLIN_EQUALS.apply(expressionToMatch, Collections.singletonList(expressionToMatchAgainst), this.context());
    }

    @NotNull
    private static EqualityType equalityType(@NotNull KotlinType type2) {
        ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return EqualityType.GENERAL;
        }
        PrimitiveType primitive = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitive == null) {
            return EqualityType.GENERAL;
        }
        return primitive == PrimitiveType.LONG ? EqualityType.LONG : EqualityType.PRIMITIVE;
    }

    @NotNull
    public JsExpression translateExpressionForExpressionPattern(@NotNull KtExpression patternExpression) {
        return Translation.translateAsExpression(patternExpression, this.context());
    }

    private static enum EqualityType {
        PRIMITIVE,
        LONG,
        GENERAL;

    }
}

