/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.InlineUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

public class DestructuringDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final KtDestructuringDeclaration multiDeclaration;
    @NotNull
    private final JsExpression multiObjectExpr;

    @NotNull
    public static JsVars translate(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsExpression multiObjectExpr, @NotNull TranslationContext context) {
        return new DestructuringDeclarationTranslator(multiDeclaration, multiObjectExpr, context).translate();
    }

    private DestructuringDeclarationTranslator(@NotNull KtDestructuringDeclaration multiDeclaration, @NotNull JsExpression multiObjectExpr, @NotNull TranslationContext context) {
        super(context);
        this.multiDeclaration = multiDeclaration;
        this.multiObjectExpr = multiObjectExpr;
    }

    private JsVars translate() {
        ArrayList<JsVars.JsVar> jsVars = new ArrayList<JsVars.JsVar>();
        for (KtDestructuringDeclarationEntry entry : this.multiDeclaration.getEntries()) {
            VariableDescriptor descriptor2 = BindingContextUtils.getNotNull(this.context().bindingContext(), BindingContext.VARIABLE, entry);
            if (descriptor2.getName().isSpecial()) continue;
            ResolvedCall<FunctionDescriptor> entryInitCall = this.context().bindingContext().get(BindingContext.COMPONENT_RESOLVED_CALL, entry);
            assert (entryInitCall != null) : "Entry init call must be not null";
            JsExpression entryInitializer = CallTranslator.translate(this.context(), entryInitCall, this.multiObjectExpr);
            FunctionDescriptor candidateDescriptor = entryInitCall.getCandidateDescriptor();
            if (CallExpressionTranslator.shouldBeInlined(candidateDescriptor, this.context())) {
                InlineUtils.setInlineCallMetadata(entryInitializer, (KtElement)entry, entryInitCall, this.context());
            }
            entryInitializer = TranslationUtils.coerce(this.context(), entryInitializer, descriptor2.getType());
            JsName name2 = this.context().getNameForDescriptor(descriptor2);
            if (BindingContextUtils.isBoxedLocalCapturedInClosure(this.context().bindingContext(), descriptor2)) {
                JsNameRef alias = Namer.getCapturedVarAccessor(name2.makeRef());
                entryInitializer = JsAstUtils.wrapValue(alias, entryInitializer);
            }
            JsVars.JsVar jsVar = new JsVars.JsVar(name2, entryInitializer);
            jsVar.setSource(entry);
            jsVars.add(jsVar);
        }
        JsVars result2 = new JsVars(jsVars, true);
        result2.setSource(this.multiDeclaration);
        return result2;
    }
}

