/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.psi.KtExpression;

public class AliasingContext {
    @Nullable
    private final Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<KtExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    @NotNull
    public static AliasingContext getCleanContext() {
        return new AliasingContext(null, null, null);
    }

    private AliasingContext(@Nullable AliasingContext parent2, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<KtExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent2;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner() {
        return new AliasingContext(this, null, null);
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor2, @NotNull JsExpression alias) {
        return new AliasingContext(this, Collections.singletonMap(descriptor2, alias), null);
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<KtExpression, JsExpression> aliasesForExpressions) {
        return new AliasingContext(this, null, aliasesForExpressions);
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        return new AliasingContext(this, aliases, null);
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        JsExpression alias = this.aliasesForDescriptors != null ? this.aliasesForDescriptors.get(descriptor2.getOriginal()) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor2);
        return result2 != null ? result2.deepCopy() : null;
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull KtExpression element3) {
        JsExpression alias = this.aliasesForExpressions != null ? this.aliasesForExpressions.get(element3) : null;
        JsExpression result2 = alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element3);
        return result2 != null ? result2.deepCopy() : null;
    }
}

